/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerLanding
extends AbstractDragonController {
    @Nullable
    private Vec3D targetLocation;

    public DragonControllerLanding(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doClientTick() {
        Vec3D var0 = this.dragon.getHeadLookVector(1.0f).normalize();
        var0.yRot(-0.7853982f);
        double var1 = this.dragon.head.getX();
        double var3 = this.dragon.head.getY(0.5);
        double var5 = this.dragon.head.getZ();
        for (int var7 = 0; var7 < 8; ++var7) {
            RandomSource var8 = this.dragon.getRandom();
            double var9 = var1 + var8.nextGaussian() / 2.0;
            double var11 = var3 + var8.nextGaussian() / 2.0;
            double var13 = var5 + var8.nextGaussian() / 2.0;
            Vec3D var15 = this.dragon.getDeltaMovement();
            this.dragon.level().addParticle(Particles.DRAGON_BREATH, var9, var11, var13, -var0.x * (double)0.08f + var15.x, -var0.y * (double)0.3f + var15.y, -var0.z * (double)0.08f + var15.z);
            var0.yRot(0.19634955f);
        }
    }

    @Override
    public void doServerTick(WorldServer var0) {
        if (this.targetLocation == null) {
            this.targetLocation = Vec3D.atBottomCenterOf(var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.dragon.getFightOrigin())));
        }
        if (this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ()) < 1.0) {
            this.dragon.getPhaseManager().getPhase(DragonControllerPhase.SITTING_FLAMING).resetFlameCount();
            this.dragon.getPhaseManager().setPhase(DragonControllerPhase.SITTING_SCANNING);
        }
    }

    @Override
    public float getFlySpeed() {
        return 1.5f;
    }

    @Override
    public float getTurnSpeed() {
        float var0 = (float)this.dragon.getDeltaMovement().horizontalDistance() + 1.0f;
        float var1 = Math.min(var0, 40.0f);
        return var1 / var0;
    }

    @Override
    public void begin() {
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    public DragonControllerPhase<DragonControllerLanding> getPhase() {
        return DragonControllerPhase.LANDING;
    }
}

