/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> DATA_PUMPKIN_ID = DataWatcher.defineId(EntitySnowman.class, DataWatcherRegistry.BYTE);
    private static final byte PUMPKIN_FLAG = 16;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> var0, World var1) {
        super((EntityTypes<? extends EntityGolem>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.goalSelector.addGoal(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(4, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, (var0, var1) -> var0 instanceof IMonster));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 4.0).add(GenericAttributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_PUMPKIN_ID, (byte)16);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("Pumpkin", this.hasPumpkin());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("Pumpkin")) {
            this.setPumpkin(var0.getBoolean("Pumpkin"));
        }
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            if (this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
                this.hurtServer(var0, this.damageSources().onFire(), 1.0f);
            }
            if (!var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return;
            }
            IBlockData var1 = Blocks.SNOW.defaultBlockState();
            for (int var2 = 0; var2 < 4; ++var2) {
                int var3 = MathHelper.floor(this.getX() + (double)((float)(var2 % 2 * 2 - 1) * 0.25f));
                int var4 = MathHelper.floor(this.getY());
                int var5 = MathHelper.floor(this.getZ() + (double)((float)(var2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition var6 = new BlockPosition(var3, var4, var5);
                if (!this.level().getBlockState(var6).isAir() || !var1.canSurvive(this.level(), var6)) continue;
                this.level().setBlockAndUpdate(var6, var1);
                this.level().gameEvent(GameEvent.BLOCK_PLACE, var6, GameEvent.a.of(this, var1));
            }
        }
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        double var2 = var0.getX() - this.getX();
        double var4 = var0.getEyeY() - (double)1.1f;
        double var6 = var0.getZ() - this.getZ();
        double var82 = Math.sqrt(var2 * var2 + var6 * var6) * (double)0.2f;
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var10 = (WorldServer)world;
            ItemStack var11 = new ItemStack(Items.SNOWBALL);
            IProjectile.spawnProjectile(new EntitySnowball(var10, this, var11), var10, var11, var8 -> var8.shoot(var2, var4 + var82 - var8.getY(), var6, 1.6f, 12.0f));
        }
        this.playSound(SoundEffects.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.SHEARS) && this.readyForShearing()) {
            World world = this.level();
            if (world instanceof WorldServer) {
                WorldServer var3 = (WorldServer)world;
                this.shear(var3, SoundCategory.PLAYERS, var2);
                this.gameEvent(GameEvent.SHEAR, var0);
                var2.hurtAndBreak(1, var0, EntitySnowman.getSlotForHand(var1));
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void shear(WorldServer var02, SoundCategory var12, ItemStack var2) {
        var02.playSound(null, this, SoundEffects.SNOW_GOLEM_SHEAR, var12, 1.0f, 1.0f);
        this.setPumpkin(false);
        this.dropFromShearingLootTable(var02, LootTables.SHEAR_SNOW_GOLEM, var2, (var0, var1) -> this.spawnAtLocation((WorldServer)var0, (ItemStack)var1, this.getEyeHeight()));
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && this.hasPumpkin();
    }

    public boolean hasPumpkin() {
        return (this.entityData.get(DATA_PUMPKIN_ID) & 0x10) != 0;
    }

    public void setPumpkin(boolean var0) {
        byte var1 = this.entityData.get(DATA_PUMPKIN_ID);
        if (var0) {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(var1 | 0x10));
        } else {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(var1 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SNOW_GOLEM_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SNOW_GOLEM_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.SNOW_GOLEM_DEATH;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.75f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }
}

