/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final DataWatcherObject<Byte> DATA_WOOL_ID = DataWatcher.defineId(EntitySheep.class, DataWatcherRegistry.BYTE);
    private static final Map<EnumColor, Integer> COLOR_BY_DYE = Maps.newEnumMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(var0 -> var0, EntitySheep::createSheepColor)));
    private int eatAnimationTick;
    private PathfinderGoalEatTile eatBlockGoal;

    private static int createSheepColor(EnumColor var0) {
        if (var0 == EnumColor.WHITE) {
            return -1644826;
        }
        int var1 = var0.getTextureDiffuseColor();
        float var2 = 0.75f;
        return ARGB.color(255, MathHelper.floor((float)ARGB.red(var1) * 0.75f), MathHelper.floor((float)ARGB.green(var1) * 0.75f), MathHelper.floor((float)ARGB.blue(var1) * 0.75f));
    }

    public static int getColor(EnumColor var0) {
        return COLOR_BY_DYE.get(var0);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.eatBlockGoal = new PathfinderGoalEatTile(this);
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.25));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.1, var0 -> var0.is(TagsItem.SHEEP_FOOD), false));
        this.goalSelector.addGoal(4, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.addGoal(5, this.eatBlockGoal);
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.SHEEP_FOOD);
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep(var0);
    }

    @Override
    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 8.0).add(GenericAttributes.MOVEMENT_SPEED, 0.23f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_WOOL_ID, (byte)0);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public float getHeadEatPositionScale(float var0) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        if (this.eatAnimationTick < 4) {
            return ((float)this.eatAnimationTick - var0) / 4.0f;
        }
        return -((float)(this.eatAnimationTick - 40) - var0) / 4.0f;
    }

    public float getHeadEatAngleScale(float var0) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float var1 = ((float)(this.eatAnimationTick - 4) - var0) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.sin(var1 * 28.7f);
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.getXRot() * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.SHEARS)) {
            World world = this.level();
            if (world instanceof WorldServer) {
                WorldServer var3 = (WorldServer)world;
                if (this.readyForShearing()) {
                    this.shear(var3, SoundCategory.PLAYERS, var2);
                    this.gameEvent(GameEvent.SHEAR, var0);
                    var2.hurtAndBreak(1, var0, EntitySheep.getSlotForHand(var1));
                    return EnumInteractionResult.SUCCESS_SERVER;
                }
            }
            return EnumInteractionResult.CONSUME;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public void shear(WorldServer var02, SoundCategory var12, ItemStack var2) {
        var02.playSound(null, this, SoundEffects.SHEEP_SHEAR, var12, 1.0f, 1.0f);
        this.dropFromShearingLootTable(var02, LootTables.SHEAR_SHEEP, var2, (var0, var1) -> {
            for (int var2 = 0; var2 < var1.getCount(); ++var2) {
                EntityItem var3 = this.spawnAtLocation((WorldServer)var0, var1.copyWithCount(1), 1.0f);
                if (var3 == null) continue;
                var3.setDeltaMovement(var3.getDeltaMovement().add((this.random.nextFloat() - this.random.nextFloat()) * 0.1f, this.random.nextFloat() * 0.05f, (this.random.nextFloat() - this.random.nextFloat()) * 0.1f));
            }
        });
        this.setSheared(true);
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("Sheared", this.isSheared());
        var0.putByte("Color", (byte)this.getColor().getId());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setSheared(var0.getBoolean("Sheared"));
        this.setColor(EnumColor.byId(var0.getByte("Color")));
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SHEEP_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SHEEP_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SHEEP_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.SHEEP_STEP, 0.15f, 1.0f);
    }

    public EnumColor getColor() {
        return EnumColor.byId(this.entityData.get(DATA_WOOL_ID) & 0xF);
    }

    public void setColor(EnumColor var0) {
        byte var1 = this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (byte)(var1 & 0xF0 | var0.getId() & 0xF));
    }

    public boolean isSheared() {
        return (this.entityData.get(DATA_WOOL_ID) & 0x10) != 0;
    }

    public void setSheared(boolean var0) {
        byte var1 = this.entityData.get(DATA_WOOL_ID);
        if (var0) {
            this.entityData.set(DATA_WOOL_ID, (byte)(var1 | 0x10));
        } else {
            this.entityData.set(DATA_WOOL_ID, (byte)(var1 & 0xFFFFFFEF));
        }
    }

    public static EnumColor getRandomSheepColor(RandomSource var0) {
        int var1 = var0.nextInt(100);
        if (var1 < 5) {
            return EnumColor.BLACK;
        }
        if (var1 < 10) {
            return EnumColor.GRAY;
        }
        if (var1 < 15) {
            return EnumColor.LIGHT_GRAY;
        }
        if (var1 < 18) {
            return EnumColor.BROWN;
        }
        if (var0.nextInt(500) == 0) {
            return EnumColor.PINK;
        }
        return EnumColor.WHITE;
    }

    @Override
    @Nullable
    public EntitySheep getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntitySheep var2 = EntityTypes.SHEEP.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null) {
            EnumColor var3 = this.getColor();
            EnumColor var4 = ((EntitySheep)var1).getColor();
            var2.setColor(EnumColor.getMixedColor(var0, var3, var4));
        }
        return var2;
    }

    @Override
    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        this.setColor(EntitySheep.getRandomSheepColor(var0.getRandom()));
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

