/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;

public class EntityMushroomCow
extends EntityCow
implements IShearable,
VariantHolder<Type> {
    private static final DataWatcherObject<String> DATA_TYPE = DataWatcher.defineId(EntityMushroomCow.class, DataWatcherRegistry.STRING);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    public SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> var0, World var1) {
        super((EntityTypes<? extends EntityCow>)var0, var1);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0.below()).is(Blocks.MYCELIUM)) {
            return 10.0f;
        }
        return var1.getPathfindingCostFromLightLevels(var0);
    }

    public static boolean checkMushroomSpawnRules(EntityTypes<EntityMushroomCow> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.MOOSHROOMS_SPAWNABLE_ON) && EntityMushroomCow.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
        UUID var2 = var1.getUUID();
        if (!var2.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Type.RED ? Type.BROWN : Type.RED);
            this.lastLightningBoltUUID = var2;
            this.playSound(SoundEffects.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_TYPE, Type.RED.type);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.BOWL) && !this.isBaby()) {
            ItemStack var3;
            boolean var4 = false;
            if (this.stewEffects != null) {
                var4 = true;
                var3 = new ItemStack(Items.SUSPICIOUS_STEW);
                var3.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                var3 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack var5 = ItemLiquidUtil.createFilledResult(var2, var0, var3, false);
            var0.setItemInHand(var1, var5);
            SoundEffect var6 = var4 ? SoundEffects.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEffects.MOOSHROOM_MILK;
            this.playSound(var6, 1.0f, 1.0f);
            return EnumInteractionResult.SUCCESS;
        }
        if (var2.is(Items.SHEARS) && this.readyForShearing()) {
            World var4 = this.level();
            if (var4 instanceof WorldServer) {
                WorldServer var3 = (WorldServer)var4;
                this.shear(var3, SoundCategory.PLAYERS, var2);
                this.gameEvent(GameEvent.SHEAR, var0);
                var2.hurtAndBreak(1, var0, EntityMushroomCow.getSlotForHand(var1));
            }
            return EnumInteractionResult.SUCCESS;
        }
        if (this.getVariant() == Type.BROWN) {
            Optional<SuspiciousStewEffects> var3 = this.getEffectsFromItemStack(var2);
            if (var3.isEmpty()) {
                return super.mobInteract(var0, var1);
            }
            if (this.stewEffects != null) {
                for (int var4 = 0; var4 < 2; ++var4) {
                    this.level().addParticle(Particles.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                var2.consume(1, var0);
                for (int var4 = 0; var4 < 4; ++var4) {
                    this.level().addParticle(Particles.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = var3.get();
                this.playSound(SoundEffects.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public void shear(WorldServer var0, SoundCategory var1, ItemStack var22) {
        var0.playSound(null, this, SoundEffects.MOOSHROOM_SHEAR, var1, 1.0f, 1.0f);
        this.convertTo(EntityTypes.COW, ConversionParams.single(this, false, false), var2 -> {
            var0.sendParticles(Particles.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(var0, LootTables.SHEAR_MOOSHROOM, var22, (var0, var1) -> {
                for (EntityInsentient var2 = 0; var2 < var1.getCount(); ++var2) {
                    var0.addFreshEntity(new EntityItem(this.level(), this.getX(), this.getY(1.0), this.getZ(), var1.copyWithCount(1)));
                }
            });
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("Type", this.getVariant().getSerializedName());
        if (this.stewEffects != null) {
            SuspiciousStewEffects.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.stewEffects).ifSuccess(var1 -> var0.put(TAG_STEW_EFFECTS, (NBTBase)var1));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        this.setVariant(Type.byName(var02.getString("Type")));
        if (var02.contains(TAG_STEW_EFFECTS, 9)) {
            SuspiciousStewEffects.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_STEW_EFFECTS)).ifSuccess(var0 -> {
                this.stewEffects = var0;
            });
        }
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack var0) {
        SuspiciousEffectHolder var1 = SuspiciousEffectHolder.tryGet(var0.getItem());
        if (var1 != null) {
            return Optional.of(var1.getSuspiciousEffects());
        }
        return Optional.empty();
    }

    @Override
    public void setVariant(Type var0) {
        this.entityData.set(DATA_TYPE, var0.type);
    }

    @Override
    public Type getVariant() {
        return Type.byName(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public EntityMushroomCow getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityMushroomCow var2 = EntityTypes.MOOSHROOM.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null) {
            var2.setVariant(this.getOffspringVariant((EntityMushroomCow)var1));
        }
        return var2;
    }

    private Type getOffspringVariant(EntityMushroomCow var0) {
        Type var2;
        Type var1 = this.getVariant();
        Type var3 = var1 == (var2 = var0.getVariant()) && this.random.nextInt(1024) == 0 ? (var1 == Type.BROWN ? Type.RED : Type.BROWN) : (this.random.nextBoolean() ? var1 : var2);
        return var3;
    }

    @Override
    @Nullable
    public /* synthetic */ EntityCow getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type RED = new Type("red", Blocks.RED_MUSHROOM.defaultBlockState());
        public static final /* enum */ Type BROWN = new Type("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());
        public static final INamable.a<Type> CODEC;
        final String type;
        private final IBlockData blockState;
        private static final /* synthetic */ Type[] f;

        public static Type[] values() {
            return (Type[])f.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2, IBlockData var3) {
            this.type = var2;
            this.blockState = var3;
        }

        public IBlockData getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static Type byName(String var0) {
            return CODEC.byName(var0, RED);
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{RED, BROWN};
        }

        static {
            f = Type.b();
            CODEC = INamable.fromEnum(Type::values);
        }
    }
}

