/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityIronGolem.class, DataWatcherRegistry.BYTE);
    private static final int IRON_INGOT_HEAL_AMOUNT = 25;
    private int attackAnimationTick;
    private int offerFlowerTick;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> var0, World var1) {
        super((EntityTypes<? extends EntityGolem>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.addGoal(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.goalSelector.addGoal(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.goalSelector.addGoal(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.goalSelector.addGoal(5, new PathfinderGoalOfferFlower(this));
        this.goalSelector.addGoal(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalDefendVillage(this));
        this.targetSelector.addGoal(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, (var0, var1) -> var0 instanceof IMonster && !(var0 instanceof EntityCreeper)));
        this.targetSelector.addGoal(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_FLAGS_ID, (byte)0);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 100.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25).add(GenericAttributes.KNOCKBACK_RESISTANCE, 1.0).add(GenericAttributes.ATTACK_DAMAGE, 15.0).add(GenericAttributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected int decreaseAirSupply(int var0) {
        return var0;
    }

    @Override
    protected void doPush(Entity var0) {
        if (var0 instanceof IMonster && !(var0 instanceof EntityCreeper) && this.getRandom().nextInt(20) == 0) {
            this.setTarget((EntityLiving)var0);
        }
        super.doPush(var0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.offerFlowerTick > 0) {
            --this.offerFlowerTick;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((WorldServer)this.level(), true);
        }
    }

    @Override
    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0;
    }

    @Override
    public boolean canAttackType(EntityTypes<?> var0) {
        if (this.isPlayerCreated() && var0 == EntityTypes.PLAYER) {
            return false;
        }
        if (var0 == EntityTypes.CREEPER) {
            return false;
        }
        return super.canAttackType(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("PlayerCreated", this.isPlayerCreated());
        this.addPersistentAngerSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setPlayerCreated(var0.getBoolean("PlayerCreated"));
        this.readPersistentAngerSaveData(this.level(), var0);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public void setRemainingPersistentAngerTime(int var0) {
        this.remainingPersistentAngerTime = var0;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID var0) {
        this.persistentAngerTarget = var0;
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    private float getAttackDamage() {
        return (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        this.attackAnimationTick = 10;
        var0.broadcastEntityEvent(this, (byte)4);
        float var2 = this.getAttackDamage();
        float var3 = (int)var2 > 0 ? var2 / 2.0f + (float)this.random.nextInt((int)var2) : var2;
        DamageSource var4 = this.damageSources().mobAttack(this);
        boolean var5 = var1.hurtServer(var0, var4, var3);
        if (var5) {
            double d2;
            if (var1 instanceof EntityLiving) {
                EntityLiving var8 = (EntityLiving)var1;
                d2 = var8.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE);
            } else {
                d2 = 0.0;
            }
            double var6 = d2;
            double var8 = Math.max(0.0, 1.0 - var6);
            var1.setDeltaMovement(var1.getDeltaMovement().add(0.0, (double)0.4f * var8, 0.0));
            EnchantmentManager.doPostAttackEffects(var0, var1, var4);
        }
        this.playSound(SoundEffects.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        return var5;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Crackiness.a var3 = this.getCrackiness();
        boolean var4 = super.hurtServer(var0, var1, var2);
        if (var4 && this.getCrackiness() != var3) {
            this.playSound(SoundEffects.IRON_GOLEM_DAMAGE, 1.0f, 1.0f);
        }
        return var4;
    }

    public Crackiness.a getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.attackAnimationTick = 10;
            this.playSound(SoundEffects.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        } else if (var0 == 11) {
            this.offerFlowerTick = 400;
        } else if (var0 == 34) {
            this.offerFlowerTick = 0;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public void offerFlower(boolean var0) {
        if (var0) {
            this.offerFlowerTick = 400;
            this.level().broadcastEntityEvent(this, (byte)11);
        } else {
            this.offerFlowerTick = 0;
            this.level().broadcastEntityEvent(this, (byte)34);
        }
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.IRON_GOLEM_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.IRON_GOLEM_DEATH;
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (!var2.is(Items.IRON_INGOT)) {
            return EnumInteractionResult.PASS;
        }
        float var3 = this.getHealth();
        this.heal(25.0f);
        if (this.getHealth() == var3) {
            return EnumInteractionResult.PASS;
        }
        float var4 = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
        this.playSound(SoundEffects.IRON_GOLEM_REPAIR, 1.0f, var4);
        var2.consume(1, var0);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.IRON_GOLEM_STEP, 1.0f, 1.0f);
    }

    public int getOfferFlowerTick() {
        return this.offerFlowerTick;
    }

    public boolean isPlayerCreated() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setPlayerCreated(boolean var0) {
        byte var1 = this.entityData.get(DATA_FLAGS_ID);
        if (var0) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(var1 | 1));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(var1 & 0xFFFFFFFE));
        }
    }

    @Override
    public void die(DamageSource var0) {
        super.die(var0);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        BlockPosition var1 = this.blockPosition();
        BlockPosition var2 = var1.below();
        IBlockData var3 = var0.getBlockState(var2);
        if (var3.entityCanStandOn(var0, var2, this)) {
            for (int var4 = 1; var4 < 3; ++var4) {
                IBlockData var6;
                BlockPosition var5 = var1.above(var4);
                if (SpawnerCreature.isValidEmptySpawnBlock(var0, var5, var6 = var0.getBlockState(var5), var6.getFluidState(), EntityTypes.IRON_GOLEM)) continue;
                return false;
            }
            return SpawnerCreature.isValidEmptySpawnBlock(var0, var1, var0.getBlockState(var1), FluidTypes.EMPTY.defaultFluidState(), EntityTypes.IRON_GOLEM) && var0.isUnobstructed(this);
        }
        return false;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.875f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }
}

