/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;

public class PoiTypes {
    public static final ResourceKey<VillagePlaceType> ARMORER = PoiTypes.createKey("armorer");
    public static final ResourceKey<VillagePlaceType> BUTCHER = PoiTypes.createKey("butcher");
    public static final ResourceKey<VillagePlaceType> CARTOGRAPHER = PoiTypes.createKey("cartographer");
    public static final ResourceKey<VillagePlaceType> CLERIC = PoiTypes.createKey("cleric");
    public static final ResourceKey<VillagePlaceType> FARMER = PoiTypes.createKey("farmer");
    public static final ResourceKey<VillagePlaceType> FISHERMAN = PoiTypes.createKey("fisherman");
    public static final ResourceKey<VillagePlaceType> FLETCHER = PoiTypes.createKey("fletcher");
    public static final ResourceKey<VillagePlaceType> LEATHERWORKER = PoiTypes.createKey("leatherworker");
    public static final ResourceKey<VillagePlaceType> LIBRARIAN = PoiTypes.createKey("librarian");
    public static final ResourceKey<VillagePlaceType> MASON = PoiTypes.createKey("mason");
    public static final ResourceKey<VillagePlaceType> SHEPHERD = PoiTypes.createKey("shepherd");
    public static final ResourceKey<VillagePlaceType> TOOLSMITH = PoiTypes.createKey("toolsmith");
    public static final ResourceKey<VillagePlaceType> WEAPONSMITH = PoiTypes.createKey("weaponsmith");
    public static final ResourceKey<VillagePlaceType> HOME = PoiTypes.createKey("home");
    public static final ResourceKey<VillagePlaceType> MEETING = PoiTypes.createKey("meeting");
    public static final ResourceKey<VillagePlaceType> BEEHIVE = PoiTypes.createKey("beehive");
    public static final ResourceKey<VillagePlaceType> BEE_NEST = PoiTypes.createKey("bee_nest");
    public static final ResourceKey<VillagePlaceType> NETHER_PORTAL = PoiTypes.createKey("nether_portal");
    public static final ResourceKey<VillagePlaceType> LODESTONE = PoiTypes.createKey("lodestone");
    public static final ResourceKey<VillagePlaceType> LIGHTNING_ROD = PoiTypes.createKey("lightning_rod");
    private static final Set<IBlockData> BEDS = (Set)ImmutableList.of((Object)Blocks.RED_BED, (Object)Blocks.BLACK_BED, (Object)Blocks.BLUE_BED, (Object)Blocks.BROWN_BED, (Object)Blocks.CYAN_BED, (Object)Blocks.GRAY_BED, (Object)Blocks.GREEN_BED, (Object)Blocks.LIGHT_BLUE_BED, (Object)Blocks.LIGHT_GRAY_BED, (Object)Blocks.LIME_BED, (Object)Blocks.MAGENTA_BED, (Object)Blocks.ORANGE_BED, (Object[])new Block[]{Blocks.PINK_BED, Blocks.PURPLE_BED, Blocks.WHITE_BED, Blocks.YELLOW_BED}).stream().flatMap(var0 -> var0.getStateDefinition().getPossibleStates().stream()).filter(var0 -> var0.getValue(BlockBed.PART) == BlockPropertyBedPart.HEAD).collect(ImmutableSet.toImmutableSet());
    private static final Set<IBlockData> CAULDRONS = (Set)ImmutableList.of((Object)Blocks.CAULDRON, (Object)Blocks.LAVA_CAULDRON, (Object)Blocks.WATER_CAULDRON, (Object)Blocks.POWDER_SNOW_CAULDRON).stream().flatMap(var0 -> var0.getStateDefinition().getPossibleStates().stream()).collect(ImmutableSet.toImmutableSet());
    private static final Map<IBlockData, Holder<VillagePlaceType>> TYPE_BY_STATE = Maps.newHashMap();

    private static Set<IBlockData> getBlockStates(Block var0) {
        return ImmutableSet.copyOf(var0.getStateDefinition().getPossibleStates());
    }

    private static ResourceKey<VillagePlaceType> createKey(String var0) {
        return ResourceKey.create(Registries.POINT_OF_INTEREST_TYPE, MinecraftKey.withDefaultNamespace(var0));
    }

    private static VillagePlaceType register(IRegistry<VillagePlaceType> var0, ResourceKey<VillagePlaceType> var1, Set<IBlockData> var2, int var3, int var4) {
        VillagePlaceType var5 = new VillagePlaceType(var2, var3, var4);
        IRegistry.register(var0, var1, var5);
        PoiTypes.registerBlockStates(var0.getOrThrow(var1), var2);
        return var5;
    }

    private static void registerBlockStates(Holder<VillagePlaceType> var0, Set<IBlockData> var12) {
        var12.forEach(var1 -> {
            Holder<VillagePlaceType> var2 = TYPE_BY_STATE.put((IBlockData)var1, var0);
            if (var2 != null) {
                throw SystemUtils.pauseInIde(new IllegalStateException(String.format(Locale.ROOT, "%s is defined in more than one PoI type", var1)));
            }
        });
    }

    public static Optional<Holder<VillagePlaceType>> forState(IBlockData var0) {
        return Optional.ofNullable(TYPE_BY_STATE.get(var0));
    }

    public static boolean hasPoi(IBlockData var0) {
        return TYPE_BY_STATE.containsKey(var0);
    }

    public static VillagePlaceType bootstrap(IRegistry<VillagePlaceType> var0) {
        PoiTypes.register(var0, ARMORER, PoiTypes.getBlockStates(Blocks.BLAST_FURNACE), 1, 1);
        PoiTypes.register(var0, BUTCHER, PoiTypes.getBlockStates(Blocks.SMOKER), 1, 1);
        PoiTypes.register(var0, CARTOGRAPHER, PoiTypes.getBlockStates(Blocks.CARTOGRAPHY_TABLE), 1, 1);
        PoiTypes.register(var0, CLERIC, PoiTypes.getBlockStates(Blocks.BREWING_STAND), 1, 1);
        PoiTypes.register(var0, FARMER, PoiTypes.getBlockStates(Blocks.COMPOSTER), 1, 1);
        PoiTypes.register(var0, FISHERMAN, PoiTypes.getBlockStates(Blocks.BARREL), 1, 1);
        PoiTypes.register(var0, FLETCHER, PoiTypes.getBlockStates(Blocks.FLETCHING_TABLE), 1, 1);
        PoiTypes.register(var0, LEATHERWORKER, CAULDRONS, 1, 1);
        PoiTypes.register(var0, LIBRARIAN, PoiTypes.getBlockStates(Blocks.LECTERN), 1, 1);
        PoiTypes.register(var0, MASON, PoiTypes.getBlockStates(Blocks.STONECUTTER), 1, 1);
        PoiTypes.register(var0, SHEPHERD, PoiTypes.getBlockStates(Blocks.LOOM), 1, 1);
        PoiTypes.register(var0, TOOLSMITH, PoiTypes.getBlockStates(Blocks.SMITHING_TABLE), 1, 1);
        PoiTypes.register(var0, WEAPONSMITH, PoiTypes.getBlockStates(Blocks.GRINDSTONE), 1, 1);
        PoiTypes.register(var0, HOME, BEDS, 1, 1);
        PoiTypes.register(var0, MEETING, PoiTypes.getBlockStates(Blocks.BELL), 32, 6);
        PoiTypes.register(var0, BEEHIVE, PoiTypes.getBlockStates(Blocks.BEEHIVE), 0, 1);
        PoiTypes.register(var0, BEE_NEST, PoiTypes.getBlockStates(Blocks.BEE_NEST), 0, 1);
        PoiTypes.register(var0, NETHER_PORTAL, PoiTypes.getBlockStates(Blocks.NETHER_PORTAL), 0, 1);
        PoiTypes.register(var0, LODESTONE, PoiTypes.getBlockStates(Blocks.LODESTONE), 0, 1);
        return PoiTypes.register(var0, LIGHTNING_ROD, PoiTypes.getBlockStates(Blocks.LIGHTNING_ROD), 0, 1);
    }
}

