/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AxisAlignedBB;

public class SensorNearestLivingEntities<T extends EntityLiving>
extends Sensor<T> {
    @Override
    protected void doTick(WorldServer var0, T var12) {
        double var2 = ((EntityLiving)var12).getAttributeValue(GenericAttributes.FOLLOW_RANGE);
        AxisAlignedBB var4 = ((Entity)var12).getBoundingBox().inflate(var2, var2, var2);
        List<EntityLiving> var5 = var0.getEntitiesOfClass(EntityLiving.class, var4, var1 -> var1 != var12 && var1.isAlive());
        var5.sort(Comparator.comparingDouble(arg_0 -> var12.distanceToSqr(arg_0)));
        BehaviorController<?> var6 = ((EntityLiving)var12).getBrain();
        var6.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, var5);
        var6.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, new NearestVisibleLivingEntities(var0, (EntityLiving)var12, var5));
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

