/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;

public class PathfinderGoalSelector {
    private static final PathfinderGoalWrapped NO_GOAL = new PathfinderGoalWrapped(Integer.MAX_VALUE, new PathfinderGoal(){

        @Override
        public boolean canUse() {
            return false;
        }
    }){

        @Override
        public boolean isRunning() {
            return false;
        }
    };
    private final Map<PathfinderGoal.Type, PathfinderGoalWrapped> lockedFlags = new EnumMap<PathfinderGoal.Type, PathfinderGoalWrapped>(PathfinderGoal.Type.class);
    private final Set<PathfinderGoalWrapped> availableGoals = new ObjectLinkedOpenHashSet();
    private final EnumSet<PathfinderGoal.Type> disabledFlags = EnumSet.noneOf(PathfinderGoal.Type.class);

    public void addGoal(int var0, PathfinderGoal var1) {
        this.availableGoals.add(new PathfinderGoalWrapped(var0, var1));
    }

    @VisibleForTesting
    public void removeAllGoals(Predicate<PathfinderGoal> var0) {
        this.availableGoals.removeIf(var1 -> var0.test(var1.getGoal()));
    }

    public void removeGoal(PathfinderGoal var0) {
        for (PathfinderGoalWrapped var2 : this.availableGoals) {
            if (var2.getGoal() != var0 || !var2.isRunning()) continue;
            var2.stop();
        }
        this.availableGoals.removeIf(var1 -> var1.getGoal() == var0);
    }

    private static boolean goalContainsAnyFlags(PathfinderGoalWrapped var0, EnumSet<PathfinderGoal.Type> var1) {
        for (PathfinderGoal.Type var3 : var0.getFlags()) {
            if (!var1.contains((Object)var3)) continue;
            return true;
        }
        return false;
    }

    private static boolean goalCanBeReplacedForAllFlags(PathfinderGoalWrapped var0, Map<PathfinderGoal.Type, PathfinderGoalWrapped> var1) {
        for (PathfinderGoal.Type var3 : var0.getFlags()) {
            if (var1.getOrDefault((Object)var3, NO_GOAL).canBeReplacedBy(var0)) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        GameProfilerFiller var02 = Profiler.get();
        var02.push("goalCleanup");
        for (PathfinderGoalWrapped var2 : this.availableGoals) {
            if (!var2.isRunning() || !PathfinderGoalSelector.goalContainsAnyFlags(var2, this.disabledFlags) && var2.canContinueToUse()) continue;
            var2.stop();
        }
        this.lockedFlags.entrySet().removeIf(var0 -> !((PathfinderGoalWrapped)var0.getValue()).isRunning());
        var02.pop();
        var02.push("goalUpdate");
        for (PathfinderGoalWrapped var2 : this.availableGoals) {
            if (var2.isRunning() || PathfinderGoalSelector.goalContainsAnyFlags(var2, this.disabledFlags) || !PathfinderGoalSelector.goalCanBeReplacedForAllFlags(var2, this.lockedFlags) || !var2.canUse()) continue;
            for (PathfinderGoal.Type var4 : var2.getFlags()) {
                PathfinderGoalWrapped var5 = this.lockedFlags.getOrDefault((Object)var4, NO_GOAL);
                var5.stop();
                this.lockedFlags.put(var4, var2);
            }
            var2.start();
        }
        var02.pop();
        this.tickRunningGoals(true);
    }

    public void tickRunningGoals(boolean var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("goalTick");
        for (PathfinderGoalWrapped var3 : this.availableGoals) {
            if (!var3.isRunning() || !var0 && !var3.requiresUpdateEveryTick()) continue;
            var3.tick();
        }
        var1.pop();
    }

    public Set<PathfinderGoalWrapped> getAvailableGoals() {
        return this.availableGoals;
    }

    public void disableControlFlag(PathfinderGoal.Type var0) {
        this.disabledFlags.add(var0);
    }

    public void enableControlFlag(PathfinderGoal.Type var0) {
        this.disabledFlags.remove((Object)var0);
    }

    public void setControlFlag(PathfinderGoal.Type var0, boolean var1) {
        if (var1) {
            this.enableControlFlag(var0);
        } else {
            this.disableControlFlag(var0);
        }
    }
}

