/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorOutside;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;

public class BehaviorCelebrate
extends Behavior<EntityVillager> {
    @Nullable
    private Raid currentRaid;

    public BehaviorCelebrate(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), var0, var1);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        BlockPosition var2 = var1.blockPosition();
        this.currentRaid = var0.getRaidAt(var2);
        return this.currentRaid != null && this.currentRaid.isVictory() && BehaviorOutside.hasNoBlocksAbove(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.currentRaid != null && !this.currentRaid.isStopped();
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        this.currentRaid = null;
        var1.getBrain().updateActivityFromSchedule(var0.getDayTime(), var0.getGameTime());
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        RandomSource var4 = var1.getRandom();
        if (var4.nextInt(100) == 0) {
            var1.playCelebrateSound();
        }
        if (var4.nextInt(200) == 0 && BehaviorOutside.hasNoBlocksAbove(var0, var1, var1.blockPosition())) {
            EnumColor var5 = SystemUtils.getRandom(EnumColor.values(), var4);
            int var6 = var4.nextInt(3);
            ItemStack var7 = this.getFirework(var5, var6);
            IProjectile.spawnProjectile(new EntityFireworks(var1.level(), var1, var1.getX(), var1.getEyeY(), var1.getZ(), var7), var0, var7);
        }
    }

    private ItemStack getFirework(EnumColor var0, int var1) {
        ItemStack var2 = new ItemStack(Items.FIREWORK_ROCKET);
        var2.set(DataComponents.FIREWORKS, new Fireworks((byte)var1, List.of(new FireworkExplosion(FireworkExplosion.a.BURST, IntList.of((int)var0.getFireworkColor()), IntList.of(), false, false))));
        return var2;
    }
}

