/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public final class IEntitySelector {
    public static final Predicate<Entity> ENTITY_STILL_ALIVE = Entity::isAlive;
    public static final Predicate<Entity> LIVING_ENTITY_STILL_ALIVE = var0 -> var0.isAlive() && var0 instanceof EntityLiving;
    public static final Predicate<Entity> ENTITY_NOT_BEING_RIDDEN = var0 -> var0.isAlive() && !var0.isVehicle() && !var0.isPassenger();
    public static final Predicate<Entity> CONTAINER_ENTITY_SELECTOR = var0 -> var0 instanceof IInventory && var0.isAlive();
    public static final Predicate<Entity> NO_CREATIVE_OR_SPECTATOR = var0 -> !(var0 instanceof EntityHuman) || !var0.isSpectator() && !((EntityHuman)var0).isCreative();
    public static final Predicate<Entity> NO_SPECTATORS = var0 -> !var0.isSpectator();
    public static final Predicate<Entity> CAN_BE_COLLIDED_WITH = NO_SPECTATORS.and(Entity::canBeCollidedWith);
    public static final Predicate<Entity> CAN_BE_PICKED = NO_SPECTATORS.and(Entity::isPickable);

    private IEntitySelector() {
    }

    public static Predicate<Entity> withinDistance(double var0, double var2, double var4, double var6) {
        double var82 = var6 * var6;
        return var8 -> var8 != null && var8.distanceToSqr(var0, var2, var4) <= var82;
    }

    public static Predicate<Entity> pushableBy(Entity var0) {
        ScoreboardTeamBase.EnumTeamPush var2;
        ScoreboardTeam var1 = var0.getTeam();
        ScoreboardTeamBase.EnumTeamPush enumTeamPush = var2 = var1 == null ? ScoreboardTeamBase.EnumTeamPush.ALWAYS : ((ScoreboardTeamBase)var1).getCollisionRule();
        if (var2 == ScoreboardTeamBase.EnumTeamPush.NEVER) {
            return Predicates.alwaysFalse();
        }
        return NO_SPECTATORS.and(var3 -> {
            boolean var6;
            ScoreboardTeamBase.EnumTeamPush var5;
            if (!var3.isPushable()) {
                return false;
            }
            if (!(!var0.level().isClientSide || var3 instanceof EntityHuman && ((EntityHuman)var3).isLocalPlayer())) {
                return false;
            }
            ScoreboardTeam var4 = var3.getTeam();
            ScoreboardTeamBase.EnumTeamPush enumTeamPush = var5 = var4 == null ? ScoreboardTeamBase.EnumTeamPush.ALWAYS : ((ScoreboardTeamBase)var4).getCollisionRule();
            if (var5 == ScoreboardTeamBase.EnumTeamPush.NEVER) {
                return false;
            }
            boolean bl = var6 = var1 != null && var1.isAlliedTo(var4);
            if ((var2 == ScoreboardTeamBase.EnumTeamPush.PUSH_OWN_TEAM || var5 == ScoreboardTeamBase.EnumTeamPush.PUSH_OWN_TEAM) && var6) {
                return false;
            }
            return var2 != ScoreboardTeamBase.EnumTeamPush.PUSH_OTHER_TEAMS && var5 != ScoreboardTeamBase.EnumTeamPush.PUSH_OTHER_TEAMS || var6;
        });
    }

    public static Predicate<Entity> notRiding(Entity var0) {
        return var1 -> {
            while (var1.isPassenger()) {
                if ((var1 = var1.getVehicle()) != var0) continue;
                return false;
            }
            return true;
        };
    }
}

