/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.ChestRaft;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements FeatureElement,
EntityTypeTest<Entity, T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Holder.c<EntityTypes<?>> builtInRegistryHolder = BuiltInRegistries.ENTITY_TYPE.createIntrusiveHolder(this);
    private static final float MAGIC_HORSE_WIDTH = 1.3964844f;
    private static final int DISPLAY_TRACKING_RANGE = 10;
    public static final EntityTypes<EntityBoat> ACACIA_BOAT = EntityTypes.register("acacia_boat", Builder.of(EntityTypes.boatFactory(() -> Items.ACACIA_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> ACACIA_CHEST_BOAT = EntityTypes.register("acacia_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.ACACIA_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<Allay> ALLAY = EntityTypes.register("allay", Builder.of(Allay::new, EnumCreatureType.CREATURE).sized(0.35f, 0.6f).eyeHeight(0.36f).ridingOffset(0.04f).clientTrackingRange(8).updateInterval(2));
    public static final EntityTypes<EntityAreaEffectCloud> AREA_EFFECT_CLOUD = EntityTypes.register("area_effect_cloud", Builder.of(EntityAreaEffectCloud::new, EnumCreatureType.MISC).noLootTable().fireImmune().sized(6.0f, 0.5f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<Armadillo> ARMADILLO = EntityTypes.register("armadillo", Builder.of(Armadillo::new, EnumCreatureType.CREATURE).sized(0.7f, 0.65f).eyeHeight(0.26f).clientTrackingRange(10));
    public static final EntityTypes<EntityArmorStand> ARMOR_STAND = EntityTypes.register("armor_stand", Builder.of(EntityArmorStand::new, EnumCreatureType.MISC).sized(0.5f, 1.975f).eyeHeight(1.7775f).clientTrackingRange(10));
    public static final EntityTypes<EntityTippedArrow> ARROW = EntityTypes.register("arrow", Builder.of(EntityTippedArrow::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final EntityTypes<Axolotl> AXOLOTL = EntityTypes.register("axolotl", Builder.of(Axolotl::new, EnumCreatureType.AXOLOTLS).sized(0.75f, 0.42f).eyeHeight(0.2751f).clientTrackingRange(10));
    public static final EntityTypes<ChestRaft> BAMBOO_CHEST_RAFT = EntityTypes.register("bamboo_chest_raft", Builder.of(EntityTypes.chestRaftFactory(() -> Items.BAMBOO_CHEST_RAFT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<Raft> BAMBOO_RAFT = EntityTypes.register("bamboo_raft", Builder.of(EntityTypes.raftFactory(() -> Items.BAMBOO_RAFT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityBat> BAT = EntityTypes.register("bat", Builder.of(EntityBat::new, EnumCreatureType.AMBIENT).sized(0.5f, 0.9f).eyeHeight(0.45f).clientTrackingRange(5));
    public static final EntityTypes<EntityBee> BEE = EntityTypes.register("bee", Builder.of(EntityBee::new, EnumCreatureType.CREATURE).sized(0.7f, 0.6f).eyeHeight(0.3f).clientTrackingRange(8));
    public static final EntityTypes<EntityBoat> BIRCH_BOAT = EntityTypes.register("birch_boat", Builder.of(EntityTypes.boatFactory(() -> Items.BIRCH_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> BIRCH_CHEST_BOAT = EntityTypes.register("birch_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.BIRCH_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityBlaze> BLAZE = EntityTypes.register("blaze", Builder.of(EntityBlaze::new, EnumCreatureType.MONSTER).fireImmune().sized(0.6f, 1.8f).clientTrackingRange(8));
    public static final EntityTypes<Display.BlockDisplay> BLOCK_DISPLAY = EntityTypes.register("block_display", Builder.of(Display.BlockDisplay::new, EnumCreatureType.MISC).noLootTable().sized(0.0f, 0.0f).clientTrackingRange(10).updateInterval(1));
    public static final EntityTypes<Bogged> BOGGED = EntityTypes.register("bogged", Builder.of(Bogged::new, EnumCreatureType.MONSTER).sized(0.6f, 1.99f).eyeHeight(1.74f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<Breeze> BREEZE = EntityTypes.register("breeze", Builder.of(Breeze::new, EnumCreatureType.MONSTER).sized(0.6f, 1.77f).eyeHeight(1.3452f).clientTrackingRange(10));
    public static final EntityTypes<BreezeWindCharge> BREEZE_WIND_CHARGE = EntityTypes.register("breeze_wind_charge", Builder.of(BreezeWindCharge::new, EnumCreatureType.MISC).noLootTable().sized(0.3125f, 0.3125f).eyeHeight(0.0f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<Camel> CAMEL = EntityTypes.register("camel", Builder.of(Camel::new, EnumCreatureType.CREATURE).sized(1.7f, 2.375f).eyeHeight(2.275f).clientTrackingRange(10));
    public static final EntityTypes<EntityCat> CAT = EntityTypes.register("cat", Builder.of(EntityCat::new, EnumCreatureType.CREATURE).sized(0.6f, 0.7f).eyeHeight(0.35f).passengerAttachments(0.5125f).clientTrackingRange(8));
    public static final EntityTypes<EntityCaveSpider> CAVE_SPIDER = EntityTypes.register("cave_spider", Builder.of(EntityCaveSpider::new, EnumCreatureType.MONSTER).sized(0.7f, 0.5f).eyeHeight(0.45f).clientTrackingRange(8));
    public static final EntityTypes<EntityBoat> CHERRY_BOAT = EntityTypes.register("cherry_boat", Builder.of(EntityTypes.boatFactory(() -> Items.CHERRY_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> CHERRY_CHEST_BOAT = EntityTypes.register("cherry_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.CHERRY_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityMinecartChest> CHEST_MINECART = EntityTypes.register("chest_minecart", Builder.of(EntityMinecartChest::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntityChicken> CHICKEN = EntityTypes.register("chicken", Builder.of(EntityChicken::new, EnumCreatureType.CREATURE).sized(0.4f, 0.7f).eyeHeight(0.644f).passengerAttachments(new Vec3D(0.0, 0.7, -0.1)).clientTrackingRange(10));
    public static final EntityTypes<EntityCod> COD = EntityTypes.register("cod", Builder.of(EntityCod::new, EnumCreatureType.WATER_AMBIENT).sized(0.5f, 0.3f).eyeHeight(0.195f).clientTrackingRange(4));
    public static final EntityTypes<EntityMinecartCommandBlock> COMMAND_BLOCK_MINECART = EntityTypes.register("command_block_minecart", Builder.of(EntityMinecartCommandBlock::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntityCow> COW = EntityTypes.register("cow", Builder.of(EntityCow::new, EnumCreatureType.CREATURE).sized(0.9f, 1.4f).eyeHeight(1.3f).passengerAttachments(1.36875f).clientTrackingRange(10));
    public static final EntityTypes<Creaking> CREAKING = EntityTypes.register("creaking", Builder.of(Creaking::new, EnumCreatureType.MONSTER).sized(0.9f, 2.7f).eyeHeight(2.3f).clientTrackingRange(8));
    public static final EntityTypes<EntityCreeper> CREEPER = EntityTypes.register("creeper", Builder.of(EntityCreeper::new, EnumCreatureType.MONSTER).sized(0.6f, 1.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityBoat> DARK_OAK_BOAT = EntityTypes.register("dark_oak_boat", Builder.of(EntityTypes.boatFactory(() -> Items.DARK_OAK_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> DARK_OAK_CHEST_BOAT = EntityTypes.register("dark_oak_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.DARK_OAK_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityDolphin> DOLPHIN = EntityTypes.register("dolphin", Builder.of(EntityDolphin::new, EnumCreatureType.WATER_CREATURE).sized(0.9f, 0.6f).eyeHeight(0.3f));
    public static final EntityTypes<EntityHorseDonkey> DONKEY = EntityTypes.register("donkey", Builder.of(EntityHorseDonkey::new, EnumCreatureType.CREATURE).sized(1.3964844f, 1.5f).eyeHeight(1.425f).passengerAttachments(1.1125f).clientTrackingRange(10));
    public static final EntityTypes<EntityDragonFireball> DRAGON_FIREBALL = EntityTypes.register("dragon_fireball", Builder.of(EntityDragonFireball::new, EnumCreatureType.MISC).noLootTable().sized(1.0f, 1.0f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityDrowned> DROWNED = EntityTypes.register("drowned", Builder.of(EntityDrowned::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.74f).passengerAttachments(2.0125f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityEgg> EGG = EntityTypes.register("egg", Builder.of(EntityEgg::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityGuardianElder> ELDER_GUARDIAN = EntityTypes.register("elder_guardian", Builder.of(EntityGuardianElder::new, EnumCreatureType.MONSTER).sized(1.9975f, 1.9975f).eyeHeight(0.99875f).passengerAttachments(2.350625f).clientTrackingRange(10));
    public static final EntityTypes<EntityEnderman> ENDERMAN = EntityTypes.register("enderman", Builder.of(EntityEnderman::new, EnumCreatureType.MONSTER).sized(0.6f, 2.9f).eyeHeight(2.55f).passengerAttachments(2.80625f).clientTrackingRange(8));
    public static final EntityTypes<EntityEndermite> ENDERMITE = EntityTypes.register("endermite", Builder.of(EntityEndermite::new, EnumCreatureType.MONSTER).sized(0.4f, 0.3f).eyeHeight(0.13f).passengerAttachments(0.2375f).clientTrackingRange(8));
    public static final EntityTypes<EntityEnderDragon> ENDER_DRAGON = EntityTypes.register("ender_dragon", Builder.of(EntityEnderDragon::new, EnumCreatureType.MONSTER).fireImmune().sized(16.0f, 8.0f).passengerAttachments(3.0f).clientTrackingRange(10));
    public static final EntityTypes<EntityEnderPearl> ENDER_PEARL = EntityTypes.register("ender_pearl", Builder.of(EntityEnderPearl::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityEnderCrystal> END_CRYSTAL = EntityTypes.register("end_crystal", Builder.of(EntityEnderCrystal::new, EnumCreatureType.MISC).noLootTable().fireImmune().sized(2.0f, 2.0f).clientTrackingRange(16).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEvoker> EVOKER = EntityTypes.register("evoker", Builder.of(EntityEvoker::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).passengerAttachments(2.0f).ridingOffset(-0.6f).clientTrackingRange(8));
    public static final EntityTypes<EntityEvokerFangs> EVOKER_FANGS = EntityTypes.register("evoker_fangs", Builder.of(EntityEvokerFangs::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.8f).clientTrackingRange(6).updateInterval(2));
    public static final EntityTypes<EntityThrownExpBottle> EXPERIENCE_BOTTLE = EntityTypes.register("experience_bottle", Builder.of(EntityThrownExpBottle::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityExperienceOrb> EXPERIENCE_ORB = EntityTypes.register("experience_orb", Builder.of(EntityExperienceOrb::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).clientTrackingRange(6).updateInterval(20));
    public static final EntityTypes<EntityEnderSignal> EYE_OF_ENDER = EntityTypes.register("eye_of_ender", Builder.of(EntityEnderSignal::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(4));
    public static final EntityTypes<EntityFallingBlock> FALLING_BLOCK = EntityTypes.register("falling_block", Builder.of(EntityFallingBlock::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(20));
    public static final EntityTypes<EntityLargeFireball> FIREBALL = EntityTypes.register("fireball", Builder.of(EntityLargeFireball::new, EnumCreatureType.MISC).noLootTable().sized(1.0f, 1.0f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityFireworks> FIREWORK_ROCKET = EntityTypes.register("firework_rocket", Builder.of(EntityFireworks::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityFox> FOX = EntityTypes.register("fox", Builder.of(EntityFox::new, EnumCreatureType.CREATURE).sized(0.6f, 0.7f).eyeHeight(0.4f).passengerAttachments(new Vec3D(0.0, 0.6375, -0.25)).clientTrackingRange(8).immuneTo(Blocks.SWEET_BERRY_BUSH));
    public static final EntityTypes<Frog> FROG = EntityTypes.register("frog", Builder.of(Frog::new, EnumCreatureType.CREATURE).sized(0.5f, 0.5f).passengerAttachments(new Vec3D(0.0, 0.375, -0.25)).clientTrackingRange(10));
    public static final EntityTypes<EntityMinecartFurnace> FURNACE_MINECART = EntityTypes.register("furnace_minecart", Builder.of(EntityMinecartFurnace::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntityGhast> GHAST = EntityTypes.register("ghast", Builder.of(EntityGhast::new, EnumCreatureType.MONSTER).fireImmune().sized(4.0f, 4.0f).eyeHeight(2.6f).passengerAttachments(4.0625f).ridingOffset(0.5f).clientTrackingRange(10));
    public static final EntityTypes<EntityGiantZombie> GIANT = EntityTypes.register("giant", Builder.of(EntityGiantZombie::new, EnumCreatureType.MONSTER).sized(3.6f, 12.0f).eyeHeight(10.44f).ridingOffset(-3.75f).clientTrackingRange(10));
    public static final EntityTypes<GlowItemFrame> GLOW_ITEM_FRAME = EntityTypes.register("glow_item_frame", Builder.of(GlowItemFrame::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).eyeHeight(0.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> GLOW_SQUID = EntityTypes.register("glow_squid", Builder.of(GlowSquid::new, EnumCreatureType.UNDERGROUND_WATER_CREATURE).sized(0.8f, 0.8f).eyeHeight(0.4f).clientTrackingRange(10));
    public static final EntityTypes<Goat> GOAT = EntityTypes.register("goat", Builder.of(Goat::new, EnumCreatureType.CREATURE).sized(0.9f, 1.3f).passengerAttachments(1.1125f).clientTrackingRange(10));
    public static final EntityTypes<EntityGuardian> GUARDIAN = EntityTypes.register("guardian", Builder.of(EntityGuardian::new, EnumCreatureType.MONSTER).sized(0.85f, 0.85f).eyeHeight(0.425f).passengerAttachments(0.975f).clientTrackingRange(8));
    public static final EntityTypes<EntityHoglin> HOGLIN = EntityTypes.register("hoglin", Builder.of(EntityHoglin::new, EnumCreatureType.MONSTER).sized(1.3964844f, 1.4f).passengerAttachments(1.49375f).clientTrackingRange(8));
    public static final EntityTypes<EntityMinecartHopper> HOPPER_MINECART = EntityTypes.register("hopper_minecart", Builder.of(EntityMinecartHopper::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntityHorse> HORSE = EntityTypes.register("horse", Builder.of(EntityHorse::new, EnumCreatureType.CREATURE).sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(1.44375f).clientTrackingRange(10));
    public static final EntityTypes<EntityZombieHusk> HUSK = EntityTypes.register("husk", Builder.of(EntityZombieHusk::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.74f).passengerAttachments(2.075f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityIllagerIllusioner> ILLUSIONER = EntityTypes.register("illusioner", Builder.of(EntityIllagerIllusioner::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).passengerAttachments(2.0f).ridingOffset(-0.6f).clientTrackingRange(8));
    public static final EntityTypes<Interaction> INTERACTION = EntityTypes.register("interaction", Builder.of(Interaction::new, EnumCreatureType.MISC).noLootTable().sized(0.0f, 0.0f).clientTrackingRange(10));
    public static final EntityTypes<EntityIronGolem> IRON_GOLEM = EntityTypes.register("iron_golem", Builder.of(EntityIronGolem::new, EnumCreatureType.MISC).sized(1.4f, 2.7f).clientTrackingRange(10));
    public static final EntityTypes<EntityItem> ITEM = EntityTypes.register("item", Builder.of(EntityItem::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).eyeHeight(0.2125f).clientTrackingRange(6).updateInterval(20));
    public static final EntityTypes<Display.ItemDisplay> ITEM_DISPLAY = EntityTypes.register("item_display", Builder.of(Display.ItemDisplay::new, EnumCreatureType.MISC).noLootTable().sized(0.0f, 0.0f).clientTrackingRange(10).updateInterval(1));
    public static final EntityTypes<EntityItemFrame> ITEM_FRAME = EntityTypes.register("item_frame", Builder.of(EntityItemFrame::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).eyeHeight(0.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> JUNGLE_BOAT = EntityTypes.register("jungle_boat", Builder.of(EntityTypes.boatFactory(() -> Items.JUNGLE_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> JUNGLE_CHEST_BOAT = EntityTypes.register("jungle_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.JUNGLE_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityLeash> LEASH_KNOT = EntityTypes.register("leash_knot", Builder.of(EntityLeash::new, EnumCreatureType.MISC).noLootTable().noSave().sized(0.375f, 0.5f).eyeHeight(0.0625f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> LIGHTNING_BOLT = EntityTypes.register("lightning_bolt", Builder.of(EntityLightning::new, EnumCreatureType.MISC).noLootTable().noSave().sized(0.0f, 0.0f).clientTrackingRange(16).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> LLAMA = EntityTypes.register("llama", Builder.of(EntityLlama::new, EnumCreatureType.CREATURE).sized(0.9f, 1.87f).eyeHeight(1.7765f).passengerAttachments(new Vec3D(0.0, 1.37, -0.3)).clientTrackingRange(10));
    public static final EntityTypes<EntityLlamaSpit> LLAMA_SPIT = EntityTypes.register("llama_spit", Builder.of(EntityLlamaSpit::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityMagmaCube> MAGMA_CUBE = EntityTypes.register("magma_cube", Builder.of(EntityMagmaCube::new, EnumCreatureType.MONSTER).fireImmune().sized(0.52f, 0.52f).eyeHeight(0.325f).spawnDimensionsScale(4.0f).clientTrackingRange(8));
    public static final EntityTypes<EntityBoat> MANGROVE_BOAT = EntityTypes.register("mangrove_boat", Builder.of(EntityTypes.boatFactory(() -> Items.MANGROVE_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> MANGROVE_CHEST_BOAT = EntityTypes.register("mangrove_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.MANGROVE_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<Marker> MARKER = EntityTypes.register("marker", Builder.of(Marker::new, EnumCreatureType.MISC).noLootTable().sized(0.0f, 0.0f).clientTrackingRange(0));
    public static final EntityTypes<EntityMinecartRideable> MINECART = EntityTypes.register("minecart", Builder.of(EntityMinecartRideable::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntityMushroomCow> MOOSHROOM = EntityTypes.register("mooshroom", Builder.of(EntityMushroomCow::new, EnumCreatureType.CREATURE).sized(0.9f, 1.4f).eyeHeight(1.3f).passengerAttachments(1.36875f).clientTrackingRange(10));
    public static final EntityTypes<EntityHorseMule> MULE = EntityTypes.register("mule", Builder.of(EntityHorseMule::new, EnumCreatureType.CREATURE).sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(1.2125f).clientTrackingRange(8));
    public static final EntityTypes<EntityBoat> OAK_BOAT = EntityTypes.register("oak_boat", Builder.of(EntityTypes.boatFactory(() -> Items.OAK_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> OAK_CHEST_BOAT = EntityTypes.register("oak_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.OAK_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityOcelot> OCELOT = EntityTypes.register("ocelot", Builder.of(EntityOcelot::new, EnumCreatureType.CREATURE).sized(0.6f, 0.7f).passengerAttachments(0.6375f).clientTrackingRange(10));
    public static final EntityTypes<OminousItemSpawner> OMINOUS_ITEM_SPAWNER = EntityTypes.register("ominous_item_spawner", Builder.of(OminousItemSpawner::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(8));
    public static final EntityTypes<EntityPainting> PAINTING = EntityTypes.register("painting", Builder.of(EntityPainting::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> PALE_OAK_BOAT = EntityTypes.register("pale_oak_boat", Builder.of(EntityTypes.boatFactory(() -> Items.PALE_OAK_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> PALE_OAK_CHEST_BOAT = EntityTypes.register("pale_oak_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.PALE_OAK_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntityPanda> PANDA = EntityTypes.register("panda", Builder.of(EntityPanda::new, EnumCreatureType.CREATURE).sized(1.3f, 1.25f).clientTrackingRange(10));
    public static final EntityTypes<EntityParrot> PARROT = EntityTypes.register("parrot", Builder.of(EntityParrot::new, EnumCreatureType.CREATURE).sized(0.5f, 0.9f).eyeHeight(0.54f).passengerAttachments(0.4625f).clientTrackingRange(8));
    public static final EntityTypes<EntityPhantom> PHANTOM = EntityTypes.register("phantom", Builder.of(EntityPhantom::new, EnumCreatureType.MONSTER).sized(0.9f, 0.5f).eyeHeight(0.175f).passengerAttachments(0.3375f).ridingOffset(-0.125f).clientTrackingRange(8));
    public static final EntityTypes<EntityPig> PIG = EntityTypes.register("pig", Builder.of(EntityPig::new, EnumCreatureType.CREATURE).sized(0.9f, 0.9f).passengerAttachments(0.86875f).clientTrackingRange(10));
    public static final EntityTypes<EntityPiglin> PIGLIN = EntityTypes.register("piglin", Builder.of(EntityPiglin::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.79f).passengerAttachments(2.0125f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityPiglinBrute> PIGLIN_BRUTE = EntityTypes.register("piglin_brute", Builder.of(EntityPiglinBrute::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.79f).passengerAttachments(2.0125f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityPillager> PILLAGER = EntityTypes.register("pillager", Builder.of(EntityPillager::new, EnumCreatureType.MONSTER).canSpawnFarFromPlayer().sized(0.6f, 1.95f).passengerAttachments(2.0f).ridingOffset(-0.6f).clientTrackingRange(8));
    public static final EntityTypes<EntityPolarBear> POLAR_BEAR = EntityTypes.register("polar_bear", Builder.of(EntityPolarBear::new, EnumCreatureType.CREATURE).immuneTo(Blocks.POWDER_SNOW).sized(1.4f, 1.4f).clientTrackingRange(10));
    public static final EntityTypes<EntityPotion> POTION = EntityTypes.register("potion", Builder.of(EntityPotion::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityPufferFish> PUFFERFISH = EntityTypes.register("pufferfish", Builder.of(EntityPufferFish::new, EnumCreatureType.WATER_AMBIENT).sized(0.7f, 0.7f).eyeHeight(0.455f).clientTrackingRange(4));
    public static final EntityTypes<EntityRabbit> RABBIT = EntityTypes.register("rabbit", Builder.of(EntityRabbit::new, EnumCreatureType.CREATURE).sized(0.4f, 0.5f).clientTrackingRange(8));
    public static final EntityTypes<EntityRavager> RAVAGER = EntityTypes.register("ravager", Builder.of(EntityRavager::new, EnumCreatureType.MONSTER).sized(1.95f, 2.2f).passengerAttachments(new Vec3D(0.0, 2.2625, -0.0625)).clientTrackingRange(10));
    public static final EntityTypes<EntitySalmon> SALMON = EntityTypes.register("salmon", Builder.of(EntitySalmon::new, EnumCreatureType.WATER_AMBIENT).sized(0.7f, 0.4f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final EntityTypes<EntitySheep> SHEEP = EntityTypes.register("sheep", Builder.of(EntitySheep::new, EnumCreatureType.CREATURE).sized(0.9f, 1.3f).eyeHeight(1.235f).passengerAttachments(1.2375f).clientTrackingRange(10));
    public static final EntityTypes<EntityShulker> SHULKER = EntityTypes.register("shulker", Builder.of(EntityShulker::new, EnumCreatureType.MONSTER).fireImmune().canSpawnFarFromPlayer().sized(1.0f, 1.0f).eyeHeight(0.5f).clientTrackingRange(10));
    public static final EntityTypes<EntityShulkerBullet> SHULKER_BULLET = EntityTypes.register("shulker_bullet", Builder.of(EntityShulkerBullet::new, EnumCreatureType.MISC).noLootTable().sized(0.3125f, 0.3125f).clientTrackingRange(8));
    public static final EntityTypes<EntitySilverfish> SILVERFISH = EntityTypes.register("silverfish", Builder.of(EntitySilverfish::new, EnumCreatureType.MONSTER).sized(0.4f, 0.3f).eyeHeight(0.13f).passengerAttachments(0.2375f).clientTrackingRange(8));
    public static final EntityTypes<EntitySkeleton> SKELETON = EntityTypes.register("skeleton", Builder.of(EntitySkeleton::new, EnumCreatureType.MONSTER).sized(0.6f, 1.99f).eyeHeight(1.74f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityHorseSkeleton> SKELETON_HORSE = EntityTypes.register("skeleton_horse", Builder.of(EntityHorseSkeleton::new, EnumCreatureType.CREATURE).sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(1.31875f).clientTrackingRange(10));
    public static final EntityTypes<EntitySlime> SLIME = EntityTypes.register("slime", Builder.of(EntitySlime::new, EnumCreatureType.MONSTER).sized(0.52f, 0.52f).eyeHeight(0.325f).spawnDimensionsScale(4.0f).clientTrackingRange(10));
    public static final EntityTypes<EntitySmallFireball> SMALL_FIREBALL = EntityTypes.register("small_fireball", Builder.of(EntitySmallFireball::new, EnumCreatureType.MISC).noLootTable().sized(0.3125f, 0.3125f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<Sniffer> SNIFFER = EntityTypes.register("sniffer", Builder.of(Sniffer::new, EnumCreatureType.CREATURE).sized(1.9f, 1.75f).eyeHeight(1.05f).passengerAttachments(2.09375f).nameTagOffset(2.05f).clientTrackingRange(10));
    public static final EntityTypes<EntitySnowball> SNOWBALL = EntityTypes.register("snowball", Builder.of(EntitySnowball::new, EnumCreatureType.MISC).noLootTable().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntitySnowman> SNOW_GOLEM = EntityTypes.register("snow_golem", Builder.of(EntitySnowman::new, EnumCreatureType.MISC).immuneTo(Blocks.POWDER_SNOW).sized(0.7f, 1.9f).eyeHeight(1.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityMinecartMobSpawner> SPAWNER_MINECART = EntityTypes.register("spawner_minecart", Builder.of(EntityMinecartMobSpawner::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntitySpectralArrow> SPECTRAL_ARROW = EntityTypes.register("spectral_arrow", Builder.of(EntitySpectralArrow::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final EntityTypes<EntitySpider> SPIDER = EntityTypes.register("spider", Builder.of(EntitySpider::new, EnumCreatureType.MONSTER).sized(1.4f, 0.9f).eyeHeight(0.65f).passengerAttachments(0.765f).clientTrackingRange(8));
    public static final EntityTypes<EntityBoat> SPRUCE_BOAT = EntityTypes.register("spruce_boat", Builder.of(EntityTypes.boatFactory(() -> Items.SPRUCE_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<ChestBoat> SPRUCE_CHEST_BOAT = EntityTypes.register("spruce_chest_boat", Builder.of(EntityTypes.chestBoatFactory(() -> Items.SPRUCE_CHEST_BOAT), EnumCreatureType.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    public static final EntityTypes<EntitySquid> SQUID = EntityTypes.register("squid", Builder.of(EntitySquid::new, EnumCreatureType.WATER_CREATURE).sized(0.8f, 0.8f).eyeHeight(0.4f).clientTrackingRange(8));
    public static final EntityTypes<EntitySkeletonStray> STRAY = EntityTypes.register("stray", Builder.of(EntitySkeletonStray::new, EnumCreatureType.MONSTER).sized(0.6f, 1.99f).eyeHeight(1.74f).ridingOffset(-0.7f).immuneTo(Blocks.POWDER_SNOW).clientTrackingRange(8));
    public static final EntityTypes<EntityStrider> STRIDER = EntityTypes.register("strider", Builder.of(EntityStrider::new, EnumCreatureType.CREATURE).fireImmune().sized(0.9f, 1.7f).clientTrackingRange(10));
    public static final EntityTypes<Tadpole> TADPOLE = EntityTypes.register("tadpole", Builder.of(Tadpole::new, EnumCreatureType.CREATURE).sized(0.4f, 0.3f).eyeHeight(0.19500001f).clientTrackingRange(10));
    public static final EntityTypes<Display.TextDisplay> TEXT_DISPLAY = EntityTypes.register("text_display", Builder.of(Display.TextDisplay::new, EnumCreatureType.MISC).noLootTable().sized(0.0f, 0.0f).clientTrackingRange(10).updateInterval(1));
    public static final EntityTypes<EntityTNTPrimed> TNT = EntityTypes.register("tnt", Builder.of(EntityTNTPrimed::new, EnumCreatureType.MISC).noLootTable().fireImmune().sized(0.98f, 0.98f).eyeHeight(0.15f).clientTrackingRange(10).updateInterval(10));
    public static final EntityTypes<EntityMinecartTNT> TNT_MINECART = EntityTypes.register("tnt_minecart", Builder.of(EntityMinecartTNT::new, EnumCreatureType.MISC).noLootTable().sized(0.98f, 0.7f).passengerAttachments(0.1875f).clientTrackingRange(8));
    public static final EntityTypes<EntityLlamaTrader> TRADER_LLAMA = EntityTypes.register("trader_llama", Builder.of(EntityLlamaTrader::new, EnumCreatureType.CREATURE).sized(0.9f, 1.87f).eyeHeight(1.7765f).passengerAttachments(new Vec3D(0.0, 1.37, -0.3)).clientTrackingRange(10));
    public static final EntityTypes<EntityThrownTrident> TRIDENT = EntityTypes.register("trident", Builder.of(EntityThrownTrident::new, EnumCreatureType.MISC).noLootTable().sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final EntityTypes<EntityTropicalFish> TROPICAL_FISH = EntityTypes.register("tropical_fish", Builder.of(EntityTropicalFish::new, EnumCreatureType.WATER_AMBIENT).sized(0.5f, 0.4f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final EntityTypes<EntityTurtle> TURTLE = EntityTypes.register("turtle", Builder.of(EntityTurtle::new, EnumCreatureType.CREATURE).sized(1.2f, 0.4f).passengerAttachments(new Vec3D(0.0, 0.55625, -0.25)).clientTrackingRange(10));
    public static final EntityTypes<EntityVex> VEX = EntityTypes.register("vex", Builder.of(EntityVex::new, EnumCreatureType.MONSTER).fireImmune().sized(0.4f, 0.8f).eyeHeight(0.51875f).passengerAttachments(0.7375f).ridingOffset(0.04f).clientTrackingRange(8));
    public static final EntityTypes<EntityVillager> VILLAGER = EntityTypes.register("villager", Builder.of(EntityVillager::new, EnumCreatureType.MISC).sized(0.6f, 1.95f).eyeHeight(1.62f).clientTrackingRange(10));
    public static final EntityTypes<EntityVindicator> VINDICATOR = EntityTypes.register("vindicator", Builder.of(EntityVindicator::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).passengerAttachments(2.0f).ridingOffset(-0.6f).clientTrackingRange(8));
    public static final EntityTypes<EntityVillagerTrader> WANDERING_TRADER = EntityTypes.register("wandering_trader", Builder.of(EntityVillagerTrader::new, EnumCreatureType.CREATURE).sized(0.6f, 1.95f).eyeHeight(1.62f).clientTrackingRange(10));
    public static final EntityTypes<Warden> WARDEN = EntityTypes.register("warden", Builder.of(Warden::new, EnumCreatureType.MONSTER).sized(0.9f, 2.9f).passengerAttachments(3.15f).attach(EntityAttachment.WARDEN_CHEST, 0.0f, 1.6f, 0.0f).clientTrackingRange(16).fireImmune());
    public static final EntityTypes<WindCharge> WIND_CHARGE = EntityTypes.register("wind_charge", Builder.of(WindCharge::new, EnumCreatureType.MISC).noLootTable().sized(0.3125f, 0.3125f).eyeHeight(0.0f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityWitch> WITCH = EntityTypes.register("witch", Builder.of(EntityWitch::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.62f).passengerAttachments(2.2625f).clientTrackingRange(8));
    public static final EntityTypes<EntityWither> WITHER = EntityTypes.register("wither", Builder.of(EntityWither::new, EnumCreatureType.MONSTER).fireImmune().immuneTo(Blocks.WITHER_ROSE).sized(0.9f, 3.5f).clientTrackingRange(10));
    public static final EntityTypes<EntitySkeletonWither> WITHER_SKELETON = EntityTypes.register("wither_skeleton", Builder.of(EntitySkeletonWither::new, EnumCreatureType.MONSTER).fireImmune().immuneTo(Blocks.WITHER_ROSE).sized(0.7f, 2.4f).eyeHeight(2.1f).ridingOffset(-0.875f).clientTrackingRange(8));
    public static final EntityTypes<EntityWitherSkull> WITHER_SKULL = EntityTypes.register("wither_skull", Builder.of(EntityWitherSkull::new, EnumCreatureType.MISC).noLootTable().sized(0.3125f, 0.3125f).clientTrackingRange(4).updateInterval(10));
    public static final EntityTypes<EntityWolf> WOLF = EntityTypes.register("wolf", Builder.of(EntityWolf::new, EnumCreatureType.CREATURE).sized(0.6f, 0.85f).eyeHeight(0.68f).passengerAttachments(new Vec3D(0.0, 0.81875, -0.0625)).clientTrackingRange(10));
    public static final EntityTypes<EntityZoglin> ZOGLIN = EntityTypes.register("zoglin", Builder.of(EntityZoglin::new, EnumCreatureType.MONSTER).fireImmune().sized(1.3964844f, 1.4f).passengerAttachments(1.49375f).clientTrackingRange(8));
    public static final EntityTypes<EntityZombie> ZOMBIE = EntityTypes.register("zombie", Builder.of(EntityZombie::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.74f).passengerAttachments(2.0125f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityHorseZombie> ZOMBIE_HORSE = EntityTypes.register("zombie_horse", Builder.of(EntityHorseZombie::new, EnumCreatureType.CREATURE).sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(1.31875f).clientTrackingRange(10));
    public static final EntityTypes<EntityZombieVillager> ZOMBIE_VILLAGER = EntityTypes.register("zombie_villager", Builder.of(EntityZombieVillager::new, EnumCreatureType.MONSTER).sized(0.6f, 1.95f).passengerAttachments(2.125f).ridingOffset(-0.7f).eyeHeight(1.74f).clientTrackingRange(8));
    public static final EntityTypes<EntityPigZombie> ZOMBIFIED_PIGLIN = EntityTypes.register("zombified_piglin", Builder.of(EntityPigZombie::new, EnumCreatureType.MONSTER).fireImmune().sized(0.6f, 1.95f).eyeHeight(1.79f).passengerAttachments(2.0f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final EntityTypes<EntityHuman> PLAYER = EntityTypes.register("player", Builder.createNothing(EnumCreatureType.MISC).noSave().noSummon().sized(0.6f, 1.8f).eyeHeight(1.62f).vehicleAttachment(EntityHuman.DEFAULT_VEHICLE_ATTACHMENT).clientTrackingRange(32).updateInterval(2));
    public static final EntityTypes<EntityFishingHook> FISHING_BOBBER = EntityTypes.register("fishing_bobber", Builder.of(EntityFishingHook::new, EnumCreatureType.MISC).noLootTable().noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5));
    private static final Set<EntityTypes<?>> OP_ONLY_CUSTOM_DATA = Set.of(FALLING_BLOCK, COMMAND_BLOCK_MINECART, SPAWNER_MINECART);
    private final b<T> factory;
    private final EnumCreatureType category;
    private final ImmutableSet<Block> immuneTo;
    private final boolean serialize;
    private final boolean summon;
    private final boolean fireImmune;
    private final boolean canSpawnFarFromPlayer;
    private final int clientTrackingRange;
    private final int updateInterval;
    private final String descriptionId;
    @Nullable
    private IChatBaseComponent description;
    private final Optional<ResourceKey<LootTable>> lootTable;
    private final EntitySize dimensions;
    private final float spawnDimensionsScale;
    private final FeatureFlagSet requiredFeatures;

    private static <T extends Entity> EntityTypes<T> register(ResourceKey<EntityTypes<?>> var0, Builder<T> var1) {
        return IRegistry.register(BuiltInRegistries.ENTITY_TYPE, var0, var1.build(var0));
    }

    private static ResourceKey<EntityTypes<?>> vanillaEntityId(String var0) {
        return ResourceKey.create(Registries.ENTITY_TYPE, MinecraftKey.withDefaultNamespace(var0));
    }

    private static <T extends Entity> EntityTypes<T> register(String var0, Builder<T> var1) {
        return EntityTypes.register(EntityTypes.vanillaEntityId(var0), var1);
    }

    public static MinecraftKey getKey(EntityTypes<?> var0) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(var0);
    }

    public static Optional<EntityTypes<?>> byString(String var0) {
        return BuiltInRegistries.ENTITY_TYPE.getOptional(MinecraftKey.tryParse(var0));
    }

    public EntityTypes(b<T> var0, EnumCreatureType var1, boolean var2, boolean var3, boolean var4, boolean var5, ImmutableSet<Block> var6, EntitySize var7, float var8, int var9, int var10, String var11, Optional<ResourceKey<LootTable>> var12, FeatureFlagSet var13) {
        this.factory = var0;
        this.category = var1;
        this.canSpawnFarFromPlayer = var5;
        this.serialize = var2;
        this.summon = var3;
        this.fireImmune = var4;
        this.immuneTo = var6;
        this.dimensions = var7;
        this.spawnDimensionsScale = var8;
        this.clientTrackingRange = var9;
        this.updateInterval = var10;
        this.descriptionId = var11;
        this.lootTable = var12;
        this.requiredFeatures = var13;
    }

    @Nullable
    public T spawn(WorldServer var02, @Nullable ItemStack var1, @Nullable EntityHuman var2, BlockPosition var3, EntitySpawnReason var4, boolean var5, boolean var6) {
        Consumer<Entity> var7 = var1 != null ? EntityTypes.createDefaultStackConfig(var02, var1, var2) : var0 -> {};
        return (T)this.spawn(var02, var7, var3, var4, var5, var6);
    }

    public static <T extends Entity> Consumer<T> createDefaultStackConfig(World var02, ItemStack var1, @Nullable EntityHuman var2) {
        return EntityTypes.appendDefaultStackConfig(var0 -> {}, var02, var1, var2);
    }

    public static <T extends Entity> Consumer<T> appendDefaultStackConfig(Consumer<T> var0, World var1, ItemStack var2, @Nullable EntityHuman var3) {
        return EntityTypes.appendCustomEntityStackConfig(EntityTypes.appendCustomNameConfig(var0, var2), var1, var2, var3);
    }

    public static <T extends Entity> Consumer<T> appendCustomNameConfig(Consumer<T> var0, ItemStack var12) {
        IChatBaseComponent var2 = var12.get(DataComponents.CUSTOM_NAME);
        if (var2 != null) {
            return var0.andThen(var1 -> var1.setCustomName(var2));
        }
        return var0;
    }

    public static <T extends Entity> Consumer<T> appendCustomEntityStackConfig(Consumer<T> var0, World var1, ItemStack var2, @Nullable EntityHuman var32) {
        CustomData var4 = var2.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!var4.isEmpty()) {
            return var0.andThen(var3 -> EntityTypes.updateCustomEntityTag(var1, var32, var3, var4));
        }
        return var0;
    }

    @Nullable
    public T spawn(WorldServer var0, BlockPosition var1, EntitySpawnReason var2) {
        return this.spawn(var0, null, var1, var2, false, false);
    }

    @Nullable
    public T spawn(WorldServer var0, @Nullable Consumer<T> var1, BlockPosition var2, EntitySpawnReason var3, boolean var4, boolean var5) {
        T var6 = this.create(var0, var1, var2, var3, var4, var5);
        if (var6 != null) {
            var0.addFreshEntityWithPassengers((Entity)var6);
            if (var6 instanceof EntityInsentient) {
                EntityInsentient var7 = (EntityInsentient)var6;
                var7.playAmbientSound();
            }
        }
        return var6;
    }

    @Nullable
    public T create(WorldServer var0, @Nullable Consumer<T> var1, BlockPosition var2, EntitySpawnReason var3, boolean var4, boolean var5) {
        double var7;
        T var6 = this.create(var0, var3);
        if (var6 == null) {
            return null;
        }
        if (var4) {
            ((Entity)var6).setPos((double)var2.getX() + 0.5, var2.getY() + 1, (double)var2.getZ() + 0.5);
            var7 = EntityTypes.getYOffset(var0, var2, var5, ((Entity)var6).getBoundingBox());
        } else {
            var7 = 0.0;
        }
        ((Entity)var6).moveTo((double)var2.getX() + 0.5, (double)var2.getY() + var7, (double)var2.getZ() + 0.5, MathHelper.wrapDegrees(var0.random.nextFloat() * 360.0f), 0.0f);
        if (var6 instanceof EntityInsentient) {
            EntityInsentient var9 = (EntityInsentient)var6;
            var9.yHeadRot = var9.getYRot();
            var9.yBodyRot = var9.getYRot();
            var9.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var9.blockPosition()), var3, null);
        }
        if (var1 != null) {
            var1.accept(var6);
        }
        return var6;
    }

    protected static double getYOffset(IWorldReader var0, BlockPosition var1, boolean var2, AxisAlignedBB var3) {
        AxisAlignedBB var4 = new AxisAlignedBB(var1);
        if (var2) {
            var4 = var4.expandTowards(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> var5 = var0.getCollisions(null, var4);
        return 1.0 + VoxelShapes.collide(EnumDirection.EnumAxis.Y, var3, var5, var2 ? -2.0 : -1.0);
    }

    public static void updateCustomEntityTag(World var0, @Nullable EntityHuman var1, @Nullable Entity var2, CustomData var3) {
        MinecraftServer var4 = var0.getServer();
        if (var4 == null || var2 == null) {
            return;
        }
        EntityTypes<?> var5 = var3.parseEntityType(var4.registryAccess(), Registries.ENTITY_TYPE);
        if (var2.getType() != var5) {
            return;
        }
        if (!(var0.isClientSide || !var2.getType().onlyOpCanSetNbt() || var1 != null && var4.getPlayerList().isOp(var1.getGameProfile()))) {
            return;
        }
        var3.loadInto(var2);
    }

    public boolean canSerialize() {
        return this.serialize;
    }

    public boolean canSummon() {
        return this.summon;
    }

    public boolean fireImmune() {
        return this.fireImmune;
    }

    public boolean canSpawnFarFromPlayer() {
        return this.canSpawnFarFromPlayer;
    }

    public EnumCreatureType getCategory() {
        return this.category;
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public IChatBaseComponent getDescription() {
        if (this.description == null) {
            this.description = IChatBaseComponent.translatable(this.getDescriptionId());
        }
        return this.description;
    }

    public String toString() {
        return this.getDescriptionId();
    }

    public String toShortString() {
        int var0 = this.getDescriptionId().lastIndexOf(46);
        return var0 == -1 ? this.getDescriptionId() : this.getDescriptionId().substring(var0 + 1);
    }

    public Optional<ResourceKey<LootTable>> getDefaultLootTable() {
        return this.lootTable;
    }

    public float getWidth() {
        return this.dimensions.width();
    }

    public float getHeight() {
        return this.dimensions.height();
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    @Nullable
    public T create(World var0, EntitySpawnReason var1) {
        if (!this.isEnabled(var0.enabledFeatures())) {
            return null;
        }
        return this.factory.create(this, var0);
    }

    public static Optional<Entity> create(NBTTagCompound var0, World var12, EntitySpawnReason var22) {
        return SystemUtils.ifElse(EntityTypes.by(var0).map(var2 -> var2.create(var12, var22)), var1 -> var1.load(var0), () -> LOGGER.warn("Skipping Entity with id {}", (Object)var0.getString("id")));
    }

    public AxisAlignedBB getSpawnAABB(double var0, double var2, double var4) {
        float var6 = this.spawnDimensionsScale * this.getWidth() / 2.0f;
        float var7 = this.spawnDimensionsScale * this.getHeight();
        return new AxisAlignedBB(var0 - (double)var6, var2, var4 - (double)var6, var0 + (double)var6, var2 + (double)var7, var4 + (double)var6);
    }

    public boolean isBlockDangerous(IBlockData var0) {
        if (this.immuneTo.contains((Object)var0.getBlock())) {
            return false;
        }
        if (!this.fireImmune && PathfinderAbstract.isBurningBlock(var0)) {
            return true;
        }
        return var0.is(Blocks.WITHER_ROSE) || var0.is(Blocks.SWEET_BERRY_BUSH) || var0.is(Blocks.CACTUS) || var0.is(Blocks.POWDER_SNOW);
    }

    public EntitySize getDimensions() {
        return this.dimensions;
    }

    public static Optional<EntityTypes<?>> by(NBTTagCompound var0) {
        return BuiltInRegistries.ENTITY_TYPE.getOptional(MinecraftKey.parse(var0.getString("id")));
    }

    @Nullable
    public static Entity loadEntityRecursive(NBTTagCompound var0, World var1, EntitySpawnReason var2, Function<Entity, Entity> var3) {
        return EntityTypes.loadStaticEntity(var0, var1, var2).map(var3).map(var4 -> {
            if (var0.contains("Passengers", 9)) {
                NBTTagList var5 = var0.getList("Passengers", 10);
                for (int var6 = 0; var6 < var5.size(); ++var6) {
                    Entity var7 = EntityTypes.loadEntityRecursive(var5.getCompound(var6), var1, var2, var3);
                    if (var7 == null) continue;
                    var7.startRiding((Entity)var4, true);
                }
            }
            return var4;
        }).orElse(null);
    }

    public static Stream<Entity> loadEntitiesRecursive(final List<? extends NBTBase> var0, final World var1, final EntitySpawnReason var2) {
        final Spliterator<? extends NBTBase> var3 = var0.spliterator();
        return StreamSupport.stream(new Spliterator<Entity>(){

            @Override
            public boolean tryAdvance(Consumer<? super Entity> var02) {
                return var3.tryAdvance((? super T var3) -> EntityTypes.loadEntityRecursive((NBTTagCompound)var3, var1, var2, var1 -> {
                    var02.accept((Entity)var1);
                    return var1;
                }));
            }

            @Override
            public Spliterator<Entity> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return var0.size();
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        }, false);
    }

    private static Optional<Entity> loadStaticEntity(NBTTagCompound var0, World var1, EntitySpawnReason var2) {
        try {
            return EntityTypes.create(var0, var1, var2);
        }
        catch (RuntimeException var3) {
            LOGGER.warn("Exception loading entity: ", (Throwable)var3);
            return Optional.empty();
        }
    }

    public int clientTrackingRange() {
        return this.clientTrackingRange;
    }

    public int updateInterval() {
        return this.updateInterval;
    }

    public boolean trackDeltas() {
        return this != PLAYER && this != LLAMA_SPIT && this != WITHER && this != BAT && this != ITEM_FRAME && this != GLOW_ITEM_FRAME && this != LEASH_KNOT && this != PAINTING && this != END_CRYSTAL && this != EVOKER_FANGS;
    }

    public boolean is(TagKey<EntityTypes<?>> var0) {
        return this.builtInRegistryHolder.is(var0);
    }

    public boolean is(HolderSet<EntityTypes<?>> var0) {
        return var0.contains(this.builtInRegistryHolder);
    }

    @Override
    @Nullable
    public T tryCast(Entity var0) {
        return (T)(var0.getType() == this ? var0 : null);
    }

    @Override
    public Class<? extends Entity> getBaseClass() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    private static b<EntityBoat> boatFactory(Supplier<Item> var0) {
        return (var1, var2) -> new EntityBoat(var1, var2, var0);
    }

    private static b<ChestBoat> chestBoatFactory(Supplier<Item> var0) {
        return (var1, var2) -> new ChestBoat(var1, var2, var0);
    }

    private static b<Raft> raftFactory(Supplier<Item> var0) {
        return (var1, var2) -> new Raft(var1, var2, var0);
    }

    private static b<ChestRaft> chestRaftFactory(Supplier<Item> var0) {
        return (var1, var2) -> new ChestRaft(var1, var2, var0);
    }

    public boolean onlyOpCanSetNbt() {
        return OP_ONLY_CUSTOM_DATA.contains(this);
    }

    public static class Builder<T extends Entity> {
        private final b<T> factory;
        private final EnumCreatureType category;
        private ImmutableSet<Block> immuneTo = ImmutableSet.of();
        private boolean serialize = true;
        private boolean summon = true;
        private boolean fireImmune;
        private boolean canSpawnFarFromPlayer;
        private int clientTrackingRange = 5;
        private int updateInterval = 3;
        private EntitySize dimensions = EntitySize.scalable(0.6f, 1.8f);
        private float spawnDimensionsScale = 1.0f;
        private EntityAttachments.a attachments = EntityAttachments.builder();
        private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
        private DependantName<EntityTypes<?>, Optional<ResourceKey<LootTable>>> lootTable = var0 -> Optional.of(ResourceKey.create(Registries.LOOT_TABLE, var0.location().withPrefix("entities/")));
        private DependantName<EntityTypes<?>, String> descriptionId = var0 -> SystemUtils.makeDescriptionId("entity", var0.location());

        private Builder(b<T> var02, EnumCreatureType var1) {
            this.factory = var02;
            this.category = var1;
            this.canSpawnFarFromPlayer = var1 == EnumCreatureType.CREATURE || var1 == EnumCreatureType.MISC;
        }

        public static <T extends Entity> Builder<T> of(b<T> var0, EnumCreatureType var1) {
            return new Builder<T>(var0, var1);
        }

        public static <T extends Entity> Builder<T> createNothing(EnumCreatureType var02) {
            return new Builder<Entity>((var0, var1) -> null, var02);
        }

        public Builder<T> sized(float var0, float var1) {
            this.dimensions = EntitySize.scalable(var0, var1);
            return this;
        }

        public Builder<T> spawnDimensionsScale(float var0) {
            this.spawnDimensionsScale = var0;
            return this;
        }

        public Builder<T> eyeHeight(float var0) {
            this.dimensions = this.dimensions.withEyeHeight(var0);
            return this;
        }

        public Builder<T> passengerAttachments(float ... var0) {
            for (float var4 : var0) {
                this.attachments = this.attachments.attach(EntityAttachment.PASSENGER, 0.0f, var4, 0.0f);
            }
            return this;
        }

        public Builder<T> passengerAttachments(Vec3D ... var0) {
            for (Vec3D var4 : var0) {
                this.attachments = this.attachments.attach(EntityAttachment.PASSENGER, var4);
            }
            return this;
        }

        public Builder<T> vehicleAttachment(Vec3D var0) {
            return this.attach(EntityAttachment.VEHICLE, var0);
        }

        public Builder<T> ridingOffset(float var0) {
            return this.attach(EntityAttachment.VEHICLE, 0.0f, -var0, 0.0f);
        }

        public Builder<T> nameTagOffset(float var0) {
            return this.attach(EntityAttachment.NAME_TAG, 0.0f, var0, 0.0f);
        }

        public Builder<T> attach(EntityAttachment var0, float var1, float var2, float var3) {
            this.attachments = this.attachments.attach(var0, var1, var2, var3);
            return this;
        }

        public Builder<T> attach(EntityAttachment var0, Vec3D var1) {
            this.attachments = this.attachments.attach(var0, var1);
            return this;
        }

        public Builder<T> noSummon() {
            this.summon = false;
            return this;
        }

        public Builder<T> noSave() {
            this.serialize = false;
            return this;
        }

        public Builder<T> fireImmune() {
            this.fireImmune = true;
            return this;
        }

        public Builder<T> immuneTo(Block ... var0) {
            this.immuneTo = ImmutableSet.copyOf((Object[])var0);
            return this;
        }

        public Builder<T> canSpawnFarFromPlayer() {
            this.canSpawnFarFromPlayer = true;
            return this;
        }

        public Builder<T> clientTrackingRange(int var0) {
            this.clientTrackingRange = var0;
            return this;
        }

        public Builder<T> updateInterval(int var0) {
            this.updateInterval = var0;
            return this;
        }

        public Builder<T> requiredFeatures(FeatureFlag ... var0) {
            this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
            return this;
        }

        public Builder<T> noLootTable() {
            this.lootTable = DependantName.fixed(Optional.empty());
            return this;
        }

        public EntityTypes<T> build(ResourceKey<EntityTypes<?>> var0) {
            if (this.serialize) {
                SystemUtils.fetchChoiceType(DataConverterTypes.ENTITY_TREE, var0.location().toString());
            }
            return new EntityTypes<T>(this.factory, this.category, this.serialize, this.summon, this.fireImmune, this.canSpawnFarFromPlayer, this.immuneTo, this.dimensions.withAttachments(this.attachments), this.spawnDimensionsScale, this.clientTrackingRange, this.updateInterval, this.descriptionId.get(var0), this.lootTable.get(var0), this.requiredFeatures);
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public T create(EntityTypes<T> var1, World var2);
    }
}

