/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemShield;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.slf4j.Logger;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    private static final MinecraftKey SPEED_MODIFIER_POWDER_SNOW_ID = MinecraftKey.withDefaultNamespace("powder_snow");
    private static final MinecraftKey SPRINTING_MODIFIER_ID = MinecraftKey.withDefaultNamespace("sprinting");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int HAND_SLOTS = 2;
    public static final int ARMOR_SLOTS = 4;
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final float BASE_JUMP_POWER = 0.42f;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    public static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final DataWatcherObject<Byte> DATA_LIVING_ENTITY_FLAGS = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Float> DATA_HEALTH_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<List<ParticleParam>> DATA_EFFECT_PARTICLES = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.PARTICLES);
    private static final DataWatcherObject<Boolean> DATA_EFFECT_AMBIENCE_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Integer> DATA_ARROW_COUNT_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_STINGER_COUNT_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Optional<BlockPosition>> SLEEPING_POS_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntitySize SLEEPING_DIMENSIONS = EntitySize.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    public static final String ATTRIBUTES_FIELD = "attributes";
    public static final Predicate<EntityLiving> PLAYER_NOT_WEARING_DISGUISE_ITEM = var0 -> {
        if (!(var0 instanceof EntityHuman)) {
            return true;
        }
        EntityHuman var1 = (EntityHuman)var0;
        ItemStack var2 = var1.getItemBySlot(EnumItemSlot.HEAD);
        return !var2.is(TagsItem.GAZE_DISGUISE_EQUIPMENT);
    };
    private final AttributeMapBase attributes;
    public CombatTracker combatTracker = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> activeEffects = Maps.newHashMap();
    private final NonNullList<ItemStack> lastHandItemStacks = NonNullList.withSize(2, ItemStack.EMPTY);
    private final NonNullList<ItemStack> lastArmorItemStacks = NonNullList.withSize(4, ItemStack.EMPTY);
    private ItemStack lastBodyItemStack = ItemStack.EMPTY;
    public boolean swinging;
    private boolean discardFriction = false;
    public EnumHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public final WalkAnimationState walkAnimation = new WalkAnimationState();
    public int invulnerableDuration = 20;
    public final float timeOffs;
    public final float rotA;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    public final ElytraAnimationState elytraAnimationState = new ElytraAnimationState(this);
    @Nullable
    public EntityHuman lastHurtByPlayer;
    protected int lastHurtByPlayerTime;
    protected boolean dead;
    protected int noActionTime;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected float rotOffs;
    public float lastHurt;
    protected boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    public boolean effectsDirty = true;
    @Nullable
    public EntityLiving lastHurtByMob;
    public int lastHurtByMobTimestamp;
    @Nullable
    private EntityLiving lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem = ItemStack.EMPTY;
    public int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPosition lastPos;
    private Optional<BlockPosition> lastClimbablePos = Optional.empty();
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    protected float autoSpinAttackDmg;
    @Nullable
    protected ItemStack autoSpinAttackItemStack;
    private float swimAmount;
    private float swimAmountO;
    protected BehaviorController<?> brain;
    protected boolean skipDropExperience;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> activeLocationDependentEnchantments = new EnumMap(EnumItemSlot.class);
    protected float appliedScale = 1.0f;

    protected EntityLiving(EntityTypes<? extends EntityLiving> var0, World var1) {
        super(var0, var1);
        this.attributes = new AttributeMapBase(AttributeDefaults.getSupplier(var0));
        this.setHealth(this.getMaxHealth());
        this.blocksBuilding = true;
        this.rotA = (float)((Math.random() + 1.0) * (double)0.01f);
        this.reapplyPosition();
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        DynamicOpsNBT var2 = DynamicOpsNBT.INSTANCE;
        this.brain = this.makeBrain(new Dynamic((DynamicOps)var2, (Object)((NBTBase)var2.createMap((Map)ImmutableMap.of((Object)var2.createString("memories"), (Object)((NBTBase)var2.emptyMap()))))));
    }

    public BehaviorController<?> getBrain() {
        return this.brain;
    }

    protected BehaviorController.b<?> brainProvider() {
        return BehaviorController.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return this.brainProvider().makeBrain(var0);
    }

    @Override
    public void kill(WorldServer var0) {
        this.hurtServer(var0, this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityTypes<?> var0) {
        return true;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        var0.define(DATA_EFFECT_PARTICLES, List.of());
        var0.define(DATA_EFFECT_AMBIENCE_ID, false);
        var0.define(DATA_ARROW_COUNT_ID, 0);
        var0.define(DATA_STINGER_COUNT_ID, 0);
        var0.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        var0.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeProvider.Builder createLivingAttributes() {
        return AttributeProvider.builder().add(GenericAttributes.MAX_HEALTH).add(GenericAttributes.KNOCKBACK_RESISTANCE).add(GenericAttributes.MOVEMENT_SPEED).add(GenericAttributes.ARMOR).add(GenericAttributes.ARMOR_TOUGHNESS).add(GenericAttributes.MAX_ABSORPTION).add(GenericAttributes.STEP_HEIGHT).add(GenericAttributes.SCALE).add(GenericAttributes.GRAVITY).add(GenericAttributes.SAFE_FALL_DISTANCE).add(GenericAttributes.FALL_DAMAGE_MULTIPLIER).add(GenericAttributes.JUMP_STRENGTH).add(GenericAttributes.OXYGEN_BONUS).add(GenericAttributes.BURNING_TIME).add(GenericAttributes.EXPLOSION_KNOCKBACK_RESISTANCE).add(GenericAttributes.WATER_MOVEMENT_EFFICIENCY).add(GenericAttributes.MOVEMENT_EFFICIENCY).add(GenericAttributes.ATTACK_KNOCKBACK);
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        World world;
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if ((world = this.level()) instanceof WorldServer) {
            WorldServer var5 = (WorldServer)world;
            if (var2 && this.fallDistance > 0.0f) {
                this.onChangedBlock(var5, var4);
                double var6 = this.getAttributeValue(GenericAttributes.SAFE_FALL_DISTANCE);
                if ((double)this.fallDistance > var6 && !var3.isAir()) {
                    double var8 = this.getX();
                    double var10 = this.getY();
                    double var12 = this.getZ();
                    BlockPosition var14 = this.blockPosition();
                    if (var4.getX() != var14.getX() || var4.getZ() != var14.getZ()) {
                        double var15 = var8 - (double)var4.getX() - 0.5;
                        double var17 = var12 - (double)var4.getZ() - 0.5;
                        double var19 = Math.max(Math.abs(var15), Math.abs(var17));
                        var8 = (double)var4.getX() + 0.5 + var15 / var19 * 0.5;
                        var12 = (double)var4.getZ() + 0.5 + var17 / var19 * 0.5;
                    }
                    float var15 = MathHelper.ceil((double)this.fallDistance - var6);
                    double var16 = Math.min((double)(0.2f + var15 / 15.0f), 2.5);
                    int var18 = (int)(150.0 * var16);
                    var5.sendParticles(new ParticleParamBlock(Particles.BLOCK, var3), var8, var10, var12, var18, 0.0, 0.0, 0.0, 0.15f);
                }
            }
        }
        super.checkFallDamage(var0, var2, var3, var4);
        if (var2) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public final boolean canBreatheUnderwater() {
        return this.getType().is(TagsEntity.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float var0) {
        return MathHelper.lerp(var0, this.swimAmountO, this.swimAmount);
    }

    public boolean hasLandedInLiquid() {
        return this.getDeltaMovement().y() < (double)1.0E-5f && this.isInLiquid();
    }

    @Override
    public void baseTick() {
        Object var0;
        World world;
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if ((world = this.level()) instanceof WorldServer) {
            var0 = (WorldServer)world;
            EnchantmentManager.tickEffects((WorldServer)var0, this);
        }
        super.baseTick();
        var0 = Profiler.get();
        var0.push("livingEntityBaseTick");
        if (this.fireImmune() || this.level().isClientSide) {
            this.clearFire();
        }
        if (this.isAlive()) {
            Object var3;
            double var5;
            boolean var1 = this instanceof EntityHuman;
            World world2 = this.level();
            if (world2 instanceof WorldServer) {
                double var32;
                WorldServer var2 = (WorldServer)world2;
                if (this.isInWall()) {
                    this.hurtServer(var2, this.damageSources().inWall(), 1.0f);
                } else if (var1 && !this.level().getWorldBorder().isWithinBounds(this.getBoundingBox()) && (var32 = this.level().getWorldBorder().getDistanceToBorder(this) + this.level().getWorldBorder().getDamageSafeZone()) < 0.0 && (var5 = this.level().getWorldBorder().getDamagePerBlock()) > 0.0) {
                    this.hurtServer(var2, this.damageSources().outOfBorder(), Math.max(1, MathHelper.floor(-var32 * var5)));
                }
            }
            if (this.isEyeInFluid(TagsFluid.WATER) && !this.level().getBlockState(BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean var2;
                boolean bl = var2 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!var1 || !((EntityHuman)this).getAbilities().invulnerable);
                if (var2) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.getAirSupply() == -20) {
                        this.setAirSupply(0);
                        var3 = this.getDeltaMovement();
                        for (int var4 = 0; var4 < 8; ++var4) {
                            var5 = this.random.nextDouble() - this.random.nextDouble();
                            double var7 = this.random.nextDouble() - this.random.nextDouble();
                            double var9 = this.random.nextDouble() - this.random.nextDouble();
                            this.level().addParticle(Particles.BUBBLE, this.getX() + var5, this.getY() + var7, this.getZ() + var9, ((Vec3D)var3).x, ((Vec3D)var3).y, ((Vec3D)var3).z);
                        }
                        this.hurt(this.damageSources().drown(), 2.0f);
                    }
                } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                    this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
                }
                if (!this.level().isClientSide && this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            var3 = this.level();
            if (var3 instanceof WorldServer) {
                WorldServer var2 = (WorldServer)var3;
                var3 = this.blockPosition();
                if (!Objects.equal((Object)this.lastPos, (Object)var3)) {
                    this.lastPos = var3;
                    this.onChangedBlock(var2, (BlockPosition)var3);
                }
            }
        }
        if (this.isAlive() && (this.isInWaterRainOrBubble() || this.isInPowderSnow)) {
            this.extinguishFire();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof EntityPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerTime > 0) {
            --this.lastHurtByPlayerTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if (this.lastHurtByMob != null) {
            if (!this.lastHurtByMob.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        var0.pop();
    }

    @Override
    protected float getBlockSpeedFactor() {
        return MathHelper.lerp((float)this.getAttributeValue(GenericAttributes.MOVEMENT_EFFICIENCY), super.getBlockSpeedFactor(), 1.0f);
    }

    protected void removeFrost() {
        AttributeModifiable var0 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (var0 == null) {
            return;
        }
        if (var0.getModifier(SPEED_MODIFIER_POWDER_SNOW_ID) != null) {
            var0.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
        }
    }

    protected void tryAddFrost() {
        int var0;
        if (!this.getBlockStateOnLegacy().isAir() && (var0 = this.getTicksFrozen()) > 0) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            if (var1 == null) {
                return;
            }
            float var2 = -0.05f * this.getPercentFrozen();
            var1.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, var2, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(WorldServer var0, BlockPosition var1) {
        EnchantmentManager.runLocationChangedEffects(var0, this);
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public final float getScale() {
        AttributeMapBase var0 = this.getAttributes();
        if (var0 == null) {
            return 1.0f;
        }
        return this.sanitizeScale((float)var0.getValue(GenericAttributes.SCALE));
    }

    protected float sanitizeScale(float var0) {
        return var0;
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot() {
        return !this.isBaby();
    }

    protected int decreaseAirSupply(int var0) {
        AttributeModifiable var1 = this.getAttribute(GenericAttributes.OXYGEN_BONUS);
        double var2 = var1 != null ? var1.getValue() : 0.0;
        if (var2 > 0.0 && this.random.nextDouble() >= 1.0 / (var2 + 1.0)) {
            return var0;
        }
        return var0 - 1;
    }

    protected int increaseAirSupply(int var0) {
        return Math.min(var0 + 4, this.getMaxAirSupply());
    }

    public final int getExperienceReward(WorldServer var0, @Nullable Entity var1) {
        return EnchantmentManager.processMobExperience(var0, var1, this, this.getBaseExperienceReward(var0));
    }

    protected int getBaseExperienceReward(WorldServer var0) {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    @Nullable
    public EntityLiving getLastHurtByMob() {
        return this.lastHurtByMob;
    }

    @Override
    public EntityLiving getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(@Nullable EntityHuman var0) {
        this.lastHurtByPlayer = var0;
        this.lastHurtByPlayerTime = this.tickCount;
    }

    public void setLastHurtByMob(@Nullable EntityLiving var0) {
        this.lastHurtByMob = var0;
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public EntityLiving getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity var0) {
        this.lastHurtMob = var0 instanceof EntityLiving ? (EntityLiving)var0 : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int var0) {
        this.noActionTime = var0;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean var0) {
        this.discardFriction = var0;
    }

    protected boolean doesEmitEquipEvent(EnumItemSlot var0) {
        return true;
    }

    public void onEquipItem(EnumItemSlot var0, ItemStack var1, ItemStack var2) {
        boolean var3;
        if (this.level().isClientSide() || this.isSpectator()) {
            return;
        }
        boolean bl = var3 = var2.isEmpty() && var1.isEmpty();
        if (var3 || ItemStack.isSameItemSameComponents(var1, var2) || this.firstTick) {
            return;
        }
        Equippable var4 = var2.get(DataComponents.EQUIPPABLE);
        if (!this.isSilent() && var4 != null && var0 == var4.slot()) {
            this.level().playSeededSound(null, this.getX(), this.getY(), this.getZ(), var4.equipSound(), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
        }
        if (this.doesEmitEquipEvent(var0)) {
            this.gameEvent(var4 != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
        }
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        World world;
        if ((var0 == Entity.RemovalReason.KILLED || var0 == Entity.RemovalReason.DISCARDED) && (world = this.level()) instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.triggerOnDeathMobEffects(var1, var0);
        }
        super.remove(var0);
        this.brain.clearMemories();
    }

    protected void triggerOnDeathMobEffects(WorldServer var0, Entity.RemovalReason var1) {
        for (MobEffect var3 : this.getActiveEffects()) {
            var3.onMobRemoved(var0, this, var1);
        }
        this.activeEffects.clear();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        DataResult<NBTBase> var12;
        var0.putFloat("Health", this.getHealth());
        var0.putShort("HurtTime", (short)this.hurtTime);
        var0.putInt("HurtByTimestamp", this.lastHurtByMobTimestamp);
        var0.putShort("DeathTime", (short)this.deathTime);
        var0.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        var0.put(ATTRIBUTES_FIELD, this.getAttributes().save());
        if (!this.activeEffects.isEmpty()) {
            var12 = new DataResult<NBTBase>();
            for (MobEffect var3 : this.activeEffects.values()) {
                var12.add(var3.save());
            }
            var0.put(TAG_ACTIVE_EFFECTS, (NBTBase)var12);
        }
        var0.putBoolean("FallFlying", this.isFallFlying());
        this.getSleepingPos().ifPresent(var1 -> {
            var0.putInt("SleepingX", var1.getX());
            var0.putInt("SleepingY", var1.getY());
            var0.putInt("SleepingZ", var1.getZ());
        });
        var12 = this.brain.serializeStart(DynamicOpsNBT.INSTANCE);
        var12.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("Brain", (NBTBase)var1));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        Object var3;
        Object var1;
        this.internalSetAbsorptionAmount(var0.getFloat("AbsorptionAmount"));
        if (var0.contains(ATTRIBUTES_FIELD, 9) && this.level() != null && !this.level().isClientSide) {
            this.getAttributes().load(var0.getList(ATTRIBUTES_FIELD, 10));
        }
        if (var0.contains(TAG_ACTIVE_EFFECTS, 9)) {
            var1 = var0.getList(TAG_ACTIVE_EFFECTS, 10);
            for (int var2 = 0; var2 < ((NBTTagList)var1).size(); ++var2) {
                var3 = ((NBTTagList)var1).getCompound(var2);
                MobEffect var4 = MobEffect.load((NBTTagCompound)var3);
                if (var4 == null) continue;
                this.activeEffects.put(var4.getEffect(), var4);
            }
        }
        if (var0.contains("Health", 99)) {
            this.setHealth(var0.getFloat("Health"));
        }
        this.hurtTime = var0.getShort("HurtTime");
        this.deathTime = var0.getShort("DeathTime");
        this.lastHurtByMobTimestamp = var0.getInt("HurtByTimestamp");
        if (var0.contains("Team", 8)) {
            boolean var4;
            var1 = var0.getString("Team");
            Scoreboard var2 = this.level().getScoreboard();
            var3 = var2.getPlayerTeam((String)var1);
            boolean bl = var4 = var3 != null && var2.addPlayerToTeam(this.getStringUUID(), (ScoreboardTeam)var3);
            if (!var4) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", var1);
            }
        }
        if (var0.getBoolean("FallFlying")) {
            this.setSharedFlag(7, true);
        }
        if (var0.contains("SleepingX", 99) && var0.contains("SleepingY", 99) && var0.contains("SleepingZ", 99)) {
            var1 = new BlockPosition(var0.getInt("SleepingX"), var0.getInt("SleepingY"), var0.getInt("SleepingZ"));
            this.setSleepingPos((BlockPosition)var1);
            this.entityData.set(DATA_POSE, EntityPose.SLEEPING);
            if (!this.firstTick) {
                this.setPosToBed((BlockPosition)var1);
            }
        }
        if (var0.contains("Brain", 10)) {
            this.brain = this.makeBrain(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.get("Brain")));
        }
    }

    protected void tickEffects() {
        Iterator<Holder<MobEffectList>> var0 = this.activeEffects.keySet().iterator();
        try {
            while (var0.hasNext()) {
                Holder<MobEffectList> var1 = var0.next();
                MobEffect var2 = this.activeEffects.get(var1);
                if (!var2.tick(this, () -> this.onEffectUpdated(var2, true, null))) {
                    if (this.level().isClientSide) continue;
                    var0.remove();
                    this.onEffectsRemoved(List.of(var2));
                    continue;
                }
                if (var2.getDuration() % 600 != 0) continue;
                this.onEffectUpdated(var2, false, null);
            }
        }
        catch (ConcurrentModificationException var1) {
            // empty catch block
        }
        if (this.effectsDirty) {
            if (!this.level().isClientSide) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
            }
            this.effectsDirty = false;
        }
        if (!(var1 = this.entityData.get(DATA_EFFECT_PARTICLES)).isEmpty()) {
            int var4;
            boolean var2 = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
            int var3 = this.isInvisible() ? 15 : 4;
            int n2 = var4 = var2 ? 5 : 1;
            if (this.random.nextInt(var3 * var4) == 0) {
                this.level().addParticle((ParticleParam)SystemUtils.getRandom(var1, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
            return;
        }
        this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
        this.updateSynchronizedMobEffectParticles();
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleParam> var0 = this.activeEffects.values().stream().filter(MobEffect::isVisible).map(MobEffect::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, var0);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, EntityLiving.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean var0 = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != var0) {
            this.setSharedFlag(6, var0);
        }
    }

    public double getVisibilityPercent(@Nullable Entity var0) {
        double var1 = 1.0;
        if (this.isDiscrete()) {
            var1 *= 0.8;
        }
        if (this.isInvisible()) {
            float var3 = this.getArmorCoverPercentage();
            if (var3 < 0.1f) {
                var3 = 0.1f;
            }
            var1 *= 0.7 * (double)var3;
        }
        if (var0 != null) {
            ItemStack var3 = this.getItemBySlot(EnumItemSlot.HEAD);
            EntityTypes<?> var4 = var0.getType();
            if (var4 == EntityTypes.SKELETON && var3.is(Items.SKELETON_SKULL) || var4 == EntityTypes.ZOMBIE && var3.is(Items.ZOMBIE_HEAD) || var4 == EntityTypes.PIGLIN && var3.is(Items.PIGLIN_HEAD) || var4 == EntityTypes.PIGLIN_BRUTE && var3.is(Items.PIGLIN_HEAD) || var4 == EntityTypes.CREEPER && var3.is(Items.CREEPER_HEAD)) {
                var1 *= 0.5;
            }
        }
        return var1;
    }

    public boolean canAttack(EntityLiving var0) {
        if (var0 instanceof EntityHuman && this.level().getDifficulty() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        return var0.canBeSeenAsEnemy();
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffect> var0) {
        for (MobEffect var2 : var0) {
            if (!var2.isVisible() || var2.isAmbient()) continue;
            return false;
        }
        return true;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.activeEffects.isEmpty()) {
            return false;
        }
        HashMap var0 = Maps.newHashMap(this.activeEffects);
        this.activeEffects.clear();
        this.onEffectsRemoved(var0.values());
        return true;
    }

    public Collection<MobEffect> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffectList> var0) {
        return this.activeEffects.containsKey(var0);
    }

    @Nullable
    public MobEffect getEffect(Holder<MobEffectList> var0) {
        return this.activeEffects.get(var0);
    }

    public final boolean addEffect(MobEffect var0) {
        return this.addEffect(var0, null);
    }

    public boolean addEffect(MobEffect var0, @Nullable Entity var1) {
        if (!this.canBeAffected(var0)) {
            return false;
        }
        MobEffect var2 = this.activeEffects.get(var0.getEffect());
        boolean var3 = false;
        if (var2 == null) {
            this.activeEffects.put(var0.getEffect(), var0);
            this.onEffectAdded(var0, var1);
            var3 = true;
            var0.onEffectAdded(this);
        } else if (var2.update(var0)) {
            this.onEffectUpdated(var2, true, var1);
            var3 = true;
        }
        var0.onEffectStarted(this);
        return var3;
    }

    public boolean canBeAffected(MobEffect var0) {
        if (this.getType().is(TagsEntity.IMMUNE_TO_INFESTED)) {
            return !var0.is(MobEffects.INFESTED);
        }
        if (this.getType().is(TagsEntity.IMMUNE_TO_OOZING)) {
            return !var0.is(MobEffects.OOZING);
        }
        if (this.getType().is(TagsEntity.IGNORES_POISON_AND_REGEN)) {
            return !var0.is(MobEffects.REGENERATION) && !var0.is(MobEffects.POISON);
        }
        return true;
    }

    public void forceAddEffect(MobEffect var0, @Nullable Entity var1) {
        if (!this.canBeAffected(var0)) {
            return;
        }
        MobEffect var2 = this.activeEffects.put(var0.getEffect(), var0);
        if (var2 == null) {
            this.onEffectAdded(var0, var1);
        } else {
            var0.copyBlendState(var2);
            this.onEffectUpdated(var0, true, var1);
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(TagsEntity.INVERTED_HEALING_AND_HARM);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> var0) {
        return this.activeEffects.remove(var0);
    }

    public boolean removeEffect(Holder<MobEffectList> var0) {
        MobEffect var1 = this.removeEffectNoUpdate(var0);
        if (var1 != null) {
            this.onEffectsRemoved(List.of(var1));
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffect var0, @Nullable Entity var1) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            var0.getEffect().value().addAttributeModifiers(this.getAttributes(), var0.getAmplifier());
            this.sendEffectToPassengers(var0);
        }
    }

    public void sendEffectToPassengers(MobEffect var0) {
        for (Entity var2 : this.getPassengers()) {
            if (!(var2 instanceof EntityPlayer)) continue;
            EntityPlayer var3 = (EntityPlayer)var2;
            var3.connection.send(new PacketPlayOutEntityEffect(this.getId(), var0, false));
        }
    }

    protected void onEffectUpdated(MobEffect var0, boolean var1, @Nullable Entity var2) {
        this.effectsDirty = true;
        if (var1 && !this.level().isClientSide) {
            MobEffectList var3 = var0.getEffect().value();
            var3.removeAttributeModifiers(this.getAttributes());
            var3.addAttributeModifiers(this.getAttributes(), var0.getAmplifier());
            this.refreshDirtyAttributes();
        }
        if (!this.level().isClientSide) {
            this.sendEffectToPassengers(var0);
        }
    }

    protected void onEffectsRemoved(Collection<MobEffect> var0) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            for (MobEffect var2 : var0) {
                var2.getEffect().value().removeAttributeModifiers(this.getAttributes());
                for (Entity var4 : this.getPassengers()) {
                    if (!(var4 instanceof EntityPlayer)) continue;
                    EntityPlayer var5 = (EntityPlayer)var4;
                    var5.connection.send(new PacketPlayOutRemoveEntityEffect(this.getId(), var2.getEffect()));
                }
            }
            this.refreshDirtyAttributes();
        }
    }

    private void refreshDirtyAttributes() {
        Set<AttributeModifiable> var0 = this.getAttributes().getAttributesToUpdate();
        for (AttributeModifiable var2 : var0) {
            this.onAttributeUpdated(var2.getAttribute());
        }
        var0.clear();
    }

    protected void onAttributeUpdated(Holder<AttributeBase> var0) {
        if (var0.is(GenericAttributes.MAX_HEALTH)) {
            float var1 = this.getMaxHealth();
            if (this.getHealth() > var1) {
                this.setHealth(var1);
            }
        } else if (var0.is(GenericAttributes.MAX_ABSORPTION)) {
            float var1 = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > var1) {
                this.setAbsorptionAmount(var1);
            }
        }
    }

    public void heal(float var0) {
        float var1 = this.getHealth();
        if (var1 > 0.0f) {
            this.setHealth(var1 + var0);
        }
    }

    public float getHealth() {
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float var0) {
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(MathHelper.clamp(var0, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        EntityPlayer var8;
        Entity entity;
        boolean var7;
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (var1.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        if (var2 < 0.0f) {
            var2 = 0.0f;
        }
        float var3 = var2;
        boolean var4 = false;
        float var5 = 0.0f;
        if (var2 > 0.0f && this.isDamageSourceBlocked(var1)) {
            Entity var6;
            this.hurtCurrentlyUsedShield(var2);
            var5 = var2;
            var2 = 0.0f;
            if (!var1.is(DamageTypeTags.IS_PROJECTILE) && (var6 = var1.getDirectEntity()) instanceof EntityLiving) {
                EntityLiving var72 = (EntityLiving)var6;
                this.blockUsingShield(var72);
            }
            var4 = true;
        }
        if (var1.is(DamageTypeTags.IS_FREEZING) && this.getType().is(TagsEntity.FREEZE_HURTS_EXTRA_TYPES)) {
            var2 *= 5.0f;
        }
        if (var1.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
            this.hurtHelmet(var1, var2);
            var2 *= 0.75f;
        }
        this.walkAnimation.setSpeed(1.5f);
        if (Float.isNaN(var2) || Float.isInfinite(var2)) {
            var2 = Float.MAX_VALUE;
        }
        boolean var6 = true;
        if ((float)this.invulnerableTime > 10.0f && !var1.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (var2 <= this.lastHurt) {
                return false;
            }
            this.actuallyHurt(var0, var1, var2 - this.lastHurt);
            this.lastHurt = var2;
            var6 = false;
        } else {
            this.lastHurt = var2;
            this.invulnerableTime = 20;
            this.actuallyHurt(var0, var1, var2);
            this.hurtTime = this.hurtDuration = 10;
        }
        this.resolveMobResponsibleForDamage(var1);
        this.resolvePlayerResponsibleForDamage(var1);
        if (var6) {
            if (var4) {
                var0.broadcastEntityEvent(this, (byte)29);
            } else {
                var0.broadcastDamageEvent(this, var1);
            }
            if (!(var1.is(DamageTypeTags.NO_IMPACT) || var4 && !(var2 > 0.0f))) {
                this.markHurt();
            }
            if (!var1.is(DamageTypeTags.NO_KNOCKBACK)) {
                double var73 = 0.0;
                double var9 = 0.0;
                Entity entity2 = var1.getDirectEntity();
                if (entity2 instanceof IProjectile) {
                    IProjectile var11 = (IProjectile)entity2;
                    DoubleDoubleImmutablePair var12 = var11.calculateHorizontalHurtKnockbackDirection(this, var1);
                    var73 = -var12.leftDouble();
                    var9 = -var12.rightDouble();
                } else if (var1.getSourcePosition() != null) {
                    var73 = var1.getSourcePosition().x() - this.getX();
                    var9 = var1.getSourcePosition().z() - this.getZ();
                }
                this.knockback(0.4f, var73, var9);
                if (!var4) {
                    this.indicateDamage(var73, var9);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(var1)) {
                if (var6) {
                    this.makeSound(this.getDeathSound());
                }
                this.die(var1);
            }
        } else if (var6) {
            this.playHurtSound(var1);
        }
        boolean bl = var7 = !var4 || var2 > 0.0f;
        if (var7) {
            this.lastDamageSource = var1;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffect var9 : this.getActiveEffects()) {
                var9.onMobHurt(var0, this, var1, var2);
            }
        }
        if ((entity = this) instanceof EntityPlayer) {
            var8 = (EntityPlayer)entity;
            CriterionTriggers.ENTITY_HURT_PLAYER.trigger(var8, var1, var3, var2, var4);
            if (var5 > 0.0f && var5 < 3.4028235E37f) {
                var8.awardStat(StatisticList.DAMAGE_BLOCKED_BY_SHIELD, Math.round(var5 * 10.0f));
            }
        }
        if ((entity = var1.getEntity()) instanceof EntityPlayer) {
            var8 = (EntityPlayer)entity;
            CriterionTriggers.PLAYER_HURT_ENTITY.trigger(var8, this, var1, var3, var2, var4);
        }
        return var7;
    }

    protected void resolveMobResponsibleForDamage(DamageSource var0) {
        Entity entity = var0.getEntity();
        if (entity instanceof EntityLiving) {
            EntityLiving var1 = (EntityLiving)entity;
            if (!(var0.is(DamageTypeTags.NO_ANGER) || var0.is(DamageTypes.WIND_CHARGE) && this.getType().is(TagsEntity.NO_ANGER_FROM_WIND_CHARGE))) {
                this.setLastHurtByMob(var1);
            }
        }
    }

    @Nullable
    protected EntityHuman resolvePlayerResponsibleForDamage(DamageSource var0) {
        EntityWolf var3;
        Entity var1 = var0.getEntity();
        if (var1 instanceof EntityHuman) {
            EntityHuman var2 = (EntityHuman)var1;
            this.lastHurtByPlayerTime = 100;
            this.lastHurtByPlayer = var2;
            return var2;
        }
        if (var1 instanceof EntityWolf && (var3 = (EntityWolf)var1).isTame()) {
            EntityHuman var4;
            this.lastHurtByPlayerTime = 100;
            EntityLiving entityLiving = var3.getOwner();
            this.lastHurtByPlayer = entityLiving instanceof EntityHuman ? (var4 = (EntityHuman)entityLiving) : null;
            return this.lastHurtByPlayer;
        }
        return null;
    }

    protected void blockUsingShield(EntityLiving var0) {
        var0.blockedByShield(this);
    }

    protected void blockedByShield(EntityLiving var0) {
        var0.knockback(0.5, var0.getX() - this.getX(), var0.getZ() - this.getZ());
    }

    private boolean checkTotemDeathProtection(DamageSource var0) {
        if (var0.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack var1 = null;
        DeathProtection var2 = null;
        for (EnumHand var7 : EnumHand.values()) {
            ItemStack var3 = this.getItemInHand(var7);
            var2 = var3.get(DataComponents.DEATH_PROTECTION);
            if (var2 == null) continue;
            var1 = var3.copy();
            var3.shrink(1);
            break;
        }
        if (var1 != null) {
            EntityLiving entityLiving = this;
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer var4 = (EntityPlayer)entityLiving;
                var4.awardStat(StatisticList.ITEM_USED.get(var1.getItem()));
                CriterionTriggers.USED_TOTEM.trigger(var4, var1);
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            var2.applyEffects(var1, this);
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return var2 != null;
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource var0) {
        this.makeSound(this.getHurtSound(var0));
    }

    public void makeSound(@Nullable SoundEffect var0) {
        if (var0 != null) {
            this.playSound(var0, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isDamageSourceBlocked(DamageSource var0) {
        Vec3D var4;
        Object var3;
        Entity var1 = var0.getDirectEntity();
        boolean var2 = false;
        if (var1 instanceof EntityArrow && ((EntityArrow)(var3 = (EntityArrow)var1)).getPierceLevel() > 0) {
            var2 = true;
        }
        var3 = this.getItemBlockingWith();
        if (!var0.is(DamageTypeTags.BYPASSES_SHIELD) && var3 != null && ((ItemStack)var3).getItem() instanceof ItemShield && !var2 && (var4 = var0.getSourcePosition()) != null) {
            Vec3D var5 = this.calculateViewVector(0.0f, this.getYHeadRot());
            Vec3D var6 = var4.vectorTo(this.position());
            var6 = new Vec3D(var6.x, 0.0, var6.z).normalize();
            return var6.dot(var5) < 0.0;
        }
        return false;
    }

    private void breakItem(ItemStack var0) {
        if (!var0.isEmpty()) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), var0.getBreakingSound(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(var0, 5);
        }
    }

    public void die(DamageSource var0) {
        if (this.isRemoved() || this.dead) {
            return;
        }
        Entity var1 = var0.getEntity();
        EntityLiving var2 = this.getKillCredit();
        if (var2 != null) {
            var2.awardKillScore(this, var0);
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if (!this.level().isClientSide && this.hasCustomName()) {
            LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
        }
        this.dead = true;
        this.getCombatTracker().recheckStatus();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var3 = (WorldServer)world;
            if (var1 == null || var1.killedEntity(var3, this)) {
                this.gameEvent(GameEvent.ENTITY_DIE);
                this.dropAllDeathLoot(var3, var0);
                this.createWitherRose(var2);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
        }
        this.setPose(EntityPose.DYING);
    }

    protected void createWitherRose(@Nullable EntityLiving var0) {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        boolean var2 = false;
        if (var0 instanceof EntityWither) {
            Object var3;
            if (var1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                var3 = this.blockPosition();
                IBlockData var4 = Blocks.WITHER_ROSE.defaultBlockState();
                if (this.level().getBlockState((BlockPosition)var3).isAir() && var4.canSurvive(this.level(), (BlockPosition)var3)) {
                    this.level().setBlock((BlockPosition)var3, var4, 3);
                    var2 = true;
                }
            }
            if (!var2) {
                var3 = new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                this.level().addFreshEntity((Entity)var3);
            }
        }
    }

    protected void dropAllDeathLoot(WorldServer var0, DamageSource var1) {
        boolean var2;
        boolean bl = var2 = this.lastHurtByPlayerTime > 0;
        if (this.shouldDropLoot() && var0.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(var0, var1, var2);
            this.dropCustomDeathLoot(var0, var1, var2);
        }
        this.dropEquipment(var0);
        this.dropExperience(var0, var1.getEntity());
    }

    protected void dropEquipment(WorldServer var0) {
    }

    protected void dropExperience(WorldServer var0, @Nullable Entity var1) {
        if (!this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerTime > 0 && this.shouldDropExperience() && var0.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
            EntityExperienceOrb.award(var0, this.position(), this.getExperienceReward(var0, var1));
        }
    }

    protected void dropCustomDeathLoot(WorldServer var0, DamageSource var1, boolean var2) {
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected float getKnockback(Entity var0, DamageSource var1) {
        float var2 = (float)this.getAttributeValue(GenericAttributes.ATTACK_KNOCKBACK);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var3 = (WorldServer)world;
            return EnchantmentManager.modifyKnockback(var3, this.getWeaponItem(), var0, var1, var2);
        }
        return var2;
    }

    protected void dropFromLootTable(WorldServer var0, DamageSource var12, boolean var2) {
        Optional<ResourceKey<LootTable>> var3 = this.getLootTable();
        if (var3.isEmpty()) {
            return;
        }
        LootTable var4 = var0.getServer().reloadableRegistries().getLootTable(var3.get());
        LootParams.a var5 = new LootParams.a(var0).withParameter(LootContextParameters.THIS_ENTITY, this).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.DAMAGE_SOURCE, var12).withOptionalParameter(LootContextParameters.ATTACKING_ENTITY, var12.getEntity()).withOptionalParameter(LootContextParameters.DIRECT_ATTACKING_ENTITY, var12.getDirectEntity());
        if (var2 && this.lastHurtByPlayer != null) {
            var5 = var5.withParameter(LootContextParameters.LAST_DAMAGE_PLAYER, this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        LootParams var6 = var5.create(LootContextParameterSets.ENTITY);
        var4.getRandomItems(var6, this.getLootTableSeed(), var1 -> this.spawnAtLocation(var0, (ItemStack)var1));
    }

    public boolean dropFromGiftLootTable(WorldServer var02, ResourceKey<LootTable> var1, BiConsumer<WorldServer, ItemStack> var2) {
        return this.dropFromLootTable(var02, var1, var0 -> var0.withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.GIFT), var2);
    }

    protected void dropFromShearingLootTable(WorldServer var0, ResourceKey<LootTable> var12, ItemStack var2, BiConsumer<WorldServer, ItemStack> var3) {
        this.dropFromLootTable(var0, var12, var1 -> var1.withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).withParameter(LootContextParameters.TOOL, var2).create(LootContextParameterSets.SHEARING), var3);
    }

    protected boolean dropFromLootTable(WorldServer var0, ResourceKey<LootTable> var1, Function<LootParams.a, LootParams> var22, BiConsumer<WorldServer, ItemStack> var3) {
        LootParams var5;
        LootTable var4 = var0.getServer().reloadableRegistries().getLootTable(var1);
        ObjectArrayList<ItemStack> var6 = var4.getRandomItems(var5 = var22.apply(new LootParams.a(var0)));
        if (!var6.isEmpty()) {
            var6.forEach(var2 -> var3.accept(var0, (ItemStack)var2));
            return true;
        }
        return false;
    }

    public void knockback(double var0, double var2, double var4) {
        if ((var0 *= 1.0 - this.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE)) <= 0.0) {
            return;
        }
        this.hasImpulse = true;
        Vec3D var6 = this.getDeltaMovement();
        while (var2 * var2 + var4 * var4 < (double)1.0E-5f) {
            var2 = (Math.random() - Math.random()) * 0.01;
            var4 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D var7 = new Vec3D(var2, 0.0, var4).normalize().scale(var0);
        this.setDeltaMovement(var6.x / 2.0 - var7.x, this.onGround() ? Math.min(0.4, var6.y / 2.0 + var0) : var6.y, var6.z / 2.0 - var7.z);
    }

    public void indicateDamage(double var0, double var2) {
    }

    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.GENERIC_HURT;
    }

    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.GENERIC_DEATH;
    }

    private SoundEffect getFallDamageSound(int var0) {
        return var0 > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AxisAlignedBB getHitbox() {
        AxisAlignedBB var0 = this.getBoundingBox();
        Entity var1 = this.getVehicle();
        if (var1 != null) {
            Vec3D var2 = var1.getPassengerRidingPosition(this);
            return var0.setMinY(Math.max(var2.y, var0.minY));
        }
        return var0;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments(EnumItemSlot var02) {
        return (Map)this.activeLocationDependentEnchantments.computeIfAbsent(var02, var0 -> new Reference2ObjectArrayMap());
    }

    public boolean canBeNameTagged() {
        return true;
    }

    public a getFallSounds() {
        return new a(SoundEffects.GENERIC_SMALL_FALL, SoundEffects.GENERIC_BIG_FALL);
    }

    public Optional<BlockPosition> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPosition var0 = this.blockPosition();
        IBlockData var1 = this.getInBlockState();
        if (var1.is(TagsBlock.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of(var0);
            return true;
        }
        if (var1.getBlock() instanceof BlockTrapdoor && this.trapdoorUsableAsLadder(var0, var1)) {
            this.lastClimbablePos = Optional.of(var0);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPosition var0, IBlockData var1) {
        if (var1.getValue(BlockTrapdoor.OPEN).booleanValue()) {
            IBlockData var2 = this.level().getBlockState(var0.below());
            return var2.is(Blocks.LADDER) && var2.getValue(BlockLadder.FACING) == var1.getValue(BlockTrapdoor.FACING);
        }
        return false;
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f;
    }

    public boolean isLookingAtMe(EntityLiving var0, double var1, boolean var3, boolean var4, double ... var5) {
        Vec3D var6 = var0.getViewVector(1.0f).normalize();
        for (double var10 : var5) {
            Vec3D var12 = new Vec3D(this.getX() - var0.getX(), var10 - var0.getEyeY(), this.getZ() - var0.getZ());
            double var13 = var12.length();
            var12 = var12.normalize();
            double var15 = var6.dot(var12);
            double d2 = var3 ? var13 : 1.0;
            if (!(var15 > 1.0 - var1 / d2) || !var0.hasLineOfSight(this, var4 ? RayTrace.BlockCollisionOption.VISUAL : RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var10)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float var0) {
        return MathHelper.floor(var0 + 3.0f);
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        boolean var3 = super.causeFallDamage(var0, var1, var2);
        int var4 = this.calculateFallDamage(var0, var1);
        if (var4 > 0) {
            this.playSound(this.getFallDamageSound(var4), 1.0f, 1.0f);
            this.playBlockFallSound();
            this.hurt(var2, var4);
            return true;
        }
        return var3;
    }

    protected int calculateFallDamage(float var0, float var1) {
        if (this.getType().is(TagsEntity.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        float var2 = (float)this.getAttributeValue(GenericAttributes.SAFE_FALL_DISTANCE);
        float var3 = var0 - var2;
        return MathHelper.ceil((double)(var3 * var1) * this.getAttributeValue(GenericAttributes.FALL_DAMAGE_MULTIPLIER));
    }

    protected void playBlockFallSound() {
        if (this.isSilent()) {
            return;
        }
        int var0 = MathHelper.floor(this.getX());
        int var1 = MathHelper.floor(this.getY() - (double)0.2f);
        int var2 = MathHelper.floor(this.getZ());
        IBlockData var3 = this.level().getBlockState(new BlockPosition(var0, var1, var2));
        if (!var3.isAir()) {
            SoundEffectType var4 = var3.getSoundType();
            this.playSound(var4.getFallSound(), var4.getVolume() * 0.5f, var4.getPitch() * 0.75f);
        }
    }

    @Override
    public void animateHurt(float var0) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return MathHelper.floor(this.getAttributeValue(GenericAttributes.ARMOR));
    }

    protected void hurtArmor(DamageSource var0, float var1) {
    }

    protected void hurtHelmet(DamageSource var0, float var1) {
    }

    protected void hurtCurrentlyUsedShield(float var0) {
    }

    protected void doHurtEquipment(DamageSource var0, float var1, EnumItemSlot ... var2) {
        if (var1 <= 0.0f) {
            return;
        }
        int var3 = (int)Math.max(1.0f, var1 / 4.0f);
        for (EnumItemSlot var7 : var2) {
            ItemStack var8 = this.getItemBySlot(var7);
            Equippable var9 = var8.get(DataComponents.EQUIPPABLE);
            if (var9 == null || !var9.damageOnHurt() || !var8.isDamageableItem() || !var8.canBeHurtBy(var0)) continue;
            var8.hurtAndBreak(var3, this, var7);
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource var0, float var1) {
        if (!var0.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.hurtArmor(var0, var1);
            var1 = CombatMath.getDamageAfterAbsorb(this, var1, var0, this.getArmorValue(), (float)this.getAttributeValue(GenericAttributes.ARMOR_TOUGHNESS));
        }
        return var1;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource var0, float var1) {
        float var2;
        int var22;
        int var3;
        float var4;
        float var5;
        float var6;
        if (var0.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return var1;
        }
        if (this.hasEffect(MobEffects.DAMAGE_RESISTANCE) && !var0.is(DamageTypeTags.BYPASSES_RESISTANCE) && (var6 = (var5 = var1) - (var1 = Math.max((var4 = var1 * (float)(var3 = 25 - (var22 = (this.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && var6 < 3.4028235E37f) {
            if (this instanceof EntityPlayer) {
                ((EntityPlayer)this).awardStat(StatisticList.DAMAGE_RESISTED, Math.round(var6 * 10.0f));
            } else if (var0.getEntity() instanceof EntityPlayer) {
                ((EntityPlayer)var0.getEntity()).awardStat(StatisticList.DAMAGE_DEALT_RESISTED, Math.round(var6 * 10.0f));
            }
        }
        if (var1 <= 0.0f) {
            return 0.0f;
        }
        if (var0.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return var1;
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var32 = (WorldServer)world;
            var2 = EnchantmentManager.getDamageProtection(var32, this, var0);
        } else {
            var2 = 0.0f;
        }
        if (var2 > 0.0f) {
            var1 = CombatMath.getDamageAfterMagicAbsorb(var1, var2);
        }
        return var1;
    }

    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        Entity entity;
        if (this.isInvulnerableTo(var0, var1)) {
            return;
        }
        var2 = this.getDamageAfterArmorAbsorb(var1, var2);
        float var3 = var2 = this.getDamageAfterMagicAbsorb(var1, var2);
        var2 = Math.max(var2 - this.getAbsorptionAmount(), 0.0f);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - (var3 - var2));
        float var4 = var3 - var2;
        if (var4 > 0.0f && var4 < 3.4028235E37f && (entity = var1.getEntity()) instanceof EntityPlayer) {
            EntityPlayer var5 = (EntityPlayer)entity;
            var5.awardStat(StatisticList.DAMAGE_DEALT_ABSORBED, Math.round(var4 * 10.0f));
        }
        if (var2 == 0.0f) {
            return;
        }
        this.getCombatTracker().recordDamage(var1, var2);
        this.setHealth(this.getHealth() - var2);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - var2);
        this.gameEvent(GameEvent.ENTITY_DAMAGE);
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public EntityLiving getKillCredit() {
        if (this.lastHurtByPlayer != null) {
            return this.lastHurtByPlayer;
        }
        if (this.lastHurtByMob != null) {
            return this.lastHurtByMob;
        }
        return null;
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(GenericAttributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(GenericAttributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int var0) {
        this.entityData.set(DATA_ARROW_COUNT_ID, var0);
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int var0) {
        this.entityData.set(DATA_STINGER_COUNT_ID, var0);
    }

    private int getCurrentSwingDuration() {
        if (MobEffectUtil.hasDigSpeed(this)) {
            return 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this));
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            return 6 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2;
        }
        return 6;
    }

    public void swing(EnumHand var0) {
        this.swing(var0, false);
    }

    public void swing(EnumHand var0, boolean var1) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = var0;
            if (this.level() instanceof WorldServer) {
                PacketPlayOutAnimation var2 = new PacketPlayOutAnimation(this, var0 == EnumHand.MAIN_HAND ? 0 : 3);
                ChunkProviderServer var3 = ((WorldServer)this.level()).getChunkSource();
                if (var1) {
                    var3.broadcastAndSend(this, var2);
                } else {
                    var3.broadcast(this, var2);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource var0) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = 20;
        this.hurtTime = this.hurtDuration = 10;
        SoundEffect var1 = this.getHurtSound(var0);
        if (var1 != null) {
            this.playSound(var1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.lastDamageSource = var0;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte var0) {
        switch (var0) {
            case 3: {
                SoundEffect var1 = this.getDeathSound();
                if (var1 != null) {
                    this.playSound(var1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 30: {
                this.playSound(SoundEffects.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 29: {
                this.playSound(SoundEffects.SHIELD_BLOCK, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                int var1 = 128;
                for (int var2 = 0; var2 < 128; ++var2) {
                    double var3 = (double)var2 / 127.0;
                    float var5 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float var6 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float var7 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double var8 = MathHelper.lerp(var3, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double var10 = MathHelper.lerp(var3, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double var12 = MathHelper.lerp(var3, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(Particles.PORTAL, var8, var10, var12, var5, var6, var7);
                }
                break;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.FEET));
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.BODY));
                break;
            }
            case 54: {
                BlockHoney.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            default: {
                super.handleEntityEvent(var0);
            }
        }
    }

    public void makePoofParticles() {
        for (int var0 = 0; var0 < 20; ++var0) {
            double var1 = this.random.nextGaussian() * 0.02;
            double var3 = this.random.nextGaussian() * 0.02;
            double var5 = this.random.nextGaussian() * 0.02;
            double var7 = 10.0;
            this.level().addParticle(Particles.POOF, this.getRandomX(1.0) - var1 * 10.0, this.getRandomY() - var3 * 10.0, this.getRandomZ(1.0) - var5 * 10.0, var1, var3, var5);
        }
    }

    private void swapHandItems() {
        ItemStack var0 = this.getItemBySlot(EnumItemSlot.OFFHAND);
        this.setItemSlot(EnumItemSlot.OFFHAND, this.getItemBySlot(EnumItemSlot.MAINHAND));
        this.setItemSlot(EnumItemSlot.MAINHAND, var0);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), 4.0f);
    }

    protected void updateSwingTime() {
        int var0 = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= var0) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)var0;
    }

    @Nullable
    public AttributeModifiable getAttribute(Holder<AttributeBase> var0) {
        return this.getAttributes().getInstance(var0);
    }

    public double getAttributeValue(Holder<AttributeBase> var0) {
        return this.getAttributes().getValue(var0);
    }

    public double getAttributeBaseValue(Holder<AttributeBase> var0) {
        return this.getAttributes().getBaseValue(var0);
    }

    public AttributeMapBase getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EnumItemSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EnumItemSlot.OFFHAND);
    }

    public ItemStack getItemHeldByArm(EnumMainHand var0) {
        return this.getMainArm() == var0 ? this.getMainHandItem() : this.getOffhandItem();
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        return this.getMainHandItem();
    }

    public boolean isHolding(Item var0) {
        return this.isHolding((ItemStack var1) -> var1.is(var0));
    }

    public boolean isHolding(Predicate<ItemStack> var0) {
        return var0.test(this.getMainHandItem()) || var0.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(EnumHand var0) {
        if (var0 == EnumHand.MAIN_HAND) {
            return this.getItemBySlot(EnumItemSlot.MAINHAND);
        }
        if (var0 == EnumHand.OFF_HAND) {
            return this.getItemBySlot(EnumItemSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)var0));
    }

    public void setItemInHand(EnumHand var0, ItemStack var1) {
        if (var0 == EnumHand.MAIN_HAND) {
            this.setItemSlot(EnumItemSlot.MAINHAND, var1);
        } else if (var0 == EnumHand.OFF_HAND) {
            this.setItemSlot(EnumItemSlot.OFFHAND, var1);
        } else {
            throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)var0));
        }
    }

    public boolean hasItemInSlot(EnumItemSlot var0) {
        return !this.getItemBySlot(var0).isEmpty();
    }

    public boolean canUseSlot(EnumItemSlot var0) {
        return false;
    }

    public abstract Iterable<ItemStack> getArmorSlots();

    public abstract ItemStack getItemBySlot(EnumItemSlot var1);

    public abstract void setItemSlot(EnumItemSlot var1, ItemStack var2);

    public Iterable<ItemStack> getHandSlots() {
        return List.of();
    }

    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        return this.getArmorSlots();
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorAndBodyArmorSlots());
    }

    protected void verifyEquippedItem(ItemStack var0) {
        var0.getItem().verifyComponentsAfterLoad(var0);
    }

    public float getArmorCoverPercentage() {
        Iterable<ItemStack> var0 = this.getArmorSlots();
        int var1 = 0;
        int var2 = 0;
        for (ItemStack var4 : var0) {
            if (!var4.isEmpty()) {
                ++var2;
            }
            ++var1;
        }
        return var1 > 0 ? (float)var2 / (float)var1 : 0.0f;
    }

    @Override
    public void setSprinting(boolean var0) {
        super.setSprinting(var0);
        AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        var1.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (var0) {
            var1.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity var0) {
        if (!this.isSleeping()) {
            super.push(var0);
        }
    }

    private void dismountVehicle(Entity var0) {
        Vec3D var1;
        if (this.isRemoved()) {
            var1 = this.position();
        } else if (var0.isRemoved() || this.level().getBlockState(var0.blockPosition()).is(TagsBlock.PORTALS)) {
            boolean var4;
            double var22 = Math.max(this.getY(), var0.getY());
            var1 = new Vec3D(this.getX(), var22, this.getZ());
            boolean bl = var4 = this.getBbWidth() <= 4.0f && this.getBbHeight() <= 4.0f;
            if (var4) {
                double var5 = (double)this.getBbHeight() / 2.0;
                Vec3D var7 = var1.add(0.0, var5, 0.0);
                VoxelShape var8 = VoxelShapes.create(AxisAlignedBB.ofSize(var7, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()));
                var1 = this.level().findFreePosition(this, var8, var7, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).map(var2 -> var2.add(0.0, -var5, 0.0)).orElse(var1);
            }
        } else {
            var1 = var0.getDismountLocationForPassenger(this);
        }
        this.dismountTo(var1.x, var1.y, var1.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float var0) {
        return (float)this.getAttributeValue(GenericAttributes.JUMP_STRENGTH) * var0 * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP).getAmplifier() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void jumpFromGround() {
        float var0 = this.getJumpPower();
        if (var0 <= 1.0E-5f) {
            return;
        }
        Vec3D var1 = this.getDeltaMovement();
        this.setDeltaMovement(var1.x, Math.max((double)var0, var1.y), var1.z);
        if (this.isSprinting()) {
            float var2 = this.getYRot() * ((float)Math.PI / 180);
            this.addDeltaMovement(new Vec3D((double)(-MathHelper.sin(var2)) * 0.2, 0.0, (double)MathHelper.cos(var2) * 0.2));
        }
        this.hasImpulse = true;
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<FluidType> var0) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(Fluid var0) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(GenericAttributes.GRAVITY);
    }

    protected double getEffectiveGravity() {
        boolean var0;
        boolean bl = var0 = this.getDeltaMovement().y <= 0.0;
        if (var0 && this.hasEffect(MobEffects.SLOW_FALLING)) {
            return Math.min(this.getGravity(), 0.01);
        }
        return this.getGravity();
    }

    public void travel(Vec3D var0) {
        if (!this.isControlledByLocalInstance()) {
            return;
        }
        Fluid var1 = this.level().getFluidState(this.blockPosition());
        if ((this.isInWater() || this.isInLava()) && this.isAffectedByFluids() && !this.canStandOnFluid(var1)) {
            this.travelInFluid(var0);
        } else if (this.isFallFlying()) {
            this.travelFallFlying();
        } else {
            this.travelInAir(var0);
        }
    }

    private void travelInAir(Vec3D var0) {
        BlockPosition var1 = this.getBlockPosBelowThatAffectsMyMovement();
        float var2 = this.onGround() ? this.level().getBlockState(var1).getBlock().getFriction() : 1.0f;
        float var3 = var2 * 0.91f;
        Vec3D var4 = this.handleRelativeFrictionAndCalculateMovement(var0, var2);
        double var5 = var4.y;
        MobEffect var7 = this.getEffect(MobEffects.LEVITATION);
        var5 = var7 != null ? (var5 += (0.05 * (double)(var7.getAmplifier() + 1) - var4.y) * 0.2) : (!this.level().isClientSide || this.level().hasChunkAt(var1) ? (var5 -= this.getEffectiveGravity()) : (this.getY() > (double)this.level().getMinY() ? -0.1 : 0.0));
        if (this.shouldDiscardFriction()) {
            this.setDeltaMovement(var4.x, var5, var4.z);
        } else {
            float var8 = this instanceof EntityBird ? var3 : 0.98f;
            this.setDeltaMovement(var4.x * (double)var3, var5 * (double)var8, var4.z * (double)var3);
        }
    }

    private void travelInFluid(Vec3D var0) {
        boolean var1 = this.getDeltaMovement().y <= 0.0;
        double var2 = this.getY();
        double var4 = this.getEffectiveGravity();
        if (this.isInWater()) {
            float var6 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
            float var7 = 0.02f;
            float var8 = (float)this.getAttributeValue(GenericAttributes.WATER_MOVEMENT_EFFICIENCY);
            if (!this.onGround()) {
                var8 *= 0.5f;
            }
            if (var8 > 0.0f) {
                var6 += (0.54600006f - var6) * var8;
                var7 += (this.getSpeed() - var7) * var8;
            }
            if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                var6 = 0.96f;
            }
            this.moveRelative(var7, var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            Vec3D var9 = this.getDeltaMovement();
            if (this.horizontalCollision && this.onClimbable()) {
                var9 = new Vec3D(var9.x, 0.2, var9.z);
            }
            var9 = var9.multiply(var6, 0.8f, var6);
            this.setDeltaMovement(this.getFluidFallingAdjustedMovement(var4, var1, var9));
        } else {
            this.moveRelative(0.02f, var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            if (this.getFluidHeight(TagsFluid.LAVA) <= this.getFluidJumpThreshold()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                Vec3D var6 = this.getFluidFallingAdjustedMovement(var4, var1, this.getDeltaMovement());
                this.setDeltaMovement(var6);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            }
            if (var4 != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -var4 / 4.0, 0.0));
            }
        }
        Vec3D var6 = this.getDeltaMovement();
        if (this.horizontalCollision && this.isFree(var6.x, var6.y + (double)0.6f - this.getY() + var2, var6.z)) {
            this.setDeltaMovement(var6.x, 0.3f, var6.z);
        }
    }

    private void travelFallFlying() {
        Vec3D var0 = this.getDeltaMovement();
        double var1 = var0.horizontalDistance();
        this.setDeltaMovement(this.updateFallFlyingMovement(var0));
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            double var3 = this.getDeltaMovement().horizontalDistance();
            this.handleFallFlyingCollisions(var1, var3);
        }
    }

    private Vec3D updateFallFlyingMovement(Vec3D var0) {
        double var11;
        Vec3D var1 = this.getLookAngle();
        float var2 = this.getXRot() * ((float)Math.PI / 180);
        double var3 = Math.sqrt(var1.x * var1.x + var1.z * var1.z);
        double var5 = var0.horizontalDistance();
        double var7 = this.getEffectiveGravity();
        double var9 = MathHelper.square(Math.cos(var2));
        var0 = var0.add(0.0, var7 * (-1.0 + var9 * 0.75), 0.0);
        if (var0.y < 0.0 && var3 > 0.0) {
            var11 = var0.y * -0.1 * var9;
            var0 = var0.add(var1.x * var11 / var3, var11, var1.z * var11 / var3);
        }
        if (var2 < 0.0f && var3 > 0.0) {
            var11 = var5 * (double)(-MathHelper.sin(var2)) * 0.04;
            var0 = var0.add(-var1.x * var11 / var3, var11 * 3.2, -var1.z * var11 / var3);
        }
        if (var3 > 0.0) {
            var0 = var0.add((var1.x / var3 * var5 - var0.x) * 0.1, 0.0, (var1.z / var3 * var5 - var0.z) * 0.1);
        }
        return var0.multiply(0.99f, 0.98f, 0.99f);
    }

    private void handleFallFlyingCollisions(double var0, double var2) {
        double var4;
        float var6;
        if (this.horizontalCollision && (var6 = (float)((var4 = var0 - var2) * 10.0 - 3.0)) > 0.0f) {
            this.playSound(this.getFallDamageSound((int)var6), 1.0f, 1.0f);
            this.hurt(this.damageSources().flyIntoWall(), var6);
        }
    }

    private void travelRidden(EntityHuman var0, Vec3D var1) {
        Vec3D var2 = this.getRiddenInput(var0, var1);
        this.tickRidden(var0, var2);
        if (this.isControlledByLocalInstance()) {
            this.setSpeed(this.getRiddenSpeed(var0));
            this.travel(var2);
        } else {
            this.setDeltaMovement(Vec3D.ZERO);
        }
    }

    protected void tickRidden(EntityHuman var0, Vec3D var1) {
    }

    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        return var1;
    }

    protected float getRiddenSpeed(EntityHuman var0) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean var0) {
        float var1 = (float)MathHelper.length(this.getX() - this.xo, var0 ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        if (this.isPassenger() || !this.isAlive()) {
            this.walkAnimation.stop();
        } else {
            this.updateWalkAnimation(var1);
        }
    }

    protected void updateWalkAnimation(float var0) {
        float var1 = Math.min(var0 * 4.0f, 1.0f);
        this.walkAnimation.update(var1, 0.4f, this.isBaby() ? 3.0f : 1.0f);
    }

    private Vec3D handleRelativeFrictionAndCalculateMovement(Vec3D var0, float var1) {
        this.moveRelative(this.getFrictionInfluencedSpeed(var1), var0);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        Vec3D var2 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.getInBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            var2 = new Vec3D(var2.x, 0.2, var2.z);
        }
        return var2;
    }

    public Vec3D getFluidFallingAdjustedMovement(double var0, boolean var2, Vec3D var3) {
        if (var0 != 0.0 && !this.isSprinting()) {
            double var4 = var2 && Math.abs(var3.y - 0.005) >= 0.003 && Math.abs(var3.y - var0 / 16.0) < 0.003 ? -0.003 : var3.y - var0 / 16.0;
            return new Vec3D(var3.x, var4, var3.z);
        }
        return var3;
    }

    private Vec3D handleOnClimbable(Vec3D var0) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float var1 = 0.15f;
            double var2 = MathHelper.clamp(var0.x, (double)-0.15f, (double)0.15f);
            double var4 = MathHelper.clamp(var0.z, (double)-0.15f, (double)0.15f);
            double var6 = Math.max(var0.y, (double)-0.15f);
            if (var6 < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof EntityHuman) {
                var6 = 0.0;
            }
            var0 = new Vec3D(var2, var6, var4);
        }
        return var0;
    }

    private float getFrictionInfluencedSpeed(float var0) {
        if (this.onGround()) {
            return this.getSpeed() * (0.21600002f / (var0 * var0 * var0));
        }
        return this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof EntityHuman ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float var0) {
        this.speed = var0;
    }

    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        this.setLastHurtMob(var1);
        return false;
    }

    @Override
    public void tick() {
        float var9;
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide) {
            int var1;
            int var0 = this.getArrowCount();
            if (var0 > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - var0);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount(var0 - 1);
                }
            }
            if ((var1 = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - var1);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount(var1 - 1);
                }
            }
            this.detectEquipmentUpdates();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (this.isSleeping() && !this.checkBedExists()) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            this.aiStep();
        }
        double var0 = this.getX() - this.xo;
        double var2 = this.getZ() - this.zo;
        float var4 = (float)(var0 * var0 + var2 * var2);
        float var5 = this.yBodyRot;
        float var6 = 0.0f;
        this.oRun = this.run;
        float var7 = 0.0f;
        if (var4 > 0.0025000002f) {
            var7 = 1.0f;
            var6 = (float)Math.sqrt(var4) * 3.0f;
            float var8 = (float)MathHelper.atan2(var2, var0) * 57.295776f - 90.0f;
            var9 = MathHelper.abs(MathHelper.wrapDegrees(this.getYRot()) - var8);
            var5 = 95.0f < var9 && var9 < 265.0f ? var8 - 180.0f : var8;
        }
        if (this.attackAnim > 0.0f) {
            var5 = this.getYRot();
        }
        if (!this.onGround()) {
            var7 = 0.0f;
        }
        this.run += (var7 - this.run) * 0.3f;
        GameProfilerFiller var8 = Profiler.get();
        var8.push("headTurn");
        var6 = this.tickHeadTurn(var5, var6);
        var8.pop();
        var8.push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO < -180.0f) {
            this.yHeadRotO -= 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO >= 180.0f) {
            this.yHeadRotO += 360.0f;
        }
        var8.pop();
        this.animStep += var6;
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        var9 = this.getScale();
        if (var9 != this.appliedScale) {
            this.appliedScale = var9;
            this.refreshDimensions();
        }
        this.elytraAnimationState.tick();
    }

    public void detectEquipmentUpdates() {
        Map<EnumItemSlot, ItemStack> var0 = this.collectEquipmentChanges();
        if (var0 != null) {
            this.handleHandSwap(var0);
            if (!var0.isEmpty()) {
                this.handleEquipmentChanges(var0);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> collectEquipmentChanges() {
        Object var5;
        ItemStack var4;
        Object var3;
        Map var02 = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.VALUES) {
            if (!this.equipmentHasChanged((ItemStack)(var3 = (switch (enumItemSlot.getType()) {
                default -> throw new MatchException(null, null);
                case EnumItemSlot.Function.HAND -> this.getLastHandItem(enumItemSlot);
                case EnumItemSlot.Function.HUMANOID_ARMOR -> this.getLastArmorItem(enumItemSlot);
                case EnumItemSlot.Function.ANIMAL_ARMOR -> this.lastBodyItemStack;
            })), var4 = this.getItemBySlot(enumItemSlot))) continue;
            if (var02 == null) {
                var02 = Maps.newEnumMap(EnumItemSlot.class);
            }
            var02.put(enumItemSlot, var4);
            var5 = this.getAttributes();
            if (((ItemStack)var3).isEmpty()) continue;
            this.stopLocationBasedEffects((ItemStack)var3, enumItemSlot, (AttributeMapBase)var5);
        }
        if (var02 != null) {
            for (Map.Entry entry : var02.entrySet()) {
                var3 = (EnumItemSlot)entry.getKey();
                var4 = (ItemStack)entry.getValue();
                if (var4.isEmpty() || var4.isBroken()) continue;
                var4.forEachModifier((EnumItemSlot)var3, (var0, var1) -> {
                    AttributeModifiable var2 = this.attributes.getInstance((Holder<AttributeBase>)var0);
                    if (var2 != null) {
                        var2.removeModifier(var1.id());
                        var2.addTransientModifier((AttributeModifier)var1);
                    }
                });
                World world = this.level();
                if (!(world instanceof WorldServer)) continue;
                var5 = (WorldServer)world;
                EnchantmentManager.runLocationChangedEffects((WorldServer)var5, var4, this, (EnumItemSlot)var3);
            }
        }
        return var02;
    }

    public boolean equipmentHasChanged(ItemStack var0, ItemStack var1) {
        return !ItemStack.matches(var1, var0);
    }

    private void handleHandSwap(Map<EnumItemSlot, ItemStack> var0) {
        ItemStack var1 = var0.get(EnumItemSlot.MAINHAND);
        ItemStack var2 = var0.get(EnumItemSlot.OFFHAND);
        if (var1 != null && var2 != null && ItemStack.matches(var1, this.getLastHandItem(EnumItemSlot.OFFHAND)) && ItemStack.matches(var2, this.getLastHandItem(EnumItemSlot.MAINHAND))) {
            ((WorldServer)this.level()).getChunkSource().broadcast(this, new PacketPlayOutEntityStatus(this, 55));
            var0.remove(EnumItemSlot.MAINHAND);
            var0.remove(EnumItemSlot.OFFHAND);
            this.setLastHandItem(EnumItemSlot.MAINHAND, var1.copy());
            this.setLastHandItem(EnumItemSlot.OFFHAND, var2.copy());
        }
    }

    private void handleEquipmentChanges(Map<EnumItemSlot, ItemStack> var0) {
        ArrayList var12 = Lists.newArrayListWithCapacity((int)var0.size());
        var0.forEach((var1, var2) -> {
            ItemStack var3 = var2.copy();
            var12.add(Pair.of((Object)var1, (Object)var3));
            switch (var1.getType()) {
                case HAND: {
                    this.setLastHandItem((EnumItemSlot)var1, var3);
                    break;
                }
                case HUMANOID_ARMOR: {
                    this.setLastArmorItem((EnumItemSlot)var1, var3);
                    break;
                }
                case ANIMAL_ARMOR: {
                    this.lastBodyItemStack = var3;
                }
            }
        });
        ((WorldServer)this.level()).getChunkSource().broadcast(this, new PacketPlayOutEntityEquipment(this.getId(), var12));
    }

    private ItemStack getLastArmorItem(EnumItemSlot var0) {
        return this.lastArmorItemStacks.get(var0.getIndex());
    }

    private void setLastArmorItem(EnumItemSlot var0, ItemStack var1) {
        this.lastArmorItemStacks.set(var0.getIndex(), var1);
    }

    private ItemStack getLastHandItem(EnumItemSlot var0) {
        return this.lastHandItemStacks.get(var0.getIndex());
    }

    private void setLastHandItem(EnumItemSlot var0, ItemStack var1) {
        this.lastHandItemStacks.set(var0.getIndex(), var1);
    }

    protected float tickHeadTurn(float var0, float var1) {
        boolean var5;
        float var2 = MathHelper.wrapDegrees(var0 - this.yBodyRot);
        this.yBodyRot += var2 * 0.3f;
        float var3 = MathHelper.wrapDegrees(this.getYRot() - this.yBodyRot);
        float var4 = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs(var3) > var4) {
            this.yBodyRot += var3 - (float)MathHelper.sign(var3) * var4;
        }
        boolean bl = var5 = var3 < -90.0f || var3 >= 90.0f;
        if (var5) {
            var1 *= -1.0f;
        }
        return var1;
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        } else if (!this.isEffectiveAi()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        var0 = this.getDeltaMovement();
        var1 = var0.x;
        var3 = var0.y;
        var5 = var0.z;
        if (Math.abs(var0.x) < 0.003) {
            var1 = 0.0;
        }
        if (Math.abs(var0.y) < 0.003) {
            var3 = 0.0;
        }
        if (Math.abs(var0.z) < 0.003) {
            var5 = 0.0;
        }
        this.setDeltaMovement(var1, var3, var5);
        var7 = Profiler.get();
        var7.push("ai");
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi()) {
            var7.push("newAi");
            this.serverAiStep();
            var7.pop();
        }
        var7.pop();
        var7.push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            var8 = this.isInLava() != false ? this.getFluidHeight(TagsFluid.LAVA) : this.getFluidHeight(TagsFluid.WATER);
            var10 = this.isInWater() != false && var8 > 0.0;
            var11 = this.getFluidJumpThreshold();
            if (var10 && (!this.onGround() || var8 > var11)) {
                this.jumpInLiquid(TagsFluid.WATER);
            } else if (this.isInLava() && (!this.onGround() || var8 > var11)) {
                this.jumpInLiquid(TagsFluid.LAVA);
            } else if ((this.onGround() || var10 && var8 <= var11) && this.noJumpDelay == 0) {
                this.jumpFromGround();
                this.noJumpDelay = 10;
            }
        } else {
            this.noJumpDelay = 0;
        }
        var7.pop();
        var7.push("travel");
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        if (this.isFallFlying()) {
            this.updateFallFlying();
        }
        var8 = this.getBoundingBox();
        var9 = new Vec3D(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        if (!((var12_14 = this.getControllingPassenger()) instanceof EntityHuman)) ** GOTO lbl-1000
        var10 = (EntityHuman)var12_14;
        if (this.isAlive()) {
            this.travelRidden(var10, var9);
        } else lbl-1000:
        // 2 sources

        {
            this.travel(var9);
        }
        if (!this.level().isClientSide() || this.isControlledByLocalInstance()) {
            this.applyEffectsFromBlocks();
        }
        this.calculateEntityAnimation(this instanceof EntityBird);
        var7.pop();
        var7.push("freezing");
        if (!this.level().isClientSide && !this.isDeadOrDying()) {
            var10 = this.getTicksFrozen();
            if (this.isInPowderSnow && this.canFreeze()) {
                this.setTicksFrozen(Math.min(this.getTicksRequiredToFreeze(), var10 + 1));
            } else {
                this.setTicksFrozen(Math.max(0, var10 - 2));
            }
        }
        this.removeFrost();
        this.tryAddFrost();
        var12_14 = this.level();
        if (var12_14 instanceof WorldServer) {
            var10 = (WorldServer)var12_14;
            if (this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
                this.hurtServer(var10, this.damageSources().freeze(), 1.0f);
            }
        }
        var7.pop();
        var7.push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack(var8, this.getBoundingBox());
        }
        this.pushEntities();
        var7.pop();
        var12_14 = this.level();
        if (var12_14 instanceof WorldServer) {
            var10 = (WorldServer)var12_14;
            if (this.isSensitiveToWater() && this.isInWaterRainOrBubble()) {
                this.hurtServer(var10, this.damageSources().drown(), 1.0f);
            }
        }
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    protected void updateFallFlying() {
        this.checkSlowFallDistance();
        if (!this.level().isClientSide) {
            if (!this.canGlide()) {
                this.setSharedFlag(7, false);
                return;
            }
            int var02 = this.fallFlyTicks + 1;
            if (var02 % 10 == 0) {
                int var1 = var02 / 10;
                if (var1 % 2 == 0) {
                    List<EnumItemSlot> var2 = EnumItemSlot.VALUES.stream().filter(var0 -> EntityLiving.canGlideUsing(this.getItemBySlot((EnumItemSlot)var0), var0)).toList();
                    EnumItemSlot var3 = SystemUtils.getRandom(var2, this.random);
                    this.getItemBySlot(var3).hurtAndBreak(1, this, var3);
                }
                this.gameEvent(GameEvent.ELYTRA_GLIDE);
            }
        }
    }

    protected boolean canGlide() {
        if (this.onGround() || this.isPassenger() || this.hasEffect(MobEffects.LEVITATION)) {
            return false;
        }
        for (EnumItemSlot var1 : EnumItemSlot.VALUES) {
            if (!EntityLiving.canGlideUsing(this.getItemBySlot(var1), var1)) continue;
            return true;
        }
        return false;
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            this.level().getEntities(EntityTypeTest.forClass(EntityHuman.class), this.getBoundingBox(), IEntitySelector.pushableBy(this)).forEach(this::doPush);
            return;
        }
        WorldServer var0 = (WorldServer)world;
        List<Entity> var1 = this.level().getEntities(this, this.getBoundingBox(), IEntitySelector.pushableBy(this));
        if (!var1.isEmpty()) {
            int var2 = var0.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            if (var2 > 0 && var1.size() > var2 - 1 && this.random.nextInt(4) == 0) {
                int var3 = 0;
                for (Entity var5 : var1) {
                    if (var5.isPassenger()) continue;
                    ++var3;
                }
                if (var3 > var2 - 1) {
                    this.hurtServer(var0, this.damageSources().cramming(), 6.0f);
                }
            }
            for (Entity var4 : var1) {
                this.doPush(var4);
            }
        }
    }

    protected void checkAutoSpinAttack(AxisAlignedBB var0, AxisAlignedBB var1) {
        AxisAlignedBB var2 = var0.minmax(var1);
        List<Entity> var3 = this.level().getEntities(this, var2);
        if (!var3.isEmpty()) {
            for (Entity var5 : var3) {
                if (!(var5 instanceof EntityLiving)) continue;
                this.doAutoAttackOnTouch((EntityLiving)var5);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
            this.autoSpinAttackDmg = 0.0f;
            this.autoSpinAttackItemStack = null;
        }
    }

    protected void doPush(Entity var0) {
        var0.push(this);
    }

    protected void doAutoAttackOnTouch(EntityLiving var0) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        Entity var0 = this.getVehicle();
        super.stopRiding();
        if (var0 != null && var0 != this.getVehicle() && !this.level().isClientSide) {
            this.dismountVehicle(var0);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.oRun = this.run;
        this.run = 0.0f;
        this.resetFallDistance();
    }

    @Override
    public void cancelLerp() {
        this.lerpSteps = 0;
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8) {
        this.lerpX = var0;
        this.lerpY = var2;
        this.lerpZ = var4;
        this.lerpYRot = var6;
        this.lerpXRot = var7;
        this.lerpSteps = var8;
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpHeadTo(float var0, int var1) {
        this.lerpYHeadRot = var0;
        this.lerpHeadSteps = var1;
    }

    public void setJumping(boolean var0) {
        this.jumping = var0;
    }

    public void onItemPickup(EntityItem var0) {
        Entity var1 = var0.getOwner();
        if (var1 instanceof EntityPlayer) {
            CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((EntityPlayer)var1, var0.getItem(), this);
        }
    }

    public void take(Entity var0, int var1) {
        if (!var0.isRemoved() && !this.level().isClientSide && (var0 instanceof EntityItem || var0 instanceof EntityArrow || var0 instanceof EntityExperienceOrb)) {
            ((WorldServer)this.level()).getChunkSource().broadcast(var0, new PacketPlayOutCollect(var0.getId(), this.getId(), var1));
        }
    }

    public boolean hasLineOfSight(Entity var0) {
        return this.hasLineOfSight(var0, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var0.getEyeY());
    }

    public boolean hasLineOfSight(Entity var0, RayTrace.BlockCollisionOption var1, RayTrace.FluidCollisionOption var2, double var3) {
        if (var0.level() != this.level()) {
            return false;
        }
        Vec3D var5 = new Vec3D(this.getX(), this.getEyeY(), this.getZ());
        Vec3D var6 = new Vec3D(var0.getX(), var3, var0.getZ());
        if (var6.distanceTo(var5) > 128.0) {
            return false;
        }
        return this.level().clip(new RayTrace(var5, var6, var1, var2, this)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    @Override
    public float getViewYRot(float var0) {
        if (var0 == 1.0f) {
            return this.yHeadRot;
        }
        return MathHelper.rotLerp(var0, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float var0) {
        float var1 = this.attackAnim - this.oAttackAnim;
        if (var1 < 0.0f) {
            var1 += 1.0f;
        }
        return this.oAttackAnim + var1 * var0;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float var0) {
        this.yHeadRot = var0;
    }

    @Override
    public void setYBodyRot(float var0) {
        this.yBodyRot = var0;
    }

    @Override
    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(var0, var1));
    }

    public static Vec3D resetForwardDirectionOfRelativePortalPosition(Vec3D var0) {
        return new Vec3D(var0.x, var0.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float var0) {
        this.internalSetAbsorptionAmount(MathHelper.clamp(var0, 0.0f, this.getMaxAbsorption()));
    }

    protected void internalSetAbsorptionAmount(float var0) {
        this.absorptionAmount = var0;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract EnumMainHand getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public EnumHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    protected void updateUsingItem(ItemStack var0) {
        var0.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        if (--this.useItemRemaining == 0 && !this.level().isClientSide && !var0.useOnRelease()) {
            this.completeUsingItem();
        }
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    public void setLivingEntityFlag(int var0, boolean var1) {
        int var2 = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        var2 = var1 ? (var2 |= var0) : (var2 &= ~var0);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)var2);
    }

    public void startUsingItem(EnumHand var0) {
        ItemStack var1 = this.getItemInHand(var0);
        if (var1.isEmpty() || this.isUsingItem()) {
            return;
        }
        this.useItem = var1;
        this.useItemRemaining = var1.getUseDuration(this);
        if (!this.level().isClientSide) {
            this.setLivingEntityFlag(1, true);
            this.setLivingEntityFlag(2, var0 == EnumHand.OFF_HAND);
            this.gameEvent(GameEvent.ITEM_INTERACT_START);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (SLEEPING_POS_ID.equals(var0)) {
            if (this.level().isClientSide) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(var0) && this.level().isClientSide) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration(this);
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.useItemRemaining = 0;
            }
        }
    }

    @Override
    public void lookAt(ArgumentAnchor.Anchor var0, Vec3D var1) {
        super.lookAt(var0, var1);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    @Override
    public float getPreciseBodyRotation(float var0) {
        return MathHelper.lerp(var0, this.yBodyRotO, this.yBodyRot);
    }

    public void spawnItemParticles(ItemStack var0, int var1) {
        for (int var2 = 0; var2 < var1; ++var2) {
            Vec3D var3 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            var3 = var3.xRot(-this.getXRot() * ((float)Math.PI / 180));
            var3 = var3.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double var4 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3D var6 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.3, var4, 0.6);
            var6 = var6.xRot(-this.getXRot() * ((float)Math.PI / 180));
            var6 = var6.yRot(-this.getYRot() * ((float)Math.PI / 180));
            var6 = var6.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ParticleParamItem(Particles.ITEM, var0), var6.x, var6.y, var6.z, var3.x, var3.y + 0.05, var3.z);
        }
    }

    protected void completeUsingItem() {
        if (this.level().isClientSide && !this.isUsingItem()) {
            return;
        }
        EnumHand var0 = this.getUsedItemHand();
        if (!this.useItem.equals(this.getItemInHand(var0))) {
            this.releaseUsingItem();
            return;
        }
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            ItemStack var1 = this.useItem.finishUsingItem(this.level(), this);
            if (var1 != this.useItem) {
                this.setItemInHand(var0, var1);
            }
            this.stopUsingItem();
        }
    }

    public void handleExtraItemsCreatedOnUse(ItemStack var0) {
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        if (this.isUsingItem()) {
            return this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks();
        }
        return 0;
    }

    public void releaseUsingItem() {
        if (!this.useItem.isEmpty()) {
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide) {
            boolean var0 = this.isUsingItem();
            this.setLivingEntityFlag(1, false);
            if (var0) {
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.useItemRemaining = 0;
    }

    public boolean isBlocking() {
        return this.getItemBlockingWith() != null;
    }

    @Nullable
    public ItemStack getItemBlockingWith() {
        if (!this.isUsingItem() || this.useItem.isEmpty()) {
            return null;
        }
        Item var0 = this.useItem.getItem();
        if (var0.getUseAnimation(this.useItem) != ItemUseAnimation.BLOCK) {
            return null;
        }
        if (var0.getUseDuration(this.useItem, this) - this.useItemRemaining < 5) {
            return null;
        }
        return this.useItem;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(EntityPose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double var0, double var2, double var4, boolean var6) {
        EntityLiving entityLiving;
        double var7 = this.getX();
        double var9 = this.getY();
        double var11 = this.getZ();
        double var13 = var2;
        boolean var15 = false;
        BlockPosition var16 = BlockPosition.containing(var0, var13, var4);
        World var17 = this.level();
        if (var17.hasChunkAt(var16)) {
            boolean var18 = false;
            while (!var18 && var16.getY() > var17.getMinY()) {
                BlockPosition var19 = var16.below();
                IBlockData var20 = var17.getBlockState(var19);
                if (var20.blocksMotion()) {
                    var18 = true;
                    continue;
                }
                var13 -= 1.0;
                var16 = var19;
            }
            if (var18) {
                this.teleportTo(var0, var13, var4);
                if (var17.noCollision(this) && !var17.containsAnyLiquid(this.getBoundingBox())) {
                    var15 = true;
                }
            }
        }
        if (!var15) {
            this.teleportTo(var7, var9, var11);
            return false;
        }
        if (var6) {
            var17.broadcastEntityEvent(this, (byte)46);
        }
        if ((entityLiving = this) instanceof EntityCreature) {
            EntityCreature var18 = (EntityCreature)entityLiving;
            var18.getNavigation().stop();
        }
        return true;
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPosition var0, boolean var1) {
    }

    public boolean canPickUpLoot() {
        return false;
    }

    @Override
    public final EntitySize getDimensions(EntityPose var0) {
        return var0 == EntityPose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(var0).scale(this.getScale());
    }

    protected EntitySize getDefaultDimensions(EntityPose var0) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<EntityPose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)EntityPose.STANDING));
    }

    public AxisAlignedBB getLocalBoundsForPose(EntityPose var0) {
        EntitySize var1 = this.getDimensions(var0);
        return new AxisAlignedBB(-var1.width() / 2.0f, 0.0, -var1.width() / 2.0f, var1.width() / 2.0f, var1.height(), var1.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(EntityPose var0) {
        AxisAlignedBB var1 = this.getDimensions(var0).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, var1);
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return super.canUsePortal(var0) && !this.isSleeping();
    }

    public Optional<BlockPosition> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPosition var0) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(var0));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPosition var0) {
        IBlockData var1;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((var1 = this.level().getBlockState(var0)).getBlock() instanceof BlockBed) {
            this.level().setBlock(var0, (IBlockData)var1.setValue(BlockBed.OCCUPIED, true), 3);
        }
        this.setPose(EntityPose.SLEEPING);
        this.setPosToBed(var0);
        this.setSleepingPos(var0);
        this.setDeltaMovement(Vec3D.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPosition var0) {
        this.setPos((double)var0.getX() + 0.5, (double)var0.getY() + 0.6875, (double)var0.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(var0 -> this.level().getBlockState((BlockPosition)var0).getBlock() instanceof BlockBed).orElse(false);
    }

    public void stopSleeping() {
        this.getSleepingPos().filter(this.level()::hasChunkAt).ifPresent(var0 -> {
            IBlockData var1 = this.level().getBlockState((BlockPosition)var0);
            if (var1.getBlock() instanceof BlockBed) {
                EnumDirection var2 = (EnumDirection)var1.getValue(BlockBed.FACING);
                this.level().setBlock((BlockPosition)var0, (IBlockData)var1.setValue(BlockBed.OCCUPIED, false), 3);
                Vec3D var3 = BlockBed.findStandUpPosition(this.getType(), this.level(), var0, var2, this.getYRot()).orElseGet(() -> {
                    BlockPosition var1 = var0.above();
                    return new Vec3D((double)var1.getX() + 0.5, (double)var1.getY() + 0.1, (double)var1.getZ() + 0.5);
                });
                Vec3D var4 = Vec3D.atBottomCenterOf(var0).subtract(var3).normalize();
                float var5 = (float)MathHelper.wrapDegrees(MathHelper.atan2(var4.z, var4.x) * 57.2957763671875 - 90.0);
                this.setPos(var3.x, var3.y, var3.z);
                this.setYRot(var5);
                this.setXRot(0.0f);
            }
        });
        Vec3D var02 = this.position();
        this.setPose(EntityPose.STANDING);
        this.setPos(var02.x, var02.y, var02.z);
        this.clearSleepingPos();
    }

    @Nullable
    public EnumDirection getBedOrientation() {
        BlockPosition var0 = this.getSleepingPos().orElse(null);
        return var0 != null ? BlockBed.getBedOrientation(this.level(), var0) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack var0) {
        return ItemStack.EMPTY;
    }

    private static byte entityEventForEquipmentBreak(EnumItemSlot var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.MAINHAND -> 47;
            case EnumItemSlot.OFFHAND -> 48;
            case EnumItemSlot.HEAD -> 49;
            case EnumItemSlot.CHEST -> 50;
            case EnumItemSlot.FEET -> 52;
            case EnumItemSlot.LEGS -> 51;
            case EnumItemSlot.BODY -> 65;
        };
    }

    public void onEquippedItemBroken(Item var0, EnumItemSlot var1) {
        this.level().broadcastEntityEvent(this, EntityLiving.entityEventForEquipmentBreak(var1));
        this.stopLocationBasedEffects(this.getItemBySlot(var1), var1, this.attributes);
    }

    private void stopLocationBasedEffects(ItemStack var0, EnumItemSlot var12, AttributeMapBase var22) {
        var0.forEachModifier(var12, (var1, var2) -> {
            AttributeModifiable var3 = var22.getInstance((Holder<AttributeBase>)var1);
            if (var3 != null) {
                var3.removeModifier((AttributeModifier)var2);
            }
        });
        EnchantmentManager.stopLocationBasedEffects(var0, this, var12);
    }

    public static EnumItemSlot getSlotForHand(EnumHand var0) {
        return var0 == EnumHand.MAIN_HAND ? EnumItemSlot.MAINHAND : EnumItemSlot.OFFHAND;
    }

    public final boolean canEquipWithDispenser(ItemStack var0) {
        if (!this.isAlive() || this.isSpectator()) {
            return false;
        }
        Equippable var1 = var0.get(DataComponents.EQUIPPABLE);
        if (var1 == null || !var1.dispensable()) {
            return false;
        }
        EnumItemSlot var2 = var1.slot();
        if (!this.canUseSlot(var2) || !var1.canBeEquippedBy(this.getType())) {
            return false;
        }
        return this.getItemBySlot(var2).isEmpty() && this.canDispenserEquipIntoSlot(var2);
    }

    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return true;
    }

    public final EnumItemSlot getEquipmentSlotForItem(ItemStack var0) {
        Equippable var1 = var0.get(DataComponents.EQUIPPABLE);
        if (var1 != null && this.canUseSlot(var1.slot())) {
            return var1.slot();
        }
        return EnumItemSlot.MAINHAND;
    }

    public final boolean isEquippableInSlot(ItemStack var0, EnumItemSlot var1) {
        Equippable var2 = var0.get(DataComponents.EQUIPPABLE);
        if (var2 == null) {
            return var1 == EnumItemSlot.MAINHAND && this.canUseSlot(EnumItemSlot.MAINHAND);
        }
        return var1 == var2.slot() && this.canUseSlot(var2.slot()) && var2.canBeEquippedBy(this.getType());
    }

    private static SlotAccess createEquipmentSlotAccess(EntityLiving var0, EnumItemSlot var1) {
        if (var1 == EnumItemSlot.HEAD || var1 == EnumItemSlot.MAINHAND || var1 == EnumItemSlot.OFFHAND) {
            return SlotAccess.forEquipmentSlot(var0, var1);
        }
        return SlotAccess.forEquipmentSlot(var0, var1, var2 -> var2.isEmpty() || var0.getEquipmentSlotForItem((ItemStack)var2) == var1);
    }

    @Nullable
    private static EnumItemSlot getEquipmentSlot(int var0) {
        if (var0 == 100 + EnumItemSlot.HEAD.getIndex()) {
            return EnumItemSlot.HEAD;
        }
        if (var0 == 100 + EnumItemSlot.CHEST.getIndex()) {
            return EnumItemSlot.CHEST;
        }
        if (var0 == 100 + EnumItemSlot.LEGS.getIndex()) {
            return EnumItemSlot.LEGS;
        }
        if (var0 == 100 + EnumItemSlot.FEET.getIndex()) {
            return EnumItemSlot.FEET;
        }
        if (var0 == 98) {
            return EnumItemSlot.MAINHAND;
        }
        if (var0 == 99) {
            return EnumItemSlot.OFFHAND;
        }
        if (var0 == 105) {
            return EnumItemSlot.BODY;
        }
        return null;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        EnumItemSlot var1 = EntityLiving.getEquipmentSlot(var0);
        if (var1 != null) {
            return EntityLiving.createEquipmentSlotAccess(this, var1);
        }
        return super.getSlot(var0);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        boolean var0 = !this.getItemBySlot(EnumItemSlot.HEAD).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.CHEST).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.LEGS).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.FEET).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.BODY).is(TagsItem.FREEZE_IMMUNE_WEARABLES);
        return var0 && super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        double var1 = var0.getX();
        double var3 = var0.getY();
        double var5 = var0.getZ();
        float var7 = var0.getYRot();
        float var8 = var0.getXRot();
        this.syncPacketPositionCodec(var1, var3, var5);
        this.yBodyRot = var0.getYHeadRot();
        this.yHeadRot = var0.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(var0.getId());
        this.setUUID(var0.getUUID());
        this.absMoveTo(var1, var3, var5, var7, var8);
        this.setDeltaMovement(var0.getXa(), var0.getYa(), var0.getZa());
    }

    public boolean canDisableShield() {
        return this.getWeaponItem().getItem() instanceof ItemAxe;
    }

    @Override
    public float maxUpStep() {
        float var0 = (float)this.getAttributeValue(GenericAttributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof EntityHuman ? Math.max(var0, 1.0f) : var0;
    }

    @Override
    public Vec3D getPassengerRidingPosition(Entity var0) {
        return this.position().add(this.getPassengerAttachmentPoint(var0, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int var0, double var1) {
        this.yHeadRot = (float)MathHelper.rotLerp(1.0 / (double)var0, (double)this.yHeadRot, var1);
    }

    @Override
    public void igniteForTicks(int var0) {
        super.igniteForTicks(MathHelper.ceil((double)var0 * this.getAttributeValue(GenericAttributes.BURNING_TIME)));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    public boolean isInvulnerableTo(WorldServer var0, DamageSource var1) {
        return this.isInvulnerableToBase(var1) || EnchantmentManager.isImmuneToDamage(var0, this, var1);
    }

    public static boolean canGlideUsing(ItemStack var0, EnumItemSlot var1) {
        if (!var0.has(DataComponents.GLIDER)) {
            return false;
        }
        Equippable var2 = var0.get(DataComponents.EQUIPPABLE);
        return var2 != null && var1 == var2.slot() && !var0.nextDamageWillBreak();
    }

    @VisibleForTesting
    public int getLastHurtByPlayerTime() {
        return this.lastHurtByPlayerTime;
    }

    public record a(SoundEffect small, SoundEffect big) {
    }
}

