/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityExperienceOrb
extends Entity {
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private int age;
    private int health = 5;
    public int value;
    private int count = 1;
    private EntityHuman followingPlayer;

    public EntityExperienceOrb(World var0, double var1, double var3, double var5, int var7) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.EXPERIENCE_ORB, var0);
        this.setPos(var1, var3, var5);
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.value = var7;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        Vec3D var0;
        double var1;
        super.tick();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.isEyeInFluid(TagsFluid.WATER)) {
            this.setUnderwaterMovement();
        } else {
            this.applyGravity();
        }
        if (this.level().getFluidState(this.blockPosition()).is(TagsFluid.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.tickCount % 20 == 1) {
            this.scanForEntities();
        }
        if (this.followingPlayer != null && (this.followingPlayer.isSpectator() || this.followingPlayer.isDeadOrDying())) {
            this.followingPlayer = null;
        }
        if (this.followingPlayer != null && (var1 = (var0 = new Vec3D(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ())).lengthSqr()) < 64.0) {
            double var3 = 1.0 - Math.sqrt(var1) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(var0.normalize().scale(var3 * var3 * 0.1)));
        }
        double var02 = this.getDeltaMovement().y;
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        float var2 = 0.98f;
        if (this.onGround()) {
            var2 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(var2, 0.98, var2));
        if (this.onGround()) {
            this.setDeltaMovement(new Vec3D(this.getDeltaMovement().x, -var02 * 0.4, this.getDeltaMovement().z));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    @Override
    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForEntities() {
        if (this.followingPlayer == null || this.followingPlayer.distanceToSqr(this) > 64.0) {
            this.followingPlayer = this.level().getNearestPlayer(this, 8.0);
        }
        if (this.level() instanceof WorldServer) {
            List<EntityExperienceOrb> var0 = this.level().getEntities(EntityTypeTest.forClass(EntityExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge);
            for (EntityExperienceOrb var2 : var0) {
                this.merge(var2);
            }
        }
    }

    public static void award(WorldServer var0, Vec3D var1, int var2) {
        while (var2 > 0) {
            int var3 = EntityExperienceOrb.getExperienceValue(var2);
            var2 -= var3;
            if (EntityExperienceOrb.tryMergeToExisting(var0, var1, var3)) continue;
            var0.addFreshEntity(new EntityExperienceOrb(var0, var1.x(), var1.y(), var1.z(), var3));
        }
    }

    private static boolean tryMergeToExisting(WorldServer var0, Vec3D var1, int var22) {
        AxisAlignedBB var3 = AxisAlignedBB.ofSize(var1, 1.0, 1.0, 1.0);
        int var4 = var0.getRandom().nextInt(40);
        List<EntityExperienceOrb> var5 = var0.getEntities(EntityTypeTest.forClass(EntityExperienceOrb.class), var3, var2 -> EntityExperienceOrb.canMerge(var2, var4, var22));
        if (!var5.isEmpty()) {
            EntityExperienceOrb var6 = var5.get(0);
            ++var6.count;
            var6.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(EntityExperienceOrb var0) {
        return var0 != this && EntityExperienceOrb.canMerge(var0, this.getId(), this.value);
    }

    private static boolean canMerge(EntityExperienceOrb var0, int var1, int var2) {
        return !var0.isRemoved() && (var0.getId() - var1) % 40 == 0 && var0.value == var2;
    }

    private void merge(EntityExperienceOrb var0) {
        this.count += var0.count;
        this.age = Math.min(this.age, var0.age);
        var0.discard();
    }

    private void setUnderwaterMovement() {
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.x * (double)0.99f, Math.min(var0.y + (double)5.0E-4f, (double)0.06f), var0.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public final boolean hurtClient(DamageSource var0) {
        return !this.isInvulnerableToBase(var0);
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableToBase(var1)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - var2);
        if (this.health <= 0) {
            this.discard();
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putShort("Health", (short)this.health);
        var0.putShort("Age", (short)this.age);
        var0.putShort("Value", (short)this.value);
        var0.putInt("Count", this.count);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.health = var0.getShort("Health");
        this.age = var0.getShort("Age");
        this.value = var0.getShort("Value");
        this.count = Math.max(var0.getInt("Count"), 1);
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (!(var0 instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer var1 = (EntityPlayer)var0;
        if (var0.takeXpDelay == 0) {
            var0.takeXpDelay = 2;
            var0.take(this, 1);
            int var2 = this.repairPlayerItems(var1, this.value);
            if (var2 > 0) {
                var0.giveExperiencePoints(var2);
            }
            --this.count;
            if (this.count == 0) {
                this.discard();
            }
        }
    }

    private int repairPlayerItems(EntityPlayer var0, int var1) {
        Optional<EnchantedItemInUse> var2 = EnchantmentManager.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, var0, ItemStack::isDamaged);
        if (var2.isPresent()) {
            int var6;
            ItemStack var3 = var2.get().itemStack();
            int var4 = EnchantmentManager.modifyDurabilityToRepairFromXp(var0.serverLevel(), var3, var1);
            int var5 = Math.min(var4, var3.getDamageValue());
            var3.setDamageValue(var3.getDamageValue() - var5);
            if (var5 > 0 && (var6 = var1 - var5 * var1 / var4) > 0) {
                return this.repairPlayerItems(var0, var6);
            }
            return 0;
        }
        return var1;
    }

    public int getValue() {
        return this.value;
    }

    public int getIcon() {
        if (this.value >= 2477) {
            return 10;
        }
        if (this.value >= 1237) {
            return 9;
        }
        if (this.value >= 617) {
            return 8;
        }
        if (this.value >= 307) {
            return 7;
        }
        if (this.value >= 149) {
            return 6;
        }
        if (this.value >= 73) {
            return 5;
        }
        if (this.value >= 37) {
            return 4;
        }
        if (this.value >= 17) {
            return 3;
        }
        if (this.value >= 7) {
            return 2;
        }
        if (this.value >= 3) {
            return 1;
        }
        return 0;
    }

    public static int getExperienceValue(int var0) {
        if (var0 >= 2477) {
            return 2477;
        }
        if (var0 >= 1237) {
            return 1237;
        }
        if (var0 >= 617) {
            return 617;
        }
        if (var0 >= 307) {
            return 307;
        }
        if (var0 >= 149) {
            return 149;
        }
        if (var0 >= 73) {
            return 73;
        }
        if (var0 >= 37) {
            return 37;
        }
        if (var0 >= 17) {
            return 17;
        }
        if (var0 >= 7) {
            return 7;
        }
        if (var0 >= 3) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        return new PacketPlayOutSpawnEntityExperienceOrb(this, var0);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.AMBIENT;
    }
}

