/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;

public class CombatMath {
    public static final float MAX_ARMOR = 20.0f;
    public static final float ARMOR_PROTECTION_DIVIDER = 25.0f;
    public static final float BASE_ARMOR_TOUGHNESS = 2.0f;
    public static final float MIN_ARMOR_RATIO = 0.2f;
    private static final int NUM_ARMOR_ITEMS = 4;

    public static float getDamageAfterAbsorb(EntityLiving var0, float var1, DamageSource var2, float var3, float var4) {
        float var8;
        World world;
        float var5 = 2.0f + var4 / 4.0f;
        float var6 = MathHelper.clamp(var3 - var1 / var5, var3 * 0.2f, 20.0f);
        float var7 = var6 / 25.0f;
        ItemStack var9 = var2.getWeaponItem();
        if (var9 != null && (world = var0.level()) instanceof WorldServer) {
            WorldServer var10 = (WorldServer)world;
            var8 = MathHelper.clamp(EnchantmentManager.modifyArmorEffectiveness(var10, var9, var0, var2, var7), 0.0f, 1.0f);
        } else {
            var8 = var7;
        }
        float var10 = 1.0f - var8;
        return var1 * var10;
    }

    public static float getDamageAfterMagicAbsorb(float var0, float var1) {
        float var2 = MathHelper.clamp(var1, 0.0f, 20.0f);
        return var0 * (1.0f - var2 / 25.0f);
    }
}

