/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public interface RandomizableContainer
extends IInventory {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    @Nullable
    public ResourceKey<LootTable> getLootTable();

    public void setLootTable(@Nullable ResourceKey<LootTable> var1);

    default public void setLootTable(ResourceKey<LootTable> var0, long var1) {
        this.setLootTable(var0);
        this.setLootTableSeed(var1);
    }

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPosition getBlockPos();

    @Nullable
    public World getLevel();

    public static void setBlockEntityLootTable(IBlockAccess var0, RandomSource var1, BlockPosition var2, ResourceKey<LootTable> var3) {
        TileEntity var4 = var0.getBlockEntity(var2);
        if (var4 instanceof RandomizableContainer) {
            RandomizableContainer var5 = (RandomizableContainer)((Object)var4);
            var5.setLootTable(var3, var1.nextLong());
        }
    }

    default public boolean tryLoadLootTable(NBTTagCompound var0) {
        if (var0.contains(LOOT_TABLE_TAG, 8)) {
            this.setLootTable(ResourceKey.create(Registries.LOOT_TABLE, MinecraftKey.parse(var0.getString(LOOT_TABLE_TAG))));
            if (var0.contains(LOOT_TABLE_SEED_TAG, 4)) {
                this.setLootTableSeed(var0.getLong(LOOT_TABLE_SEED_TAG));
            } else {
                this.setLootTableSeed(0L);
            }
            return true;
        }
        return false;
    }

    default public boolean trySaveLootTable(NBTTagCompound var0) {
        ResourceKey<LootTable> var1 = this.getLootTable();
        if (var1 == null) {
            return false;
        }
        var0.putString(LOOT_TABLE_TAG, var1.location().toString());
        long var2 = this.getLootTableSeed();
        if (var2 != 0L) {
            var0.putLong(LOOT_TABLE_SEED_TAG, var2);
        }
        return true;
    }

    default public void unpackLootTable(@Nullable EntityHuman var0) {
        World var1 = this.getLevel();
        BlockPosition var2 = this.getBlockPos();
        ResourceKey<LootTable> var3 = this.getLootTable();
        if (var3 != null && var1 != null && var1.getServer() != null) {
            LootTable var4 = var1.getServer().reloadableRegistries().getLootTable(var3);
            if (var0 instanceof EntityPlayer) {
                CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var0, var3);
            }
            this.setLootTable(null);
            LootParams.a var5 = new LootParams.a((WorldServer)var1).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var2));
            if (var0 != null) {
                var5.withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0);
            }
            var4.fill(this, var5.create(LootContextParameterSets.CHEST), this.getLootTableSeed());
        }
    }
}

