/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;

public class InventoryUtils {
    public static void dropContents(World var0, BlockPosition var1, IInventory var2) {
        InventoryUtils.dropContents(var0, var1.getX(), var1.getY(), var1.getZ(), var2);
    }

    public static void dropContents(World var0, Entity var1, IInventory var2) {
        InventoryUtils.dropContents(var0, var1.getX(), var1.getY(), var1.getZ(), var2);
    }

    private static void dropContents(World var0, double var1, double var3, double var5, IInventory var7) {
        for (int var8 = 0; var8 < var7.getContainerSize(); ++var8) {
            InventoryUtils.dropItemStack(var0, var1, var3, var5, var7.getItem(var8));
        }
    }

    public static void dropContents(World var0, BlockPosition var1, NonNullList<ItemStack> var22) {
        var22.forEach(var2 -> InventoryUtils.dropItemStack(var0, var1.getX(), var1.getY(), var1.getZ(), var2));
    }

    public static void dropItemStack(World var0, double var1, double var3, double var5, ItemStack var7) {
        double var8 = EntityTypes.ITEM.getWidth();
        double var10 = 1.0 - var8;
        double var12 = var8 / 2.0;
        double var14 = Math.floor(var1) + var0.random.nextDouble() * var10 + var12;
        double var16 = Math.floor(var3) + var0.random.nextDouble() * var10;
        double var18 = Math.floor(var5) + var0.random.nextDouble() * var10 + var12;
        while (!var7.isEmpty()) {
            EntityItem var20 = new EntityItem(var0, var14, var16, var18, var7.split(var0.random.nextInt(21) + 10));
            float var21 = 0.05f;
            var20.setDeltaMovement(var0.random.triangle(0.0, 0.11485000171139836), var0.random.triangle(0.2, 0.11485000171139836), var0.random.triangle(0.0, 0.11485000171139836));
            var0.addFreshEntity(var20);
        }
    }

    public static void dropContentsOnDestroy(IBlockData var0, IBlockData var1, World var2, BlockPosition var3) {
        if (var0.is(var1.getBlock())) {
            return;
        }
        TileEntity var4 = var2.getBlockEntity(var3);
        if (var4 instanceof IInventory) {
            IInventory var5 = (IInventory)((Object)var4);
            InventoryUtils.dropContents(var2, var3, var5);
            var2.updateNeighbourForOutputSignal(var3, var0.getBlock());
        }
    }
}

