/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventorySubcontainer
implements IInventory,
AutoRecipeOutput {
    private final int size;
    public final NonNullList<ItemStack> items;
    @Nullable
    private List<IInventoryListener> listeners;

    public InventorySubcontainer(int var0) {
        this.size = var0;
        this.items = NonNullList.withSize(var0, ItemStack.EMPTY);
    }

    public InventorySubcontainer(ItemStack ... var0) {
        this.size = var0.length;
        this.items = NonNullList.of(ItemStack.EMPTY, var0);
    }

    public void addListener(IInventoryListener var0) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(var0);
    }

    public void removeListener(IInventoryListener var0) {
        if (this.listeners != null) {
            this.listeners.remove(var0);
        }
    }

    @Override
    public ItemStack getItem(int var0) {
        if (var0 < 0 || var0 >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        return this.items.get(var0);
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> var02 = this.items.stream().filter(var0 -> !var0.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return var02;
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var2 = ContainerUtil.removeItem(this.items, var0, var1);
        if (!var2.isEmpty()) {
            this.setChanged();
        }
        return var2;
    }

    public ItemStack removeItemType(Item var0, int var1) {
        ItemStack var2 = new ItemStack(var0, 0);
        for (int var3 = this.size - 1; var3 >= 0; --var3) {
            ItemStack var4 = this.getItem(var3);
            if (!var4.getItem().equals(var0)) continue;
            int var5 = var1 - var2.getCount();
            ItemStack var6 = var4.split(var5);
            var2.grow(var6.getCount());
            if (var2.getCount() == var1) break;
        }
        if (!var2.isEmpty()) {
            this.setChanged();
        }
        return var2;
    }

    public ItemStack addItem(ItemStack var0) {
        if (var0.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack var1 = var0.copy();
        this.moveItemToOccupiedSlotsWithSameType(var1);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.moveItemToEmptySlots(var1);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return var1;
    }

    public boolean canAddItem(ItemStack var0) {
        boolean var1 = false;
        for (ItemStack var3 : this.items) {
            if (!var3.isEmpty() && (!ItemStack.isSameItemSameComponents(var3, var0) || var3.getCount() >= var3.getMaxStackSize())) continue;
            var1 = true;
            break;
        }
        return var1;
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        ItemStack var1 = this.items.get(var0);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(var0, ItemStack.EMPTY);
        return var1;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.items.set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
        this.setChanged();
    }

    @Override
    public int getContainerSize() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.items) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setChanged() {
        if (this.listeners != null) {
            for (IInventoryListener var1 : this.listeners) {
                var1.containerChanged(this);
            }
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    @Override
    public void fillStackedContents(StackedItemContents var0) {
        for (ItemStack var2 : this.items) {
            var0.accountStack(var2);
        }
    }

    public String toString() {
        return this.items.stream().filter(var0 -> !var0.isEmpty()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            ItemStack var2 = this.getItem(var1);
            if (!var2.isEmpty()) continue;
            this.setItem(var1, var0.copyAndClear());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            ItemStack var2 = this.getItem(var1);
            if (!ItemStack.isSameItemSameComponents(var2, var0)) continue;
            this.moveItemsBetweenStacks(var0, var2);
            if (!var0.isEmpty()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack var0, ItemStack var1) {
        int var2 = this.getMaxStackSize(var1);
        int var3 = Math.min(var0.getCount(), var2 - var1.getCount());
        if (var3 > 0) {
            var1.grow(var3);
            var0.shrink(var3);
            this.setChanged();
        }
    }

    public void fromTag(NBTTagList var0, HolderLookup.a var1) {
        this.clearContent();
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            ItemStack.parse(var1, var0.getCompound(var2)).ifPresent(this::addItem);
        }
    }

    public NBTTagList createTag(HolderLookup.a var0) {
        NBTTagList var1 = new NBTTagList();
        for (int var2 = 0; var2 < this.getContainerSize(); ++var2) {
            ItemStack var3 = this.getItem(var2);
            if (var3.isEmpty()) continue;
            var1.add(var3.save(var0));
        }
        return var1;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

