/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class WeightedListInt
extends IntProvider {
    public static final MapCodec<WeightedListInt> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)SimpleWeightedRandomList.wrappedCodec(IntProvider.CODEC).fieldOf("distribution").forGetter(var0 -> var0.distribution)).apply((Applicative)var02, WeightedListInt::new));
    private final SimpleWeightedRandomList<IntProvider> distribution;
    private final int minValue;
    private final int maxValue;

    public WeightedListInt(SimpleWeightedRandomList<IntProvider> var0) {
        this.distribution = var0;
        List var1 = var0.unwrap();
        int var2 = Integer.MAX_VALUE;
        int var3 = Integer.MIN_VALUE;
        for (WeightedEntry.b var5 : var1) {
            int var6 = ((IntProvider)var5.data()).getMinValue();
            int var7 = ((IntProvider)var5.data()).getMaxValue();
            var2 = Math.min(var2, var6);
            var3 = Math.max(var3, var7);
        }
        this.minValue = var2;
        this.maxValue = var3;
    }

    @Override
    public int sample(RandomSource var0) {
        return this.distribution.getRandomValue(var0).orElseThrow(IllegalStateException::new).sample(var0);
    }

    @Override
    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.WEIGHTED_LIST;
    }
}

