/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class OminousBannerRarityFix
extends DataFix {
    public OminousBannerRarityFix(Schema var0) {
        super(var0, false);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.BLOCK_ENTITY);
        Type var1 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        TaggedChoice.TaggedChoiceType var22 = this.getInputSchema().findChoiceType(DataConverterTypes.BLOCK_ENTITY);
        OpticFinder var3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.ITEM_NAME.typeName(), DataConverterSchemaNamed.namespacedString()));
        OpticFinder var4 = var0.findField("components");
        OpticFinder var5 = var1.findField("components");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner block entity common rarity to uncommon rarity fix", var0, var2 -> {
            Object var3 = ((Pair)var2.get(var22.finder())).getFirst();
            return var3.equals("minecraft:banner") ? this.fix((Typed<?>)var2, (OpticFinder<?>)var4) : var2;
        }), (TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner item stack common rarity to uncommon rarity fix", var1, var2 -> {
            String var3 = var2.getOptional(var3).map(Pair::getSecond).orElse("");
            return var3.equals("minecraft:white_banner") ? this.fix((Typed<?>)var2, (OpticFinder<?>)var5) : var2;
        }));
    }

    private Typed<?> fix(Typed<?> var02, OpticFinder<?> var1) {
        return var02.updateTyped(var1, var0 -> var0.update(DSL.remainderFinder(), var02 -> {
            boolean var1 = var02.get("minecraft:item_name").asString().result().flatMap(ComponentDataFixUtils::extractTranslationString).filter(var0 -> var0.equals("block.minecraft.ominous_banner")).isPresent();
            if (var1) {
                return var02.set("minecraft:rarity", var02.createString("uncommon")).set("minecraft:item_name", ComponentDataFixUtils.createTranslatableComponent(var02.getOps(), "block.minecraft.ominous_banner"));
            }
            return var02;
        }));
    }
}

