/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;

public class ExtraDataFixUtils {
    public static Dynamic<?> fixBlockPos(Dynamic<?> var0) {
        Optional var1 = var0.get("X").asNumber().result();
        Optional var2 = var0.get("Y").asNumber().result();
        Optional var3 = var0.get("Z").asNumber().result();
        if (var1.isEmpty() || var2.isEmpty() || var3.isEmpty()) {
            return var0;
        }
        return var0.createIntList(IntStream.of(((Number)var1.get()).intValue(), ((Number)var2.get()).intValue(), ((Number)var3.get()).intValue()));
    }

    public static <T, R> Typed<R> cast(Type<R> var0, Typed<T> var1) {
        return new Typed(var0, var1.getOps(), var1.getValue());
    }

    public static Type<?> patchSubType(Type<?> var0, Type<?> var1, Type<?> var2) {
        return var0.all(ExtraDataFixUtils.typePatcher(var1, var2), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> var0, Type<B> var1) {
        RewriteResult var2 = RewriteResult.create((View)View.create((String)"Patcher", var0, var1, var02 -> var0 -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(var0, (RewriteResult)var2), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> chainAllFilters(Function<Typed<?>, Typed<?>> ... var0) {
        return var1 -> {
            for (Function var5 : var0) {
                var1 = (Typed)var5.apply(var1);
            }
            return var1;
        };
    }

    public static Dynamic<?> blockState(String var0, Map<String, String> var12) {
        Dynamic var2 = new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)new NBTTagCompound());
        Dynamic var3 = var2.set("Name", var2.createString(var0));
        if (!var12.isEmpty()) {
            var3 = var3.set("Properties", var2.createMap(var12.entrySet().stream().collect(Collectors.toMap(var1 -> var2.createString((String)var1.getKey()), var1 -> var2.createString((String)var1.getValue())))));
        }
        return var3;
    }

    public static Dynamic<?> blockState(String var0) {
        return ExtraDataFixUtils.blockState(var0, Map.of());
    }

    public static Dynamic<?> fixStringField(Dynamic<?> var0, String var1, UnaryOperator<String> var22) {
        return var0.update(var1, var2 -> (Dynamic)DataFixUtils.orElse((Optional)var2.asString().map((Function)var22).map(arg_0 -> ((Dynamic)var0).createString(arg_0)).result(), (Object)var2));
    }
}

