/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<PacketDataSerializer, RecipeBookSettings> STREAM_CODEC = StreamCodec.ofMember(RecipeBookSettings::write, RecipeBookSettings::read);
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, a> states;

    private RecipeBookSettings(Map<RecipeBookType, a> var0) {
        this.states = var0;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, a>(RecipeBookType.class));
    }

    private a getSettings(RecipeBookType var0) {
        return this.states.getOrDefault((Object)var0, a.DEFAULT);
    }

    private void updateSettings(RecipeBookType var0, UnaryOperator<a> var12) {
        this.states.compute(var0, (var1, var2) -> {
            if (var2 == null) {
                var2 = a.DEFAULT;
            }
            if ((var2 = (a)var12.apply((a)var2)).equals(a.DEFAULT)) {
                var2 = null;
            }
            return var2;
        });
    }

    public boolean isOpen(RecipeBookType var0) {
        return this.getSettings((RecipeBookType)var0).open;
    }

    public void setOpen(RecipeBookType var0, boolean var12) {
        this.updateSettings(var0, var1 -> var1.setOpen(var12));
    }

    public boolean isFiltering(RecipeBookType var0) {
        return this.getSettings((RecipeBookType)var0).filtering;
    }

    public void setFiltering(RecipeBookType var0, boolean var12) {
        this.updateSettings(var0, var1 -> var1.setFiltering(var12));
    }

    private static RecipeBookSettings read(PacketDataSerializer var0) {
        EnumMap<RecipeBookType, a> var1 = new EnumMap<RecipeBookType, a>(RecipeBookType.class);
        for (RecipeBookType var5 : RecipeBookType.values()) {
            boolean var6 = var0.readBoolean();
            boolean var7 = var0.readBoolean();
            if (!var6 && !var7) continue;
            var1.put(var5, new a(var6, var7));
        }
        return new RecipeBookSettings(var1);
    }

    private void write(PacketDataSerializer var0) {
        for (RecipeBookType var4 : RecipeBookType.values()) {
            a var5 = this.states.getOrDefault((Object)var4, a.DEFAULT);
            var0.writeBoolean(var5.open);
            var0.writeBoolean(var5.filtering);
        }
    }

    public static RecipeBookSettings read(NBTTagCompound var0) {
        EnumMap<RecipeBookType, a> var1 = new EnumMap<RecipeBookType, a>(RecipeBookType.class);
        TAG_FIELDS.forEach((var2, var3) -> {
            boolean var4 = var0.getBoolean((String)var3.getFirst());
            boolean var5 = var0.getBoolean((String)var3.getSecond());
            if (var4 || var5) {
                var1.put((RecipeBookType)((Object)var2), new a(var4, var5));
            }
        });
        return new RecipeBookSettings(var1);
    }

    public void write(NBTTagCompound var0) {
        TAG_FIELDS.forEach((var1, var2) -> {
            a var3 = this.states.getOrDefault(var1, a.DEFAULT);
            var0.putBoolean((String)var2.getFirst(), var3.open);
            var0.putBoolean((String)var2.getSecond(), var3.filtering);
        });
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, a>(this.states));
    }

    public void replaceFrom(RecipeBookSettings var0) {
        this.states.clear();
        this.states.putAll(var0.states);
    }

    public boolean equals(Object var0) {
        return this == var0 || var0 instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)var0).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    static final class a
    extends Record {
        final boolean open;
        final boolean filtering;
        public static final a DEFAULT = new a(false, false);

        a(boolean var0, boolean var1) {
            this.open = var0;
            this.filtering = var1;
        }

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public a setOpen(boolean var0) {
            return new a(var0, this.filtering);
        }

        public a setFiltering(boolean var0) {
            return new a(this.open, var0);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "open;filtering", "open", "filtering"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "open;filtering", "open", "filtering"}, this, var0);
        }

        public boolean open() {
            return this.open;
        }

        public boolean filtering() {
            return this.filtering;
        }
    }
}

