/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final a displayResolver;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> highlight = Sets.newIdentityHashSet();

    public RecipeBookServer(a var0) {
        this.displayResolver = var0;
    }

    public void add(ResourceKey<IRecipe<?>> var0) {
        this.known.add(var0);
    }

    public boolean contains(ResourceKey<IRecipe<?>> var0) {
        return this.known.contains(var0);
    }

    public void remove(ResourceKey<IRecipe<?>> var0) {
        this.known.remove(var0);
        this.highlight.remove(var0);
    }

    public void removeHighlight(ResourceKey<IRecipe<?>> var0) {
        this.highlight.remove(var0);
    }

    private void addHighlight(ResourceKey<IRecipe<?>> var0) {
        this.highlight.add(var0);
    }

    public int addRecipes(Collection<RecipeHolder<?>> var0, EntityPlayer var1) {
        ArrayList<ClientboundRecipeBookAddPacket.a> var22 = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> var4 : var0) {
            ResourceKey<IRecipe<?>> var5 = var4.id();
            if (this.known.contains(var5) || var4.value().isSpecial()) continue;
            this.add(var5);
            this.addHighlight(var5);
            this.displayResolver.displaysForRecipe(var5, var2 -> var22.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)var2, var4.value().showNotification(), true)));
            CriterionTriggers.RECIPE_UNLOCKED.trigger(var1, var4);
        }
        if (!var22.isEmpty()) {
            var1.connection.send(new ClientboundRecipeBookAddPacket(var22, false));
        }
        return var22.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> var0, EntityPlayer var12) {
        ArrayList var2 = Lists.newArrayList();
        for (RecipeHolder<?> var4 : var0) {
            ResourceKey<IRecipe<?>> var5 = var4.id();
            if (!this.known.contains(var5)) continue;
            this.remove(var5);
            this.displayResolver.displaysForRecipe(var5, var1 -> var2.add(var1.id()));
        }
        if (!var2.isEmpty()) {
            var12.connection.send(new ClientboundRecipeBookRemovePacket(var2));
        }
        return var2.size();
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound var0 = new NBTTagCompound();
        this.getBookSettings().write(var0);
        NBTTagList var1 = new NBTTagList();
        for (ResourceKey<IRecipe<?>> var3 : this.known) {
            var1.add(NBTTagString.valueOf(var3.location().toString()));
        }
        var0.put("recipes", var1);
        NBTTagList var2 = new NBTTagList();
        for (ResourceKey<IRecipe<?>> var4 : this.highlight) {
            var2.add(NBTTagString.valueOf(var4.location().toString()));
        }
        var0.put("toBeDisplayed", var2);
        return var0;
    }

    public void fromNbt(NBTTagCompound var0, Predicate<ResourceKey<IRecipe<?>>> var1) {
        this.setBookSettings(RecipeBookSettings.read(var0));
        NBTTagList var2 = var0.getList("recipes", 8);
        this.loadRecipes(var2, this::add, var1);
        NBTTagList var3 = var0.getList("toBeDisplayed", 8);
        this.loadRecipes(var3, this::addHighlight, var1);
    }

    private void loadRecipes(NBTTagList var0, Consumer<ResourceKey<IRecipe<?>>> var1, Predicate<ResourceKey<IRecipe<?>>> var2) {
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            String var4 = var0.getString(var3);
            try {
                ResourceKey<IRecipe<?>> var5 = ResourceKey.create(Registries.RECIPE, MinecraftKey.parse(var4));
                if (!var2.test(var5)) {
                    LOGGER.error("Tried to load unrecognized recipe: {} removed now.", var5);
                    continue;
                }
                var1.accept(var5);
                continue;
            }
            catch (ResourceKeyInvalidException var5) {
                LOGGER.error("Tried to load improperly formatted recipe: {} removed now.", (Object)var4);
            }
        }
    }

    public void sendInitialRecipeBook(EntityPlayer var0) {
        var0.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings()));
        ArrayList<ClientboundRecipeBookAddPacket.a> var1 = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.known.size());
        for (ResourceKey<IRecipe<?>> var3 : this.known) {
            this.displayResolver.displaysForRecipe(var3, var2 -> var1.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)var2, false, this.highlight.contains(var3))));
        }
        var0.connection.send(new ClientboundRecipeBookAddPacket(var1, true));
    }

    public void copyOverData(RecipeBookServer var0) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(var0.bookSettings);
        this.known.addAll(var0.known);
        this.highlight.addAll(var0.highlight);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }
}

