/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public ReloadableProfiled(IResourceManager var0, List<IReloadListener> var12, Executor var22, Executor var3, CompletableFuture<Unit> var42) {
        super(var22, var3, var0, var12, (var1, var2, var32, var4, var5) -> {
            AtomicLong var6 = new AtomicLong();
            AtomicLong var7 = new AtomicLong();
            CompletableFuture<Void> var8 = var32.reload(var1, var2, ReloadableProfiled.profiledExecutor(var4, var6, var32.getName()), ReloadableProfiled.profiledExecutor(var5, var7, var32.getName()));
            return var8.thenApplyAsync(var3 -> {
                LOGGER.debug("Finished reloading {}", (Object)var32.getName());
                return new a(var32.getName(), var6, var7);
            }, var3);
        }, var42);
        this.total.start();
        this.allDone = this.allDone.thenApplyAsync(this::finish, var3);
    }

    private static Executor profiledExecutor(Executor var0, AtomicLong var1, String var2) {
        return var3 -> var0.execute(() -> {
            Runnable var3 = Profiler.get();
            var3.push(var2);
            long var4 = SystemUtils.getNanos();
            var3.run();
            var1.addAndGet(SystemUtils.getNanos() - var4);
            var3.pop();
        });
    }

    private List<a> finish(List<a> var0) {
        this.total.stop();
        long var1 = 0L;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (a var4 : var0) {
            long var5 = TimeUnit.NANOSECONDS.toMillis(var4.preparationNanos.get());
            long var7 = TimeUnit.NANOSECONDS.toMillis(var4.reloadNanos.get());
            long var9 = var5 + var7;
            String var11 = var4.name;
            LOGGER.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{var11, var9, var5, var7});
            var1 += var7;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)var1);
        return var0;
    }

    public static final class a
    extends Record {
        final String name;
        final AtomicLong preparationNanos;
        final AtomicLong reloadNanos;

        public a(String var0, AtomicLong var1, AtomicLong var2) {
            this.name = var0;
            this.preparationNanos = var1;
            this.reloadNanos = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "name", "preparationNanos", "reloadNanos"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "name", "preparationNanos", "reloadNanos"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "name", "preparationNanos", "reloadNanos"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        public AtomicLong preparationNanos() {
            return this.preparationNanos;
        }

        public AtomicLong reloadNanos() {
            return this.reloadNanos;
        }
    }
}

