/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ReloadableProfiled;
import net.minecraft.util.Unit;

public class Reloadable<S>
implements IReloadable {
    private static final int PREPARATION_PROGRESS_WEIGHT = 2;
    private static final int EXTRA_RELOAD_PROGRESS_WEIGHT = 2;
    private static final int LISTENER_PROGRESS_WEIGHT = 1;
    protected final CompletableFuture<Unit> allPreparations = new CompletableFuture();
    protected CompletableFuture<List<S>> allDone;
    final Set<IReloadListener> preparingListeners;
    private final int listenerCount;
    private int startedReloads;
    private int finishedReloads;
    private final AtomicInteger startedTaskCounter = new AtomicInteger();
    private final AtomicInteger doneTaskCounter = new AtomicInteger();

    public static Reloadable<Void> of(IResourceManager var0, List<IReloadListener> var12, Executor var22, Executor var32, CompletableFuture<Unit> var42) {
        return new Reloadable<Void>(var22, var32, var0, var12, (var1, var2, var3, var4, var5) -> var3.reload(var1, var2, var22, var5), var42);
    }

    protected Reloadable(Executor var0, final Executor var12, IResourceManager var2, List<IReloadListener> var3, a<S> var4, CompletableFuture<Unit> var5) {
        this.listenerCount = var3.size();
        this.startedTaskCounter.incrementAndGet();
        var5.thenRun(this.doneTaskCounter::incrementAndGet);
        ArrayList var6 = Lists.newArrayList();
        CompletableFuture<Unit> var7 = var5;
        this.preparingListeners = Sets.newHashSet(var3);
        for (final IReloadListener var9 : var3) {
            final CompletableFuture<Unit> var10 = var7;
            CompletableFuture<S> var11 = var4.create(new IReloadListener.a(){

                @Override
                public <T> CompletableFuture<T> wait(T var0) {
                    var12.execute(() -> {
                        Reloadable.this.preparingListeners.remove(var9);
                        if (Reloadable.this.preparingListeners.isEmpty()) {
                            Reloadable.this.allPreparations.complete(Unit.INSTANCE);
                        }
                    });
                    return Reloadable.this.allPreparations.thenCombine((CompletionStage)var10, (var1, var2) -> var0);
                }
            }, var2, var9, var1 -> {
                this.startedTaskCounter.incrementAndGet();
                var0.execute(() -> {
                    var1.run();
                    this.doneTaskCounter.incrementAndGet();
                });
            }, var1 -> {
                ++this.startedReloads;
                var12.execute(() -> {
                    var1.run();
                    ++this.finishedReloads;
                });
            });
            var6.add(var11);
            var7 = var11;
        }
        this.allDone = SystemUtils.sequenceFailFast(var6);
    }

    @Override
    public CompletableFuture<?> done() {
        return this.allDone;
    }

    @Override
    public float getActualProgress() {
        int var0 = this.listenerCount - this.preparingListeners.size();
        float var1 = this.doneTaskCounter.get() * 2 + this.finishedReloads * 2 + var0 * 1;
        float var2 = this.startedTaskCounter.get() * 2 + this.startedReloads * 2 + this.listenerCount * 1;
        return var1 / var2;
    }

    public static IReloadable create(IResourceManager var0, List<IReloadListener> var1, Executor var2, Executor var3, CompletableFuture<Unit> var4, boolean var5) {
        if (var5) {
            return new ReloadableProfiled(var0, var1, var2, var3, var4);
        }
        return Reloadable.of(var0, var1, var2, var3, var4);
    }

    protected static interface a<S> {
        public CompletableFuture<S> create(IReloadListener.a var1, IResourceManager var2, IReloadListener var3, Executor var4, Executor var5);
    }
}

