/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import org.slf4j.Logger;

public abstract class ChunkMapDistance {
    static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> tickets = new Long2ObjectOpenHashMap();
    private final a ticketTracker = new a();
    private final b naturalSpawnChunkCounter = new b(8);
    private final TickingTracker tickingTicketsTracker = new TickingTracker();
    private final c playerTicketManager = new c(32);
    final Set<PlayerChunk> chunksToUpdateFutures = new ReferenceOpenHashSet();
    final ThrottlingChunkTaskDispatcher ticketDispatcher;
    final LongSet ticketsToRelease = new LongOpenHashSet();
    final Executor mainThreadExecutor;
    private long ticketTickCounter;
    public int simulationDistance = 10;

    protected ChunkMapDistance(Executor var0, Executor var1) {
        TaskScheduler<Runnable> var2 = TaskScheduler.wrapExecutor("player ticket throttler", var1);
        this.ticketDispatcher = new ThrottlingChunkTaskDispatcher(var2, var0, 4);
        this.mainThreadExecutor = var1;
    }

    protected void purgeStaleTickets() {
        ++this.ticketTickCounter;
        ObjectIterator var0 = this.tickets.long2ObjectEntrySet().fastIterator();
        while (var0.hasNext()) {
            Long2ObjectMap.Entry var1 = (Long2ObjectMap.Entry)var0.next();
            Iterator var2 = ((ArraySetSorted)var1.getValue()).iterator();
            boolean var3 = false;
            while (var2.hasNext()) {
                Ticket var4 = (Ticket)var2.next();
                if (!var4.timedOut(this.ticketTickCounter)) continue;
                var2.remove();
                var3 = true;
                this.tickingTicketsTracker.removeTicket(var1.getLongKey(), var4);
            }
            if (var3) {
                this.ticketTracker.update(var1.getLongKey(), ChunkMapDistance.getTicketLevelAt((ArraySetSorted)var1.getValue()), false);
            }
            if (!((ArraySetSorted)var1.getValue()).isEmpty()) continue;
            var0.remove();
        }
    }

    private static int getTicketLevelAt(ArraySetSorted<Ticket<?>> var0) {
        return !var0.isEmpty() ? var0.first().getTicketLevel() : ChunkLevel.MAX_LEVEL + 1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract PlayerChunk getChunk(long var1);

    @Nullable
    protected abstract PlayerChunk updateChunkScheduling(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean runAllUpdates(PlayerChunkMap var02) {
        boolean var22;
        this.naturalSpawnChunkCounter.runAllUpdates();
        this.tickingTicketsTracker.runAllUpdates();
        this.playerTicketManager.runAllUpdates();
        int var1 = Integer.MAX_VALUE - this.ticketTracker.runDistanceUpdates(Integer.MAX_VALUE);
        boolean bl = var22 = var1 != 0;
        if (var22) {
            // empty if block
        }
        if (!this.chunksToUpdateFutures.isEmpty()) {
            for (PlayerChunk var4 : this.chunksToUpdateFutures) {
                var4.updateHighestAllowedStatus(var02);
            }
            for (PlayerChunk var4 : this.chunksToUpdateFutures) {
                var4.updateFutures(var02, this.mainThreadExecutor);
            }
            this.chunksToUpdateFutures.clear();
            return true;
        }
        if (!this.ticketsToRelease.isEmpty()) {
            LongIterator var3 = this.ticketsToRelease.iterator();
            while (var3.hasNext()) {
                long var4 = var3.nextLong();
                if (!this.getTickets(var4).stream().anyMatch(var0 -> var0.getType() == TicketType.PLAYER)) continue;
                PlayerChunk var6 = var02.getUpdatingChunkIfPresent(var4);
                if (var6 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<Chunk>> var7 = var6.getEntityTickingChunkFuture();
                var7.thenAccept(var2 -> this.mainThreadExecutor.execute(() -> this.ticketDispatcher.release(var4, () -> {}, false)));
            }
            this.ticketsToRelease.clear();
        }
        return var22;
    }

    void addTicket(long var0, Ticket<?> var2) {
        ArraySetSorted<Ticket<?>> var3 = this.getTickets(var0);
        int var4 = ChunkMapDistance.getTicketLevelAt(var3);
        Ticket<?> var5 = var3.addOrGet(var2);
        var5.setCreatedTick(this.ticketTickCounter);
        if (var2.getTicketLevel() < var4) {
            this.ticketTracker.update(var0, var2.getTicketLevel(), true);
        }
    }

    void removeTicket(long var0, Ticket<?> var2) {
        ArraySetSorted<Ticket<?>> var3 = this.getTickets(var0);
        if (var3.remove(var2)) {
            // empty if block
        }
        if (var3.isEmpty()) {
            this.tickets.remove(var0);
        }
        this.ticketTracker.update(var0, ChunkMapDistance.getTicketLevelAt(var3), false);
    }

    public <T> void addTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        this.addTicket(var1.toLong(), new Ticket<T>(var0, var2, var3));
    }

    public <T> void removeTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        Ticket<T> var4 = new Ticket<T>(var0, var2, var3);
        this.removeTicket(var1.toLong(), var4);
    }

    public <T> void addRegionTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        Ticket<T> var4 = new Ticket<T>(var0, ChunkLevel.byStatus(FullChunkStatus.FULL) - var2, var3);
        long var5 = var1.toLong();
        this.addTicket(var5, var4);
        this.tickingTicketsTracker.addTicket(var5, var4);
    }

    public <T> void removeRegionTicket(TicketType<T> var0, ChunkCoordIntPair var1, int var2, T var3) {
        Ticket<T> var4 = new Ticket<T>(var0, ChunkLevel.byStatus(FullChunkStatus.FULL) - var2, var3);
        long var5 = var1.toLong();
        this.removeTicket(var5, var4);
        this.tickingTicketsTracker.removeTicket(var5, var4);
    }

    private ArraySetSorted<Ticket<?>> getTickets(long var02) {
        return (ArraySetSorted)this.tickets.computeIfAbsent(var02, var0 -> ArraySetSorted.create(4));
    }

    protected void updateChunkForced(ChunkCoordIntPair var0, boolean var1) {
        Ticket<ChunkCoordIntPair> var2 = new Ticket<ChunkCoordIntPair>(TicketType.FORCED, PlayerChunkMap.FORCED_TICKET_LEVEL, var0);
        long var3 = var0.toLong();
        if (var1) {
            this.addTicket(var3, var2);
            this.tickingTicketsTracker.addTicket(var3, var2);
        } else {
            this.removeTicket(var3, var2);
            this.tickingTicketsTracker.removeTicket(var3, var2);
        }
    }

    public void addPlayer(SectionPosition var02, EntityPlayer var1) {
        ChunkCoordIntPair var2 = var02.chunk();
        long var3 = var2.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent(var3, var0 -> new ObjectOpenHashSet())).add((Object)var1);
        this.naturalSpawnChunkCounter.update(var3, 0, true);
        this.playerTicketManager.update(var3, 0, true);
        this.tickingTicketsTracker.addTicket(TicketType.PLAYER, var2, this.getPlayerTicketLevel(), var2);
    }

    public void removePlayer(SectionPosition var0, EntityPlayer var1) {
        ChunkCoordIntPair var2 = var0.chunk();
        long var3 = var2.toLong();
        ObjectSet var5 = (ObjectSet)this.playersPerChunk.get(var3);
        var5.remove((Object)var1);
        if (var5.isEmpty()) {
            this.playersPerChunk.remove(var3);
            this.naturalSpawnChunkCounter.update(var3, Integer.MAX_VALUE, false);
            this.playerTicketManager.update(var3, Integer.MAX_VALUE, false);
            this.tickingTicketsTracker.removeTicket(TicketType.PLAYER, var2, this.getPlayerTicketLevel(), var2);
        }
    }

    private int getPlayerTicketLevel() {
        return Math.max(0, ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING) - this.simulationDistance);
    }

    public boolean inEntityTickingRange(long var0) {
        return ChunkLevel.isEntityTicking(this.tickingTicketsTracker.getLevel(var0));
    }

    public boolean inBlockTickingRange(long var0) {
        return ChunkLevel.isBlockTicking(this.tickingTicketsTracker.getLevel(var0));
    }

    protected String getTicketDebugString(long var0) {
        ArraySetSorted var2 = (ArraySetSorted)this.tickets.get(var0);
        if (var2 == null || var2.isEmpty()) {
            return "no_ticket";
        }
        return ((Ticket)var2.first()).toString();
    }

    protected void updatePlayerTickets(int var0) {
        this.playerTicketManager.updateViewDistance(var0);
    }

    public void updateSimulationDistance(int var0) {
        if (var0 != this.simulationDistance) {
            this.simulationDistance = var0;
            this.tickingTicketsTracker.replacePlayerTicketsLevel(this.getPlayerTicketLevel());
        }
    }

    public int getNaturalSpawnChunkCount() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.size();
    }

    public boolean hasPlayersNearby(long var0) {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.containsKey(var0);
    }

    public LongIterator getSpawnCandidateChunks() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.keySet().iterator();
    }

    public String getDebugStatus() {
        return this.ticketDispatcher.getDebugStatus();
    }

    private void dumpTickets(String var0) {
        try (FileOutputStream var1 = new FileOutputStream(new File(var0));){
            for (Long2ObjectMap.Entry var3 : this.tickets.long2ObjectEntrySet()) {
                ChunkCoordIntPair var4 = new ChunkCoordIntPair(var3.getLongKey());
                for (Ticket var6 : (ArraySetSorted)var3.getValue()) {
                    var1.write((var4.x + "\t" + var4.z + "\t" + String.valueOf(var6.getType()) + "\t" + var6.getTicketLevel() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException var12) {
            LOGGER.error("Failed to dump tickets to {}", (Object)var0, (Object)var12);
        }
    }

    @VisibleForTesting
    TickingTracker tickingTracker() {
        return this.tickingTicketsTracker;
    }

    public LongSet getTickingChunks() {
        return this.tickingTicketsTracker.getTickingChunks();
    }

    public void removeTicketsOnClosing() {
        ImmutableSet var0 = ImmutableSet.of(TicketType.UNKNOWN);
        ObjectIterator var1 = this.tickets.long2ObjectEntrySet().fastIterator();
        while (var1.hasNext()) {
            Long2ObjectMap.Entry var2 = (Long2ObjectMap.Entry)var1.next();
            Iterator var3 = ((ArraySetSorted)var2.getValue()).iterator();
            boolean var4 = false;
            while (var3.hasNext()) {
                Ticket var5 = (Ticket)var3.next();
                if (var0.contains(var5.getType())) continue;
                var3.remove();
                var4 = true;
                this.tickingTicketsTracker.removeTicket(var2.getLongKey(), var5);
            }
            if (var4) {
                this.ticketTracker.update(var2.getLongKey(), ChunkMapDistance.getTicketLevelAt((ArraySetSorted)var2.getValue()), false);
            }
            if (!((ArraySetSorted)var2.getValue()).isEmpty()) continue;
            var1.remove();
        }
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    class a
    extends ChunkMap {
        private static final int MAX_LEVEL = ChunkLevel.MAX_LEVEL + 1;

        public a() {
            super(MAX_LEVEL + 1, 16, 256);
        }

        @Override
        protected int getLevelFromSource(long var0) {
            ArraySetSorted var2 = (ArraySetSorted)ChunkMapDistance.this.tickets.get(var0);
            if (var2 == null) {
                return Integer.MAX_VALUE;
            }
            if (var2.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return ((Ticket)var2.first()).getTicketLevel();
        }

        @Override
        protected int getLevel(long var0) {
            PlayerChunk var2;
            if (!ChunkMapDistance.this.isChunkToRemove(var0) && (var2 = ChunkMapDistance.this.getChunk(var0)) != null) {
                return var2.getTicketLevel();
            }
            return MAX_LEVEL;
        }

        @Override
        protected void setLevel(long var0, int var2) {
            int var4;
            PlayerChunk var3 = ChunkMapDistance.this.getChunk(var0);
            int n2 = var4 = var3 == null ? MAX_LEVEL : var3.getTicketLevel();
            if (var4 == var2) {
                return;
            }
            if ((var3 = ChunkMapDistance.this.updateChunkScheduling(var0, var2, var3, var4)) != null) {
                ChunkMapDistance.this.chunksToUpdateFutures.add(var3);
            }
        }

        public int runDistanceUpdates(int var0) {
            return this.runUpdates(var0);
        }
    }

    class b
    extends ChunkMap {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected b(int var1) {
            super(var1 + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = var1;
            this.chunks.defaultReturnValue((byte)(var1 + 2));
        }

        @Override
        protected int getLevel(long var0) {
            return this.chunks.get(var0);
        }

        @Override
        protected void setLevel(long var0, int var2) {
            byte var3 = var2 > this.maxDistance ? this.chunks.remove(var0) : this.chunks.put(var0, (byte)var2);
            this.onLevelChange(var0, var3, var2);
        }

        protected void onLevelChange(long var0, int var2, int var3) {
        }

        @Override
        protected int getLevelFromSource(long var0) {
            return this.havePlayer(var0) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long var0) {
            ObjectSet var2 = (ObjectSet)ChunkMapDistance.this.playersPerChunk.get(var0);
            return var2 != null && !var2.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }

        private void dumpChunks(String var0) {
            try (FileOutputStream var1 = new FileOutputStream(new File(var0));){
                for (Long2ByteMap.Entry var3 : this.chunks.long2ByteEntrySet()) {
                    ChunkCoordIntPair var4 = new ChunkCoordIntPair(var3.getLongKey());
                    String var5 = Byte.toString(var3.getByteValue());
                    var1.write((var4.x + "\t" + var4.z + "\t" + var5 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException var12) {
                LOGGER.error("Failed to dump chunks to {}", (Object)var0, (Object)var12);
            }
        }
    }

    class c
    extends b {
        private int viewDistance;
        private final Long2IntMap queueLevels;
        private final LongSet toUpdate;

        protected c(int var1) {
            super(var1);
            this.queueLevels = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.toUpdate = new LongOpenHashSet();
            this.viewDistance = 0;
            this.queueLevels.defaultReturnValue(var1 + 2);
        }

        @Override
        protected void onLevelChange(long var0, int var2, int var3) {
            this.toUpdate.add(var0);
        }

        public void updateViewDistance(int var0) {
            for (Long2ByteMap.Entry var2 : this.chunks.long2ByteEntrySet()) {
                byte var3 = var2.getByteValue();
                long var4 = var2.getLongKey();
                this.onLevelChange(var4, var3, this.haveTicketFor(var3), var3 <= var0);
            }
            this.viewDistance = var0;
        }

        private void onLevelChange(long var0, int var2, boolean var3, boolean var4) {
            if (var3 != var4) {
                Ticket<ChunkCoordIntPair> var5 = new Ticket<ChunkCoordIntPair>(TicketType.PLAYER, PLAYER_TICKET_LEVEL, new ChunkCoordIntPair(var0));
                if (var4) {
                    ChunkMapDistance.this.ticketDispatcher.submit(() -> ChunkMapDistance.this.mainThreadExecutor.execute(() -> {
                        if (this.haveTicketFor(this.getLevel(var0))) {
                            ChunkMapDistance.this.addTicket(var0, var5);
                            ChunkMapDistance.this.ticketsToRelease.add(var0);
                        } else {
                            ChunkMapDistance.this.ticketDispatcher.release(var0, () -> {}, false);
                        }
                    }), var0, () -> var2);
                } else {
                    ChunkMapDistance.this.ticketDispatcher.release(var0, () -> ChunkMapDistance.this.mainThreadExecutor.execute(() -> ChunkMapDistance.this.removeTicket(var0, var5)), true);
                }
            }
        }

        @Override
        public void runAllUpdates() {
            super.runAllUpdates();
            if (!this.toUpdate.isEmpty()) {
                LongIterator var0 = this.toUpdate.iterator();
                while (var0.hasNext()) {
                    int var4;
                    long var1 = var0.nextLong();
                    int var3 = this.queueLevels.get(var1);
                    if (var3 == (var4 = this.getLevel(var1))) continue;
                    ChunkMapDistance.this.ticketDispatcher.onLevelChange(new ChunkCoordIntPair(var1), () -> this.queueLevels.get(var1), var4, var2 -> {
                        if (var2 >= this.queueLevels.defaultReturnValue()) {
                            this.queueLevels.remove(var1);
                        } else {
                            this.queueLevels.put(var1, var2);
                        }
                    });
                    this.onLevelChange(var1, var4, this.haveTicketFor(var3), this.haveTicketFor(var4));
                }
                this.toUpdate.clear();
            }
        }

        private boolean haveTicketFor(int var0) {
            return var0 <= this.viewDistance;
        }
    }
}

