/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class AutoRecipe<R extends IRecipe<?>> {
    private static final int ITEM_NOT_FOUND = -1;
    private final PlayerInventory inventory;
    private final a<R> menu;
    private final boolean useMaxItems;
    private final int gridWidth;
    private final int gridHeight;
    private final List<Slot> inputGridSlots;
    private final List<Slot> slotsToClear;

    public static <I extends RecipeInput, R extends IRecipe<I>> ContainerRecipeBook.a placeRecipe(a<R> var0, int var1, int var2, List<Slot> var3, List<Slot> var4, PlayerInventory var5, RecipeHolder<R> var6, boolean var7, boolean var8) {
        AutoRecipe<R> var9 = new AutoRecipe<R>(var0, var5, var7, var1, var2, var3, var4);
        if (!var8 && !var9.testClearGrid()) {
            return ContainerRecipeBook.a.NOTHING;
        }
        StackedItemContents var10 = new StackedItemContents();
        var5.fillStackedContents(var10);
        var0.fillCraftSlotsStackedContents(var10);
        return var9.tryPlaceRecipe(var6, var10);
    }

    private AutoRecipe(a<R> var0, PlayerInventory var1, boolean var2, int var3, int var4, List<Slot> var5, List<Slot> var6) {
        this.menu = var0;
        this.inventory = var1;
        this.useMaxItems = var2;
        this.gridWidth = var3;
        this.gridHeight = var4;
        this.inputGridSlots = var5;
        this.slotsToClear = var6;
    }

    private ContainerRecipeBook.a tryPlaceRecipe(RecipeHolder<R> var0, StackedItemContents var1) {
        if (var1.canCraft((IRecipe<?>)var0.value(), null)) {
            this.placeRecipe(var0, var1);
            this.inventory.setChanged();
            return ContainerRecipeBook.a.NOTHING;
        }
        this.clearGrid();
        this.inventory.setChanged();
        return ContainerRecipeBook.a.PLACE_GHOST_RECIPE;
    }

    private void clearGrid() {
        for (Slot var1 : this.slotsToClear) {
            ItemStack var2 = var1.getItem().copy();
            this.inventory.placeItemBackInInventory(var2, false);
            var1.set(var2);
        }
        this.menu.clearCraftingContent();
    }

    private void placeRecipe(RecipeHolder<R> var0, StackedItemContents var1) {
        boolean var22 = this.menu.recipeMatches(var0);
        int var32 = var1.getBiggestCraftableStack((IRecipe<?>)var0.value(), null);
        if (var22) {
            for (Slot slot : this.inputGridSlots) {
                ItemStack var6 = slot.getItem();
                if (var6.isEmpty() || Math.min(var32, var6.getMaxStackSize()) >= var6.getCount() + 1) continue;
                return;
            }
        }
        int var42 = this.calculateAmountToCraft(var32, var22);
        ArrayList<Holder<Item>> arrayList = new ArrayList<Holder<Item>>();
        if (!var1.canCraft((IRecipe<?>)var0.value(), var42, arrayList::add)) {
            return;
        }
        int var6 = AutoRecipe.clampToMaxStackSize(var42, arrayList);
        if (var6 != var42) {
            arrayList.clear();
            if (!var1.canCraft((IRecipe<?>)var0.value(), var6, arrayList::add)) {
                return;
            }
        }
        this.clearGrid();
        PlaceRecipeHelper.placeRecipe(this.gridWidth, this.gridHeight, var0.value(), var0.value().placementInfo().slotsToIngredientIndex(), (var2, var3, var4, var5) -> {
            if (var2 == -1) {
                return;
            }
            Slot var6 = this.inputGridSlots.get(var3);
            Holder var7 = (Holder)arrayList.get((int)var2);
            int var8 = var6;
            while (var8 > 0) {
                if ((var8 = this.moveItemToGrid(var6, var7, var8)) != -1) continue;
                return;
            }
        });
    }

    private static int clampToMaxStackSize(int var0, List<Holder<Item>> var1) {
        for (Holder<Item> var3 : var1) {
            var0 = Math.min(var0, var3.value().getDefaultMaxStackSize());
        }
        return var0;
    }

    private int calculateAmountToCraft(int var0, boolean var1) {
        if (this.useMaxItems) {
            return var0;
        }
        if (var1) {
            int var2 = Integer.MAX_VALUE;
            for (Slot var4 : this.inputGridSlots) {
                ItemStack var5 = var4.getItem();
                if (var5.isEmpty() || var2 <= var5.getCount()) continue;
                var2 = var5.getCount();
            }
            if (var2 != Integer.MAX_VALUE) {
                ++var2;
            }
            return var2;
        }
        return 1;
    }

    private int moveItemToGrid(Slot var0, Holder<Item> var1, int var2) {
        ItemStack var3 = var0.getItem();
        int var4 = this.inventory.findSlotMatchingCraftingIngredient(var1, var3);
        if (var4 == -1) {
            return -1;
        }
        ItemStack var5 = this.inventory.getItem(var4);
        ItemStack var6 = var2 < var5.getCount() ? this.inventory.removeItem(var4, var2) : this.inventory.removeItemNoUpdate(var4);
        int var7 = var6.getCount();
        if (var3.isEmpty()) {
            var0.set(var6);
        } else {
            var3.grow(var7);
        }
        return var2 - var7;
    }

    private boolean testClearGrid() {
        ArrayList var0 = Lists.newArrayList();
        int var1 = this.getAmountOfFreeSlotsInInventory();
        for (Slot var3 : this.inputGridSlots) {
            ItemStack var4 = var3.getItem().copy();
            if (var4.isEmpty()) continue;
            int var5 = this.inventory.getSlotWithRemainingSpace(var4);
            if (var5 == -1 && var0.size() <= var1) {
                for (ItemStack var7 : var0) {
                    if (!ItemStack.isSameItem(var7, var4) || var7.getCount() == var7.getMaxStackSize() || var7.getCount() + var4.getCount() > var7.getMaxStackSize()) continue;
                    var7.grow(var4.getCount());
                    var4.setCount(0);
                    break;
                }
                if (var4.isEmpty()) continue;
                if (var0.size() < var1) {
                    var0.add(var4);
                    continue;
                }
                return false;
            }
            if (var5 != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int var0 = 0;
        for (ItemStack var2 : this.inventory.items) {
            if (!var2.isEmpty()) continue;
            ++var0;
        }
        return var0;
    }

    public static interface a<T extends IRecipe<?>> {
        public void fillCraftSlotsStackedContents(StackedItemContents var1);

        public void clearCraftingContent();

        public boolean recipeMatches(RecipeHolder<T> var1);
    }
}

