/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.item.ItemStack;

public class PacketPlayOutWindowItems
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutWindowItems> STREAM_CODEC = Packet.codec(PacketPlayOutWindowItems::write, PacketPlayOutWindowItems::new);
    private final int containerId;
    private final int stateId;
    private final List<ItemStack> items;
    private final ItemStack carriedItem;

    public PacketPlayOutWindowItems(int var0, int var1, NonNullList<ItemStack> var2, ItemStack var3) {
        this.containerId = var0;
        this.stateId = var1;
        this.items = NonNullList.withSize(var2.size(), ItemStack.EMPTY);
        for (int var4 = 0; var4 < var2.size(); ++var4) {
            this.items.set(var4, var2.get(var4).copy());
        }
        this.carriedItem = var3.copy();
    }

    private PacketPlayOutWindowItems(RegistryFriendlyByteBuf var0) {
        this.containerId = var0.readContainerId();
        this.stateId = var0.readVarInt();
        this.items = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode(var0);
        this.carriedItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(var0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeContainerId(this.containerId);
        var0.writeVarInt(this.stateId);
        ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode(var0, this.items);
        ItemStack.OPTIONAL_STREAM_CODEC.encode(var0, this.carriedItem);
    }

    @Override
    public PacketType<PacketPlayOutWindowItems> type() {
        return GamePacketTypes.CLIENTBOUND_CONTAINER_SET_CONTENT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleContainerContent(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public int getStateId() {
        return this.stateId;
    }
}

