/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public record PacketPlayInVehicleMove(Vec3D position, float yRot, float xRot, boolean onGround) implements Packet<PacketListenerPlayIn>
{
    public static final StreamCodec<PacketDataSerializer, PacketPlayInVehicleMove> STREAM_CODEC = StreamCodec.composite(Vec3D.STREAM_CODEC, PacketPlayInVehicleMove::position, ByteBufCodecs.FLOAT, PacketPlayInVehicleMove::yRot, ByteBufCodecs.FLOAT, PacketPlayInVehicleMove::xRot, ByteBufCodecs.BOOL, PacketPlayInVehicleMove::onGround, PacketPlayInVehicleMove::new);

    public static PacketPlayInVehicleMove fromEntity(Entity var0) {
        return new PacketPlayInVehicleMove(new Vec3D(var0.lerpTargetX(), var0.lerpTargetY(), var0.lerpTargetZ()), var0.getYRot(), var0.getXRot(), var0.onGround());
    }

    @Override
    public PacketType<PacketPlayInVehicleMove> type() {
        return GamePacketTypes.SERVERBOUND_MOVE_VEHICLE;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleMoveVehicle(this);
    }
}

