/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChatHoverable {
    public static final Codec<ChatHoverable> CODEC = Codec.withAlternative((Codec)e.CODEC.codec(), (Codec)e.LEGACY_CODEC.codec()).xmap(ChatHoverable::new, var0 -> var0.event);
    private final e<?> event;

    public <T> ChatHoverable(EnumHoverAction<T> var0, T var1) {
        this(new e<T>(var0, var1));
    }

    private ChatHoverable(e<?> var0) {
        this.event = var0;
    }

    public EnumHoverAction<?> getAction() {
        return this.event.action;
    }

    @Nullable
    public <T> T getValue(EnumHoverAction<T> var0) {
        if (this.event.action == var0) {
            return var0.cast(this.event.value);
        }
        return null;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        return ((ChatHoverable)var0).event.equals(this.event);
    }

    public String toString() {
        return this.event.toString();
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    static final class e<T>
    extends Record {
        final EnumHoverAction<T> action;
        final T value;
        public static final MapCodec<e<?>> CODEC = EnumHoverAction.CODEC.dispatchMap("action", e::action, var0 -> var0.codec);
        public static final MapCodec<e<?>> LEGACY_CODEC = EnumHoverAction.CODEC.dispatchMap("action", e::action, var0 -> var0.legacyCodec);

        e(EnumHoverAction<T> var0, T var1) {
            this.action = var0;
            this.value = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "action;value", "action", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "action;value", "action", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "action;value", "action", "value"}, this, var0);
        }

        public EnumHoverAction<T> action() {
            return this.action;
        }

        public T value() {
            return this.value;
        }
    }

    public static class EnumHoverAction<T>
    implements INamable {
        public static final EnumHoverAction<IChatBaseComponent> SHOW_TEXT = new EnumHoverAction<IChatBaseComponent>("show_text", true, ComponentSerialization.CODEC, (var0, var1) -> DataResult.success((Object)var0));
        public static final EnumHoverAction<c> SHOW_ITEM = new EnumHoverAction<c>("show_item", true, c.CODEC, c::legacyCreate);
        public static final EnumHoverAction<b> SHOW_ENTITY = new EnumHoverAction<b>("show_entity", true, b.CODEC, b::legacyCreate);
        public static final Codec<EnumHoverAction<?>> UNSAFE_CODEC = INamable.fromValues(() -> new EnumHoverAction[]{SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY});
        public static final Codec<EnumHoverAction<?>> CODEC = UNSAFE_CODEC.validate(EnumHoverAction::filterForSerialization);
        private final String name;
        private final boolean allowFromServer;
        final MapCodec<e<T>> codec;
        final MapCodec<e<T>> legacyCodec;

        public EnumHoverAction(String var02, boolean var1, Codec<T> var2, final d<T> var3) {
            this.name = var02;
            this.allowFromServer = var1;
            this.codec = var2.xmap(var0 -> new e<Object>(this, var0), var0 -> var0.value).fieldOf("contents");
            this.legacyCodec = new Codec<e<T>>(){

                public <D> DataResult<Pair<e<T>, D>> decode(DynamicOps<D> var0, D var1) {
                    return ComponentSerialization.CODEC.decode(var0, var1).flatMap(var2 -> {
                        DataResult var32;
                        if (var0 instanceof RegistryOps) {
                            RegistryOps var4 = (RegistryOps)var0;
                            var32 = var3.parse((IChatBaseComponent)var2.getFirst(), var4);
                        } else {
                            var32 = var3.parse((IChatBaseComponent)var2.getFirst(), null);
                        }
                        return var32.map(var1 -> Pair.of(new e<Object>(this, var1), (Object)var2.getSecond()));
                    });
                }

                public <D> DataResult<D> encode(e<T> var0, DynamicOps<D> var1, D var2) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.encode((e)object, dynamicOps, object2);
                }
            }.fieldOf("value");
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        T cast(Object var0) {
            return (T)var0;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<EnumHoverAction<?>> filterForSerialization(@Nullable EnumHoverAction<?> var0) {
            if (var0 == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!var0.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf(var0));
            }
            return DataResult.success(var0, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface d<T> {
        public DataResult<T> parse(IChatBaseComponent var1, @Nullable RegistryOps<?> var2);
    }

    public static class c {
        public static final Codec<c> FULL_CODEC = ItemStack.CODEC.xmap(c::new, c::getItemStack);
        private static final Codec<c> SIMPLE_CODEC = ItemStack.SIMPLE_ITEM_CODEC.xmap(c::new, c::getItemStack);
        public static final Codec<c> CODEC = Codec.withAlternative(FULL_CODEC, SIMPLE_CODEC);
        private final Holder<Item> item;
        private final int count;
        private final DataComponentPatch components;
        @Nullable
        private ItemStack itemStack;

        c(Holder<Item> var0, int var1, DataComponentPatch var2) {
            this.item = var0;
            this.count = var1;
            this.components = var2;
        }

        public c(ItemStack var0) {
            this(var0.getItemHolder(), var0.getCount(), var0.getComponentsPatch());
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            c var1 = (c)var0;
            return this.count == var1.count && this.item.equals(var1.item) && this.components.equals(var1.components);
        }

        public int hashCode() {
            int var0 = this.item.hashCode();
            var0 = 31 * var0 + this.count;
            var0 = 31 * var0 + this.components.hashCode();
            return var0;
        }

        public ItemStack getItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(this.item, this.count, this.components);
            }
            return this.itemStack;
        }

        private static DataResult<c> legacyCreate(IChatBaseComponent var0, @Nullable RegistryOps<?> var1) {
            try {
                NBTTagCompound var2 = MojangsonParser.parseTag(var0.getString());
                DynamicOpsNBT var3 = var1 != null ? var1.withParent(DynamicOpsNBT.INSTANCE) : DynamicOpsNBT.INSTANCE;
                return ItemStack.CODEC.parse((DynamicOps)var3, (Object)var2).map(c::new);
            }
            catch (CommandSyntaxException var2) {
                return DataResult.error(() -> "Failed to parse item tag: " + var2.getMessage());
            }
        }
    }

    public static class b {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(var0 -> var0.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("id").forGetter(var0 -> var0.id), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("name").forGetter(var0 -> var0.name)).apply((Applicative)var02, b::new));
        public final EntityTypes<?> type;
        public final UUID id;
        public final Optional<IChatBaseComponent> name;
        @Nullable
        private List<IChatBaseComponent> linesCache;

        public b(EntityTypes<?> var0, UUID var1, @Nullable IChatBaseComponent var2) {
            this(var0, var1, Optional.ofNullable(var2));
        }

        public b(EntityTypes<?> var0, UUID var1, Optional<IChatBaseComponent> var2) {
            this.type = var0;
            this.id = var1;
            this.name = var2;
        }

        public static DataResult<b> legacyCreate(IChatBaseComponent var0, @Nullable RegistryOps<?> var1) {
            try {
                NBTTagCompound var22 = MojangsonParser.parseTag(var0.getString());
                JsonOps var3 = var1 != null ? var1.withParent(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult var4 = ComponentSerialization.CODEC.parse((DynamicOps)var3, (Object)JsonParser.parseString((String)var22.getString("name")));
                EntityTypes<?> var5 = BuiltInRegistries.ENTITY_TYPE.getValue(MinecraftKey.parse(var22.getString("type")));
                UUID var6 = UUID.fromString(var22.getString("id"));
                return var4.map(var2 -> new b(var5, var6, (IChatBaseComponent)var2));
            }
            catch (Exception var23) {
                return DataResult.error(() -> "Failed to parse tooltip: " + var23.getMessage());
            }
        }

        public List<IChatBaseComponent> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<IChatBaseComponent>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(IChatBaseComponent.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(IChatBaseComponent.literal(this.id.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            b var1 = (b)var0;
            return this.type.equals(var1.type) && this.id.equals(var1.id) && this.name.equals(var1.name);
        }

        public int hashCode() {
            int var0 = this.type.hashCode();
            var0 = 31 * var0 + this.id.hashCode();
            var0 = 31 * var0 + this.name.hashCode();
            return var0;
        }
    }
}

