/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.features;

import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandom2;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.DualNoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviderWeighted;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.FluidTypes;

public class VegetationFeatures {
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BAMBOO_NO_PODZOL = FeatureUtils.createKey("bamboo_no_podzol");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BAMBOO_SOME_PODZOL = FeatureUtils.createKey("bamboo_some_podzol");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> VINES = FeatureUtils.createKey("vines");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_BROWN_MUSHROOM = FeatureUtils.createKey("patch_brown_mushroom");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_RED_MUSHROOM = FeatureUtils.createKey("patch_red_mushroom");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_SUNFLOWER = FeatureUtils.createKey("patch_sunflower");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_PUMPKIN = FeatureUtils.createKey("patch_pumpkin");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_BERRY_BUSH = FeatureUtils.createKey("patch_berry_bush");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_TAIGA_GRASS = FeatureUtils.createKey("patch_taiga_grass");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_GRASS = FeatureUtils.createKey("patch_grass");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_GRASS_JUNGLE = FeatureUtils.createKey("patch_grass_jungle");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SINGLE_PIECE_OF_GRASS = FeatureUtils.createKey("single_piece_of_grass");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_DEAD_BUSH = FeatureUtils.createKey("patch_dead_bush");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_MELON = FeatureUtils.createKey("patch_melon");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_WATERLILY = FeatureUtils.createKey("patch_waterlily");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_TALL_GRASS = FeatureUtils.createKey("patch_tall_grass");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_LARGE_FERN = FeatureUtils.createKey("patch_large_fern");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_CACTUS = FeatureUtils.createKey("patch_cactus");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PATCH_SUGAR_CANE = FeatureUtils.createKey("patch_sugar_cane");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_DEFAULT = FeatureUtils.createKey("flower_default");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_FLOWER_FOREST = FeatureUtils.createKey("flower_flower_forest");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_SWAMP = FeatureUtils.createKey("flower_swamp");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_PLAIN = FeatureUtils.createKey("flower_plain");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_MEADOW = FeatureUtils.createKey("flower_meadow");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_CHERRY = FeatureUtils.createKey("flower_cherry");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FLOWER_PALE_GARDEN = FeatureUtils.createKey("flower_pale_garden");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FOREST_FLOWERS = FeatureUtils.createKey("forest_flowers");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PALE_FOREST_FLOWERS = FeatureUtils.createKey("pale_forest_flowers");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> DARK_FOREST_VEGETATION = FeatureUtils.createKey("dark_forest_vegetation");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PALE_GARDEN_VEGETATION = FeatureUtils.createKey("pale_garden_vegetation");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PALE_MOSS_VEGETATION = FeatureUtils.createKey("pale_moss_vegetation");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PALE_MOSS_PATCH = FeatureUtils.createKey("pale_moss_patch");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PALE_MOSS_PATCH_BONEMEAL = FeatureUtils.createKey("pale_moss_patch_bonemeal");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_FLOWER_FOREST = FeatureUtils.createKey("trees_flower_forest");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MEADOW_TREES = FeatureUtils.createKey("meadow_trees");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_TAIGA = FeatureUtils.createKey("trees_taiga");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_GROVE = FeatureUtils.createKey("trees_grove");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_SAVANNA = FeatureUtils.createKey("trees_savanna");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BIRCH_TALL = FeatureUtils.createKey("birch_tall");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_WINDSWEPT_HILLS = FeatureUtils.createKey("trees_windswept_hills");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_WATER = FeatureUtils.createKey("trees_water");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_BIRCH_AND_OAK = FeatureUtils.createKey("trees_birch_and_oak");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_PLAINS = FeatureUtils.createKey("trees_plains");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_SPARSE_JUNGLE = FeatureUtils.createKey("trees_sparse_jungle");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_OLD_GROWTH_SPRUCE_TAIGA = FeatureUtils.createKey("trees_old_growth_spruce_taiga");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_OLD_GROWTH_PINE_TAIGA = FeatureUtils.createKey("trees_old_growth_pine_taiga");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TREES_JUNGLE = FeatureUtils.createKey("trees_jungle");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BAMBOO_VEGETATION = FeatureUtils.createKey("bamboo_vegetation");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MUSHROOM_ISLAND_VEGETATION = FeatureUtils.createKey("mushroom_island_vegetation");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MANGROVE_VEGETATION = FeatureUtils.createKey("mangrove_vegetation");

    private static WorldGenFeatureRandomPatchConfiguration grassPatch(WorldGenFeatureStateProvider var0, int var1) {
        return FeatureUtils.simpleRandomPatchConfiguration(var1, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(var0)));
    }

    public static void bootstrap(BootstrapContext<WorldGenFeatureConfigured<?, ?>> var0) {
        HolderGetter<WorldGenFeatureConfigured<?, ?>> var1 = var0.lookup(Registries.CONFIGURED_FEATURE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var2 = var1.getOrThrow(TreeFeatures.HUGE_BROWN_MUSHROOM);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var3 = var1.getOrThrow(TreeFeatures.HUGE_RED_MUSHROOM);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var4 = var1.getOrThrow(TreeFeatures.FANCY_OAK_BEES_005);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var5 = var1.getOrThrow(TreeFeatures.OAK_BEES_005);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var6 = var1.getOrThrow(PATCH_GRASS_JUNGLE);
        HolderGetter<PlacedFeature> var7 = var0.lookup(Registries.PLACED_FEATURE);
        Holder.c<PlacedFeature> var8 = var7.getOrThrow(TreePlacements.DARK_OAK_CHECKED);
        Holder.c<PlacedFeature> var9 = var7.getOrThrow(TreePlacements.PALE_OAK_CHECKED);
        Holder.c<PlacedFeature> var10 = var7.getOrThrow(TreePlacements.PALE_OAK_CREAKING_CHECKED);
        Holder.c<PlacedFeature> var11 = var7.getOrThrow(TreePlacements.BIRCH_CHECKED);
        Holder.c<PlacedFeature> var12 = var7.getOrThrow(TreePlacements.FANCY_OAK_CHECKED);
        Holder.c<PlacedFeature> var13 = var7.getOrThrow(TreePlacements.BIRCH_BEES_002);
        Holder.c<PlacedFeature> var14 = var7.getOrThrow(TreePlacements.FANCY_OAK_BEES_002);
        Holder.c<PlacedFeature> var15 = var7.getOrThrow(TreePlacements.FANCY_OAK_BEES);
        Holder.c<PlacedFeature> var16 = var7.getOrThrow(TreePlacements.PINE_CHECKED);
        Holder.c<PlacedFeature> var17 = var7.getOrThrow(TreePlacements.SPRUCE_CHECKED);
        Holder.c<PlacedFeature> var18 = var7.getOrThrow(TreePlacements.PINE_ON_SNOW);
        Holder.c<PlacedFeature> var19 = var7.getOrThrow(TreePlacements.ACACIA_CHECKED);
        Holder.c<PlacedFeature> var20 = var7.getOrThrow(TreePlacements.SUPER_BIRCH_BEES_0002);
        Holder.c<PlacedFeature> var21 = var7.getOrThrow(TreePlacements.BIRCH_BEES_0002_PLACED);
        Holder.c<PlacedFeature> var22 = var7.getOrThrow(TreePlacements.FANCY_OAK_BEES_0002);
        Holder.c<PlacedFeature> var23 = var7.getOrThrow(TreePlacements.JUNGLE_BUSH);
        Holder.c<PlacedFeature> var24 = var7.getOrThrow(TreePlacements.MEGA_SPRUCE_CHECKED);
        Holder.c<PlacedFeature> var25 = var7.getOrThrow(TreePlacements.MEGA_PINE_CHECKED);
        Holder.c<PlacedFeature> var26 = var7.getOrThrow(TreePlacements.MEGA_JUNGLE_TREE_CHECKED);
        Holder.c<PlacedFeature> var27 = var7.getOrThrow(TreePlacements.TALL_MANGROVE_CHECKED);
        Holder.c<PlacedFeature> var28 = var7.getOrThrow(TreePlacements.OAK_CHECKED);
        Holder.c<PlacedFeature> var29 = var7.getOrThrow(TreePlacements.OAK_BEES_002);
        Holder.c<PlacedFeature> var30 = var7.getOrThrow(TreePlacements.SUPER_BIRCH_BEES);
        Holder.c<PlacedFeature> var31 = var7.getOrThrow(TreePlacements.SPRUCE_ON_SNOW);
        Holder.c<PlacedFeature> var32 = var7.getOrThrow(TreePlacements.OAK_BEES_0002);
        Holder.c<PlacedFeature> var33 = var7.getOrThrow(TreePlacements.JUNGLE_TREE_CHECKED);
        Holder.c<PlacedFeature> var34 = var7.getOrThrow(TreePlacements.MANGROVE_CHECKED);
        FeatureUtils.register(var0, BAMBOO_NO_PODZOL, WorldGenerator.BAMBOO, new WorldGenFeatureConfigurationChance(0.0f));
        FeatureUtils.register(var0, BAMBOO_SOME_PODZOL, WorldGenerator.BAMBOO, new WorldGenFeatureConfigurationChance(0.2f));
        FeatureUtils.register(var0, VINES, WorldGenerator.VINES);
        FeatureUtils.register(var0, PATCH_BROWN_MUSHROOM, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.BROWN_MUSHROOM))));
        FeatureUtils.register(var0, PATCH_RED_MUSHROOM, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.RED_MUSHROOM))));
        FeatureUtils.register(var0, PATCH_SUNFLOWER, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.SUNFLOWER))));
        FeatureUtils.register(var0, PATCH_PUMPKIN, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.PUMPKIN)), List.of(Blocks.GRASS_BLOCK)));
        FeatureUtils.register(var0, PATCH_BERRY_BUSH, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple((IBlockData)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue(BlockSweetBerryBush.AGE, 3))), List.of(Blocks.GRASS_BLOCK)));
        FeatureUtils.register(var0, PATCH_TAIGA_GRASS, WorldGenerator.RANDOM_PATCH, VegetationFeatures.grassPatch(new WorldGenFeatureStateProviderWeighted(SimpleWeightedRandomList.builder().add(Blocks.SHORT_GRASS.defaultBlockState(), 1).add(Blocks.FERN.defaultBlockState(), 4)), 32));
        FeatureUtils.register(var0, PATCH_GRASS, WorldGenerator.RANDOM_PATCH, VegetationFeatures.grassPatch(WorldGenFeatureStateProvider.simple(Blocks.SHORT_GRASS), 32));
        FeatureUtils.register(var0, PATCH_GRASS_JUNGLE, WorldGenerator.RANDOM_PATCH, new WorldGenFeatureRandomPatchConfiguration(32, 7, 3, PlacementUtils.filtered(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(new WorldGenFeatureStateProviderWeighted(SimpleWeightedRandomList.builder().add(Blocks.SHORT_GRASS.defaultBlockState(), 3).add(Blocks.FERN.defaultBlockState(), 1))), BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.not(BlockPredicate.matchesBlocks(EnumDirection.DOWN.getUnitVec3i(), Blocks.PODZOL))))));
        FeatureUtils.register(var0, SINGLE_PIECE_OF_GRASS, WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.SHORT_GRASS.defaultBlockState())));
        FeatureUtils.register(var0, PATCH_DEAD_BUSH, WorldGenerator.RANDOM_PATCH, VegetationFeatures.grassPatch(WorldGenFeatureStateProvider.simple(Blocks.DEAD_BUSH), 4));
        FeatureUtils.register(var0, PATCH_MELON, WorldGenerator.RANDOM_PATCH, new WorldGenFeatureRandomPatchConfiguration(64, 7, 3, PlacementUtils.filtered(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.MELON)), BlockPredicate.allOf(BlockPredicate.replaceable(), BlockPredicate.noFluid(), BlockPredicate.matchesBlocks(EnumDirection.DOWN.getUnitVec3i(), Blocks.GRASS_BLOCK)))));
        FeatureUtils.register(var0, PATCH_WATERLILY, WorldGenerator.RANDOM_PATCH, new WorldGenFeatureRandomPatchConfiguration(10, 7, 3, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.LILY_PAD)))));
        FeatureUtils.register(var0, PATCH_TALL_GRASS, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.TALL_GRASS))));
        FeatureUtils.register(var0, PATCH_LARGE_FERN, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.LARGE_FERN))));
        FeatureUtils.register(var0, PATCH_CACTUS, WorldGenerator.RANDOM_PATCH, FeatureUtils.simpleRandomPatchConfiguration(10, PlacementUtils.inlinePlaced(WorldGenerator.BLOCK_COLUMN, BlockColumnConfiguration.simple(BiasedToBottomInt.of(1, 3), WorldGenFeatureStateProvider.simple(Blocks.CACTUS)), BlockPredicateFilter.forPredicate(BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.wouldSurvive(Blocks.CACTUS.defaultBlockState(), BlockPosition.ZERO))))));
        FeatureUtils.register(var0, PATCH_SUGAR_CANE, WorldGenerator.RANDOM_PATCH, new WorldGenFeatureRandomPatchConfiguration(20, 4, 0, PlacementUtils.inlinePlaced(WorldGenerator.BLOCK_COLUMN, BlockColumnConfiguration.simple(BiasedToBottomInt.of(2, 4), WorldGenFeatureStateProvider.simple(Blocks.SUGAR_CANE)), BlockPredicateFilter.forPredicate(BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.wouldSurvive(Blocks.SUGAR_CANE.defaultBlockState(), BlockPosition.ZERO), BlockPredicate.anyOf(BlockPredicate.matchesFluids((BaseBlockPosition)new BlockPosition(1, -1, 0), FluidTypes.WATER, FluidTypes.FLOWING_WATER), BlockPredicate.matchesFluids((BaseBlockPosition)new BlockPosition(-1, -1, 0), FluidTypes.WATER, FluidTypes.FLOWING_WATER), BlockPredicate.matchesFluids((BaseBlockPosition)new BlockPosition(0, -1, 1), FluidTypes.WATER, FluidTypes.FLOWING_WATER), BlockPredicate.matchesFluids((BaseBlockPosition)new BlockPosition(0, -1, -1), FluidTypes.WATER, FluidTypes.FLOWING_WATER)))))));
        FeatureUtils.register(var0, FLOWER_DEFAULT, WorldGenerator.FLOWER, VegetationFeatures.grassPatch(new WorldGenFeatureStateProviderWeighted(SimpleWeightedRandomList.builder().add(Blocks.POPPY.defaultBlockState(), 2).add(Blocks.DANDELION.defaultBlockState(), 1)), 64));
        FeatureUtils.register(var0, FLOWER_FLOWER_FOREST, WorldGenerator.FLOWER, new WorldGenFeatureRandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(new NoiseProvider(2345L, new NoiseGeneratorNormal.a(0, 1.0, new double[0]), 0.020833334f, List.of(Blocks.DANDELION.defaultBlockState(), Blocks.POPPY.defaultBlockState(), Blocks.ALLIUM.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.RED_TULIP.defaultBlockState(), Blocks.ORANGE_TULIP.defaultBlockState(), Blocks.WHITE_TULIP.defaultBlockState(), Blocks.PINK_TULIP.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState(), Blocks.LILY_OF_THE_VALLEY.defaultBlockState()))))));
        FeatureUtils.register(var0, FLOWER_SWAMP, WorldGenerator.FLOWER, new WorldGenFeatureRandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.BLUE_ORCHID)))));
        FeatureUtils.register(var0, FLOWER_PLAIN, WorldGenerator.FLOWER, new WorldGenFeatureRandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(new NoiseThresholdProvider(2345L, new NoiseGeneratorNormal.a(0, 1.0, new double[0]), 0.005f, -0.8f, 0.33333334f, Blocks.DANDELION.defaultBlockState(), List.of(Blocks.ORANGE_TULIP.defaultBlockState(), Blocks.RED_TULIP.defaultBlockState(), Blocks.PINK_TULIP.defaultBlockState(), Blocks.WHITE_TULIP.defaultBlockState()), List.of(Blocks.POPPY.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState()))))));
        FeatureUtils.register(var0, FLOWER_MEADOW, WorldGenerator.FLOWER, new WorldGenFeatureRandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(new DualNoiseProvider(new InclusiveRange<Integer>(1, 3), new NoiseGeneratorNormal.a(-10, 1.0, new double[0]), 1.0f, 2345L, new NoiseGeneratorNormal.a(-3, 1.0, new double[0]), 1.0f, List.of(Blocks.TALL_GRASS.defaultBlockState(), Blocks.ALLIUM.defaultBlockState(), Blocks.POPPY.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.DANDELION.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.SHORT_GRASS.defaultBlockState()))))));
        SimpleWeightedRandomList.a<IBlockData> var35 = SimpleWeightedRandomList.builder();
        for (int var36 = 1; var36 <= 4; ++var36) {
            for (EnumDirection var38 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                var35.add((IBlockData)((IBlockData)Blocks.PINK_PETALS.defaultBlockState().setValue(PinkPetalsBlock.AMOUNT, var36)).setValue(PinkPetalsBlock.FACING, var38), 1);
            }
        }
        FeatureUtils.register(var0, FLOWER_CHERRY, WorldGenerator.FLOWER, new WorldGenFeatureRandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(new WorldGenFeatureStateProviderWeighted(var35)))));
        FeatureUtils.register(var0, FLOWER_PALE_GARDEN, WorldGenerator.FLOWER, new WorldGenFeatureRandomPatchConfiguration(1, 0, 0, PlacementUtils.onlyWhenEmpty(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.CLOSED_EYEBLOSSOM), true))));
        FeatureUtils.register(var0, FOREST_FLOWERS, WorldGenerator.SIMPLE_RANDOM_SELECTOR, new WorldGenFeatureRandom2(HolderSet.direct(PlacementUtils.inlinePlaced(WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.LILAC))), new PlacementModifier[0]), PlacementUtils.inlinePlaced(WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.ROSE_BUSH))), new PlacementModifier[0]), PlacementUtils.inlinePlaced(WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.PEONY))), new PlacementModifier[0]), PlacementUtils.inlinePlaced(WorldGenerator.NO_BONEMEAL_FLOWER, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.LILY_OF_THE_VALLEY))), new PlacementModifier[0]))));
        FeatureUtils.register(var0, PALE_FOREST_FLOWERS, WorldGenerator.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.CLOSED_EYEBLOSSOM), true)));
        FeatureUtils.register(var0, DARK_FOREST_VEGETATION, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced(var2, new PlacementModifier[0]), 0.025f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced(var3, new PlacementModifier[0]), 0.05f), new WeightedPlacedFeature(var8, 0.6666667f), new WeightedPlacedFeature(var11, 0.2f), new WeightedPlacedFeature(var12, 0.1f)), var28));
        FeatureUtils.register(var0, PALE_GARDEN_VEGETATION, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var10, 0.1f), new WeightedPlacedFeature(var9, 0.9f)), var9));
        FeatureUtils.register(var0, PALE_MOSS_VEGETATION, WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(new WorldGenFeatureStateProviderWeighted(SimpleWeightedRandomList.builder().add(Blocks.PALE_MOSS_CARPET.defaultBlockState(), 25).add(Blocks.SHORT_GRASS.defaultBlockState(), 25).add(Blocks.TALL_GRASS.defaultBlockState(), 10))));
        FeatureUtils.register(var0, PALE_MOSS_PATCH, WorldGenerator.VEGETATION_PATCH, new VegetationPatchConfiguration(TagsBlock.MOSS_REPLACEABLE, WorldGenFeatureStateProvider.simple(Blocks.PALE_MOSS_BLOCK), PlacementUtils.inlinePlaced(var1.getOrThrow(PALE_MOSS_VEGETATION), new PlacementModifier[0]), CaveSurface.FLOOR, ConstantInt.of(1), 0.0f, 5, 0.3f, UniformInt.of(2, 4), 0.75f));
        FeatureUtils.register(var0, PALE_MOSS_PATCH_BONEMEAL, WorldGenerator.VEGETATION_PATCH, new VegetationPatchConfiguration(TagsBlock.MOSS_REPLACEABLE, WorldGenFeatureStateProvider.simple(Blocks.PALE_MOSS_BLOCK), PlacementUtils.inlinePlaced(var1.getOrThrow(PALE_MOSS_VEGETATION), new PlacementModifier[0]), CaveSurface.FLOOR, ConstantInt.of(1), 0.0f, 5, 0.6f, UniformInt.of(1, 2), 0.75f));
        FeatureUtils.register(var0, TREES_FLOWER_FOREST, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var13, 0.2f), new WeightedPlacedFeature(var14, 0.1f)), var29));
        FeatureUtils.register(var0, MEADOW_TREES, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var15, 0.5f)), var30));
        FeatureUtils.register(var0, TREES_TAIGA, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var16, 0.33333334f)), var17));
        FeatureUtils.register(var0, TREES_GROVE, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var18, 0.33333334f)), var31));
        FeatureUtils.register(var0, TREES_SAVANNA, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var19, 0.8f)), var28));
        FeatureUtils.register(var0, BIRCH_TALL, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var20, 0.5f)), var21));
        FeatureUtils.register(var0, TREES_WINDSWEPT_HILLS, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var17, 0.666f), new WeightedPlacedFeature(var12, 0.1f)), var28));
        FeatureUtils.register(var0, TREES_WATER, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var12, 0.1f)), var28));
        FeatureUtils.register(var0, TREES_BIRCH_AND_OAK, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var21, 0.2f), new WeightedPlacedFeature(var22, 0.1f)), var32));
        FeatureUtils.register(var0, TREES_PLAINS, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced(var4, new PlacementModifier[0]), 0.33333334f)), PlacementUtils.inlinePlaced(var5, new PlacementModifier[0])));
        FeatureUtils.register(var0, TREES_SPARSE_JUNGLE, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var12, 0.1f), new WeightedPlacedFeature(var23, 0.5f)), var33));
        FeatureUtils.register(var0, TREES_OLD_GROWTH_SPRUCE_TAIGA, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var24, 0.33333334f), new WeightedPlacedFeature(var16, 0.33333334f)), var17));
        FeatureUtils.register(var0, TREES_OLD_GROWTH_PINE_TAIGA, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var24, 0.025641026f), new WeightedPlacedFeature(var25, 0.30769232f), new WeightedPlacedFeature(var16, 0.33333334f)), var17));
        FeatureUtils.register(var0, TREES_JUNGLE, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var12, 0.1f), new WeightedPlacedFeature(var23, 0.5f), new WeightedPlacedFeature(var26, 0.33333334f)), var33));
        FeatureUtils.register(var0, BAMBOO_VEGETATION, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var12, 0.05f), new WeightedPlacedFeature(var23, 0.15f), new WeightedPlacedFeature(var26, 0.7f)), PlacementUtils.inlinePlaced(var6, new PlacementModifier[0])));
        FeatureUtils.register(var0, MUSHROOM_ISLAND_VEGETATION, WorldGenerator.RANDOM_BOOLEAN_SELECTOR, new WorldGenFeatureChoiceConfiguration(PlacementUtils.inlinePlaced(var3, new PlacementModifier[0]), PlacementUtils.inlinePlaced(var2, new PlacementModifier[0])));
        FeatureUtils.register(var0, MANGROVE_VEGETATION, WorldGenerator.RANDOM_SELECTOR, new WorldGenFeatureRandomChoiceConfiguration(List.of(new WeightedPlacedFeature(var27, 0.85f)), var34));
    }
}

