/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseBehaviorBoat;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.DispenseBehaviorShears;
import net.minecraft.core.dispenser.DispenseBehaviorShulkerBox;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.MinecartDispenseItemBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public interface IDispenseBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final IDispenseBehavior NOOP = (var0, var1) -> var1;

    public ItemStack dispense(SourceBlock var1, ItemStack var2);

    public static void bootStrap() {
        BlockDispenser.registerProjectileBehavior(Items.ARROW);
        BlockDispenser.registerProjectileBehavior(Items.TIPPED_ARROW);
        BlockDispenser.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        BlockDispenser.registerProjectileBehavior(Items.EGG);
        BlockDispenser.registerProjectileBehavior(Items.SNOWBALL);
        BlockDispenser.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        BlockDispenser.registerProjectileBehavior(Items.SPLASH_POTION);
        BlockDispenser.registerProjectileBehavior(Items.LINGERING_POTION);
        BlockDispenser.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        BlockDispenser.registerProjectileBehavior(Items.FIRE_CHARGE);
        BlockDispenser.registerProjectileBehavior(Items.WIND_CHARGE);
        DispenseBehaviorItem var0 = new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                EntityTypes<?> var3 = ((ItemMonsterEgg)var1.getItem()).getType(var0.level().registryAccess(), var1);
                try {
                    var3.spawn(var0.level(), var1, null, var0.pos().relative(var2), EntitySpawnReason.DISPENSER, var2 != EnumDirection.UP, false);
                }
                catch (Exception var4) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)var0.pos(), (Object)var4);
                    return ItemStack.EMPTY;
                }
                var1.shrink(1);
                var0.level().gameEvent(null, GameEvent.ENTITY_PLACE, var0.pos());
                return var1;
            }
        };
        for (ItemMonsterEgg var2 : ItemMonsterEgg.eggs()) {
            BlockDispenser.registerBehavior(var2, var0);
        }
        BlockDispenser.registerBehavior(Items.ARMOR_STAND, new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var12) {
                Consumer<EntityArmorStand> var5;
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var3 = var0.pos().relative(var2);
                WorldServer var4 = var0.level();
                EntityArmorStand var6 = EntityTypes.ARMOR_STAND.spawn(var4, var5 = EntityTypes.appendDefaultStackConfig(var1 -> var1.setYRot(var2.toYRot()), var4, var12, null), var3, EntitySpawnReason.DISPENSER, false, false);
                if (var6 != null) {
                    var12.shrink(1);
                }
                return var12;
            }
        });
        BlockDispenser.registerBehavior(Items.SADDLE, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var02, ItemStack var1) {
                BlockPosition var2 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                List<EntityLiving> var3 = var02.level().getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(var2), var0 -> {
                    if (var0 instanceof ISaddleable) {
                        ISaddleable var1 = (ISaddleable)((Object)var0);
                        return !var1.isSaddled() && var1.isSaddleable();
                    }
                    return false;
                });
                if (!var3.isEmpty()) {
                    ((ISaddleable)((Object)var3.get(0))).equipSaddle(var1.split(1), SoundCategory.BLOCKS);
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var02, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.CHEST, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var02, ItemStack var1) {
                BlockPosition var2 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                List<EntityHorseChestedAbstract> var3 = var02.level().getEntitiesOfClass(EntityHorseChestedAbstract.class, new AxisAlignedBB(var2), var0 -> var0.isAlive() && !var0.hasChest());
                for (EntityHorseChestedAbstract var5 : var3) {
                    if (!var5.isTamed() || !var5.getSlot(499).set(var1)) continue;
                    var1.shrink(1);
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var02, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.OAK_BOAT, new DispenseBehaviorBoat(EntityTypes.OAK_BOAT));
        BlockDispenser.registerBehavior(Items.SPRUCE_BOAT, new DispenseBehaviorBoat(EntityTypes.SPRUCE_BOAT));
        BlockDispenser.registerBehavior(Items.BIRCH_BOAT, new DispenseBehaviorBoat(EntityTypes.BIRCH_BOAT));
        BlockDispenser.registerBehavior(Items.JUNGLE_BOAT, new DispenseBehaviorBoat(EntityTypes.JUNGLE_BOAT));
        BlockDispenser.registerBehavior(Items.DARK_OAK_BOAT, new DispenseBehaviorBoat(EntityTypes.DARK_OAK_BOAT));
        BlockDispenser.registerBehavior(Items.ACACIA_BOAT, new DispenseBehaviorBoat(EntityTypes.ACACIA_BOAT));
        BlockDispenser.registerBehavior(Items.CHERRY_BOAT, new DispenseBehaviorBoat(EntityTypes.CHERRY_BOAT));
        BlockDispenser.registerBehavior(Items.MANGROVE_BOAT, new DispenseBehaviorBoat(EntityTypes.MANGROVE_BOAT));
        BlockDispenser.registerBehavior(Items.PALE_OAK_BOAT, new DispenseBehaviorBoat(EntityTypes.PALE_OAK_BOAT));
        BlockDispenser.registerBehavior(Items.BAMBOO_RAFT, new DispenseBehaviorBoat(EntityTypes.BAMBOO_RAFT));
        BlockDispenser.registerBehavior(Items.OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.OAK_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.SPRUCE_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.SPRUCE_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.BIRCH_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.BIRCH_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.JUNGLE_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.JUNGLE_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.DARK_OAK_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.ACACIA_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.ACACIA_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.CHERRY_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.CHERRY_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.MANGROVE_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.MANGROVE_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.PALE_OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityTypes.PALE_OAK_CHEST_BOAT));
        BlockDispenser.registerBehavior(Items.BAMBOO_CHEST_RAFT, new DispenseBehaviorBoat(EntityTypes.BAMBOO_CHEST_RAFT));
        DispenseBehaviorItem var1 = new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                DispensibleContainerItem var2 = (DispensibleContainerItem)((Object)var1.getItem());
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                WorldServer var4 = var0.level();
                if (var2.emptyContents(null, var4, var3, null)) {
                    var2.checkExtraContent(null, var4, var1, var3);
                    return this.consumeWithRemainder(var0, var1, new ItemStack(Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(var0, var1);
            }
        };
        BlockDispenser.registerBehavior(Items.LAVA_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.WATER_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.POWDER_SNOW_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.SALMON_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.COD_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.PUFFERFISH_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.TROPICAL_FISH_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.AXOLOTL_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.TADPOLE_BUCKET, var1);
        BlockDispenser.registerBehavior(Items.BUCKET, new DispenseBehaviorItem(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                ItemStack var8;
                BlockPosition var3;
                WorldServer var2 = var0.level();
                IBlockData var4 = var2.getBlockState(var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING)));
                Block var5 = var4.getBlock();
                if (var5 instanceof IFluidSource) {
                    IFluidSource var7 = (IFluidSource)((Object)var5);
                    var8 = var7.pickupBlock(null, var2, var3, var4);
                    if (var8.isEmpty()) {
                        return super.execute(var0, var1);
                    }
                } else {
                    return super.execute(var0, var1);
                }
                var2.gameEvent(null, GameEvent.FLUID_PICKUP, var3);
                Item var6 = var8.getItem();
                return this.consumeWithRemainder(var0, var1, new ItemStack(var6));
            }
        });
        BlockDispenser.registerBehavior(Items.FLINT_AND_STEEL, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var02, ItemStack var1) {
                WorldServer var2 = var02.level();
                this.setSuccess(true);
                EnumDirection var3 = var02.state().getValue(BlockDispenser.FACING);
                BlockPosition var4 = var02.pos().relative(var3);
                IBlockData var5 = var2.getBlockState(var4);
                if (BlockFireAbstract.canBePlacedAt(var2, var4, var3)) {
                    var2.setBlockAndUpdate(var4, BlockFireAbstract.getState(var2, var4));
                    var2.gameEvent(null, GameEvent.BLOCK_PLACE, var4);
                } else if (BlockCampfire.canLight(var5) || CandleBlock.canLight(var5) || CandleCakeBlock.canLight(var5)) {
                    var2.setBlockAndUpdate(var4, (IBlockData)var5.setValue(BlockProperties.LIT, true));
                    var2.gameEvent(null, GameEvent.BLOCK_CHANGE, var4);
                } else if (var5.getBlock() instanceof BlockTNT) {
                    BlockTNT.explode(var2, var4);
                    var2.removeBlock(var4, false);
                } else {
                    this.setSuccess(false);
                }
                if (this.isSuccess()) {
                    var1.hurtAndBreak(1, var2, null, var0 -> {});
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Items.BONE_MEAL, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                this.setSuccess(true);
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                if (ItemBoneMeal.growCrop(var1, var2, var3) || ItemBoneMeal.growWaterPlant(var1, var2, var3, null)) {
                    if (!var2.isClientSide) {
                        var2.levelEvent(1505, var3, 15);
                    }
                } else {
                    this.setSuccess(false);
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Blocks.TNT, new DispenseBehaviorItem(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                EntityTNTPrimed var4 = new EntityTNTPrimed(var2, (double)var3.getX() + 0.5, var3.getY(), (double)var3.getZ() + 0.5, null);
                var2.addFreshEntity(var4);
                var2.playSound(null, var4.getX(), var4.getY(), var4.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var2.gameEvent(null, GameEvent.ENTITY_PLACE, var3);
                var1.shrink(1);
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Items.WITHER_SKELETON_SKULL, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                EnumDirection var3 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var4 = var0.pos().relative(var3);
                if (var2.isEmptyBlock(var4) && BlockWitherSkull.canSpawnMob(var2, var4, var1)) {
                    var2.setBlock(var4, (IBlockData)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(BlockSkull.ROTATION, RotationSegment.convertToSegment(var3)), 3);
                    var2.gameEvent(null, GameEvent.BLOCK_PLACE, var4);
                    TileEntity var5 = var2.getBlockEntity(var4);
                    if (var5 instanceof TileEntitySkull) {
                        BlockWitherSkull.checkSpawn(var2, var4, (TileEntitySkull)var5);
                    }
                    var1.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(var0, var1));
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Blocks.CARVED_PUMPKIN, new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var0, ItemStack var1) {
                WorldServer var2 = var0.level();
                BlockPosition var3 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                BlockPumpkinCarved var4 = (BlockPumpkinCarved)Blocks.CARVED_PUMPKIN;
                if (var2.isEmptyBlock(var3) && var4.canSpawnGolem(var2, var3)) {
                    if (!var2.isClientSide) {
                        var2.setBlock(var3, var4.defaultBlockState(), 3);
                        var2.gameEvent(null, GameEvent.BLOCK_PLACE, var3);
                    }
                    var1.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(var0, var1));
                }
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Blocks.SHULKER_BOX.asItem(), new DispenseBehaviorShulkerBox());
        for (EnumColor var5 : EnumColor.values()) {
            BlockDispenser.registerBehavior(BlockShulkerBox.getBlockByColor(var5).asItem(), new DispenseBehaviorShulkerBox());
        }
        BlockDispenser.registerBehavior(Items.GLASS_BOTTLE.asItem(), new DispenseBehaviorMaybe(){

            private ItemStack takeLiquid(SourceBlock var0, ItemStack var1, ItemStack var2) {
                var0.level().gameEvent(null, GameEvent.FLUID_PICKUP, var0.pos());
                return this.consumeWithRemainder(var0, var1, var2);
            }

            @Override
            public ItemStack execute(SourceBlock var02, ItemStack var1) {
                this.setSuccess(false);
                WorldServer var2 = var02.level();
                BlockPosition var3 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
                IBlockData var4 = var2.getBlockState(var3);
                if (var4.is(TagsBlock.BEEHIVES, var0 -> var0.hasProperty(BlockBeehive.HONEY_LEVEL) && var0.getBlock() instanceof BlockBeehive) && var4.getValue(BlockBeehive.HONEY_LEVEL) >= 5) {
                    ((BlockBeehive)var4.getBlock()).releaseBeesAndResetHoneyLevel(var2, var4, var3, null, TileEntityBeehive.ReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(var02, var1, new ItemStack(Items.HONEY_BOTTLE));
                }
                if (var2.getFluidState(var3).is(TagsFluid.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(var02, var1, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(var02, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.GLOWSTONE, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
                BlockPosition var3 = var0.pos().relative(var2);
                WorldServer var4 = var0.level();
                IBlockData var5 = var4.getBlockState(var3);
                this.setSuccess(true);
                if (var5.is(Blocks.RESPAWN_ANCHOR)) {
                    if (var5.getValue(BlockRespawnAnchor.CHARGE) != 4) {
                        BlockRespawnAnchor.charge(null, var4, var3, var5);
                        var1.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return var1;
                }
                return super.execute(var0, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.SHEARS.asItem(), new DispenseBehaviorShears());
        BlockDispenser.registerBehavior(Items.BRUSH.asItem(), new DispenseBehaviorMaybe(){

            @Override
            protected ItemStack execute(SourceBlock var02, ItemStack var1) {
                BlockPosition var3;
                WorldServer var2 = var02.level();
                List<Entity> var4 = var2.getEntitiesOfClass(Armadillo.class, new AxisAlignedBB(var3 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING))), IEntitySelector.NO_SPECTATORS);
                if (var4.isEmpty()) {
                    this.setSuccess(false);
                    return var1;
                }
                for (Armadillo armadillo : var4) {
                    if (!armadillo.brushOffScute()) continue;
                    var1.hurtAndBreak(16, var2, null, var0 -> {});
                    return var1;
                }
                this.setSuccess(false);
                return var1;
            }
        });
        BlockDispenser.registerBehavior(Items.HONEYCOMB, new DispenseBehaviorMaybe(){

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                BlockPosition var2 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                WorldServer var3 = var0.level();
                IBlockData var4 = var3.getBlockState(var2);
                Optional<IBlockData> var5 = HoneycombItem.getWaxed(var4);
                if (var5.isPresent()) {
                    var3.setBlockAndUpdate(var2, var5.get());
                    var3.levelEvent(3003, var2, 0);
                    var1.shrink(1);
                    this.setSuccess(true);
                    return var1;
                }
                return super.execute(var0, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.POTION, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public ItemStack execute(SourceBlock var0, ItemStack var1) {
                PotionContents var2 = var1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!var2.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(var0, var1);
                }
                WorldServer var3 = var0.level();
                BlockPosition var4 = var0.pos();
                BlockPosition var5 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
                if (var3.getBlockState(var5).is(TagsBlock.CONVERTABLE_TO_MUD)) {
                    if (!var3.isClientSide) {
                        for (int var6 = 0; var6 < 5; ++var6) {
                            var3.sendParticles(Particles.SPLASH, (double)var4.getX() + var3.random.nextDouble(), var4.getY() + 1, (double)var4.getZ() + var3.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                    var3.playSound(null, var4, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    var3.gameEvent(null, GameEvent.FLUID_PLACE, var4);
                    var3.setBlockAndUpdate(var5, Blocks.MUD.defaultBlockState());
                    return this.consumeWithRemainder(var0, var1, new ItemStack(Items.GLASS_BOTTLE));
                }
                return this.defaultDispenseItemBehavior.dispense(var0, var1);
            }
        });
        BlockDispenser.registerBehavior(Items.MINECART, new MinecartDispenseItemBehavior(EntityTypes.MINECART));
        BlockDispenser.registerBehavior(Items.CHEST_MINECART, new MinecartDispenseItemBehavior(EntityTypes.CHEST_MINECART));
        BlockDispenser.registerBehavior(Items.FURNACE_MINECART, new MinecartDispenseItemBehavior(EntityTypes.FURNACE_MINECART));
        BlockDispenser.registerBehavior(Items.TNT_MINECART, new MinecartDispenseItemBehavior(EntityTypes.TNT_MINECART));
        BlockDispenser.registerBehavior(Items.HOPPER_MINECART, new MinecartDispenseItemBehavior(EntityTypes.HOPPER_MINECART));
        BlockDispenser.registerBehavior(Items.COMMAND_BLOCK_MINECART, new MinecartDispenseItemBehavior(EntityTypes.COMMAND_BLOCK_MINECART));
    }
}

