/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;

public record CriterionConditionEntityEquipment(Optional<CriterionConditionItem> head, Optional<CriterionConditionItem> chest, Optional<CriterionConditionItem> legs, Optional<CriterionConditionItem> feet, Optional<CriterionConditionItem> body, Optional<CriterionConditionItem> mainhand, Optional<CriterionConditionItem> offhand) {
    public static final Codec<CriterionConditionEntityEquipment> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionItem.CODEC.optionalFieldOf("head").forGetter(CriterionConditionEntityEquipment::head), (App)CriterionConditionItem.CODEC.optionalFieldOf("chest").forGetter(CriterionConditionEntityEquipment::chest), (App)CriterionConditionItem.CODEC.optionalFieldOf("legs").forGetter(CriterionConditionEntityEquipment::legs), (App)CriterionConditionItem.CODEC.optionalFieldOf("feet").forGetter(CriterionConditionEntityEquipment::feet), (App)CriterionConditionItem.CODEC.optionalFieldOf("body").forGetter(CriterionConditionEntityEquipment::body), (App)CriterionConditionItem.CODEC.optionalFieldOf("mainhand").forGetter(CriterionConditionEntityEquipment::mainhand), (App)CriterionConditionItem.CODEC.optionalFieldOf("offhand").forGetter(CriterionConditionEntityEquipment::offhand)).apply((Applicative)var0, CriterionConditionEntityEquipment::new));

    public static CriterionConditionEntityEquipment captainPredicate(HolderGetter<Item> var0, HolderGetter<EnumBannerPatternType> var1) {
        return a.equipment().head(CriterionConditionItem.a.item().of(var0, Items.WHITE_BANNER).hasComponents(DataComponentPredicate.someOf(Raid.getOminousBannerInstance(var1).getComponents(), DataComponents.BANNER_PATTERNS, DataComponents.ITEM_NAME))).build();
    }

    public boolean matches(@Nullable Entity var0) {
        if (!(var0 instanceof EntityLiving)) {
            return false;
        }
        EntityLiving var1 = (EntityLiving)var0;
        if (this.head.isPresent() && !this.head.get().test(var1.getItemBySlot(EnumItemSlot.HEAD))) {
            return false;
        }
        if (this.chest.isPresent() && !this.chest.get().test(var1.getItemBySlot(EnumItemSlot.CHEST))) {
            return false;
        }
        if (this.legs.isPresent() && !this.legs.get().test(var1.getItemBySlot(EnumItemSlot.LEGS))) {
            return false;
        }
        if (this.feet.isPresent() && !this.feet.get().test(var1.getItemBySlot(EnumItemSlot.FEET))) {
            return false;
        }
        if (this.body.isPresent() && !this.body.get().test(var1.getItemBySlot(EnumItemSlot.BODY))) {
            return false;
        }
        if (this.mainhand.isPresent() && !this.mainhand.get().test(var1.getItemBySlot(EnumItemSlot.MAINHAND))) {
            return false;
        }
        return !this.offhand.isPresent() || this.offhand.get().test(var1.getItemBySlot(EnumItemSlot.OFFHAND));
    }

    public static class a {
        private Optional<CriterionConditionItem> head = Optional.empty();
        private Optional<CriterionConditionItem> chest = Optional.empty();
        private Optional<CriterionConditionItem> legs = Optional.empty();
        private Optional<CriterionConditionItem> feet = Optional.empty();
        private Optional<CriterionConditionItem> body = Optional.empty();
        private Optional<CriterionConditionItem> mainhand = Optional.empty();
        private Optional<CriterionConditionItem> offhand = Optional.empty();

        public static a equipment() {
            return new a();
        }

        public a head(CriterionConditionItem.a var0) {
            this.head = Optional.of(var0.build());
            return this;
        }

        public a chest(CriterionConditionItem.a var0) {
            this.chest = Optional.of(var0.build());
            return this;
        }

        public a legs(CriterionConditionItem.a var0) {
            this.legs = Optional.of(var0.build());
            return this;
        }

        public a feet(CriterionConditionItem.a var0) {
            this.feet = Optional.of(var0.build());
            return this;
        }

        public a body(CriterionConditionItem.a var0) {
            this.body = Optional.of(var0.build());
            return this;
        }

        public a mainhand(CriterionConditionItem.a var0) {
            this.mainhand = Optional.of(var0.build());
            return this;
        }

        public a offhand(CriterionConditionItem.a var0) {
            this.offhand = Optional.of(var0.build());
            return this;
        }

        public CriterionConditionEntityEquipment build() {
            return new CriterionConditionEntityEquipment(this.head, this.chest, this.legs, this.feet, this.body, this.mainhand, this.offhand);
        }
    }
}

