/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class SystemReport {
    public static final long BYTES_PER_MEBIBYTE = 0x100000L;
    private static final long ONE_GIGA = 1000000000L;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String OPERATING_SYSTEM = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String JAVA_VERSION = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String JAVA_VM_VERSION = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> entries = Maps.newLinkedHashMap();

    public SystemReport() {
        this.setDetail("Minecraft Version", SharedConstants.getCurrentVersion().getName());
        this.setDetail("Minecraft Version ID", SharedConstants.getCurrentVersion().getId());
        this.setDetail("Operating System", OPERATING_SYSTEM);
        this.setDetail("Java Version", JAVA_VERSION);
        this.setDetail("Java VM Version", JAVA_VM_VERSION);
        this.setDetail("Memory", () -> {
            Runtime var0 = Runtime.getRuntime();
            long var1 = var0.maxMemory();
            long var3 = var0.totalMemory();
            long var5 = var0.freeMemory();
            long var7 = var1 / 0x100000L;
            long var9 = var3 / 0x100000L;
            long var11 = var5 / 0x100000L;
            return var5 + " bytes (" + var11 + " MiB) / " + var3 + " bytes (" + var9 + " MiB) up to " + var1 + " bytes (" + var7 + " MiB)";
        });
        this.setDetail("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.ignoreErrors("hardware", () -> this.putHardware(new SystemInfo()));
        this.setDetail("JVM Flags", () -> {
            List var0 = SystemUtils.getVmArguments().collect(Collectors.toList());
            return String.format(Locale.ROOT, "%d total; %s", var0.size(), String.join((CharSequence)" ", var0));
        });
    }

    public void setDetail(String var0, String var1) {
        this.entries.put(var0, var1);
    }

    public void setDetail(String var0, Supplier<String> var1) {
        try {
            this.setDetail(var0, var1.get());
        }
        catch (Exception var2) {
            LOGGER.warn("Failed to get system info for {}", (Object)var0, (Object)var2);
            this.setDetail(var0, "ERR");
        }
    }

    private void putHardware(SystemInfo var0) {
        HardwareAbstractionLayer var1 = var0.getHardware();
        this.ignoreErrors("processor", () -> this.putProcessor(var1.getProcessor()));
        this.ignoreErrors("graphics", () -> this.putGraphics(var1.getGraphicsCards()));
        this.ignoreErrors("memory", () -> this.putMemory(var1.getMemory()));
        this.ignoreErrors("storage", this::putStorage);
    }

    private void ignoreErrors(String var0, Runnable var1) {
        try {
            var1.run();
        }
        catch (Throwable var2) {
            LOGGER.warn("Failed retrieving info for group {}", (Object)var0, (Object)var2);
        }
    }

    public static float sizeInMiB(long var0) {
        return (float)var0 / 1048576.0f;
    }

    private void putPhysicalMemory(List<PhysicalMemory> var0) {
        int var1 = 0;
        for (PhysicalMemory var3 : var0) {
            String var4 = String.format(Locale.ROOT, "Memory slot #%d ", var1++);
            this.setDetail(var4 + "capacity (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.sizeInMiB(var3.getCapacity()))));
            this.setDetail(var4 + "clockSpeed (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var3.getClockSpeed() / 1.0E9f)));
            this.setDetail(var4 + "type", () -> ((PhysicalMemory)var3).getMemoryType());
        }
    }

    private void putVirtualMemory(VirtualMemory var0) {
        this.setDetail("Virtual memory max (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.sizeInMiB(var0.getVirtualMax()))));
        this.setDetail("Virtual memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.sizeInMiB(var0.getVirtualInUse()))));
        this.setDetail("Swap memory total (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.sizeInMiB(var0.getSwapTotal()))));
        this.setDetail("Swap memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.sizeInMiB(var0.getSwapUsed()))));
    }

    private void putMemory(GlobalMemory var0) {
        this.ignoreErrors("physical memory", () -> this.putPhysicalMemory(var0.getPhysicalMemory()));
        this.ignoreErrors("virtual memory", () -> this.putVirtualMemory(var0.getVirtualMemory()));
    }

    private void putGraphics(List<GraphicsCard> var0) {
        int var1 = 0;
        for (GraphicsCard var3 : var0) {
            String var4 = String.format(Locale.ROOT, "Graphics card #%d ", var1++);
            this.setDetail(var4 + "name", () -> ((GraphicsCard)var3).getName());
            this.setDetail(var4 + "vendor", () -> ((GraphicsCard)var3).getVendor());
            this.setDetail(var4 + "VRAM (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.sizeInMiB(var3.getVRam()))));
            this.setDetail(var4 + "deviceId", () -> ((GraphicsCard)var3).getDeviceId());
            this.setDetail(var4 + "versionInfo", () -> ((GraphicsCard)var3).getVersionInfo());
        }
    }

    private void putProcessor(CentralProcessor var0) {
        CentralProcessor.ProcessorIdentifier var1 = var0.getProcessorIdentifier();
        this.setDetail("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)var1).getVendor());
        this.setDetail("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)var1).getName());
        this.setDetail("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)var1).getIdentifier());
        this.setDetail("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)var1).getMicroarchitecture());
        this.setDetail("Frequency (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var1.getVendorFreq() / 1.0E9f)));
        this.setDetail("Number of physical packages", () -> String.valueOf(var0.getPhysicalPackageCount()));
        this.setDetail("Number of physical CPUs", () -> String.valueOf(var0.getPhysicalProcessorCount()));
        this.setDetail("Number of logical CPUs", () -> String.valueOf(var0.getLogicalProcessorCount()));
    }

    private void putStorage() {
        this.putSpaceForProperty("jna.tmpdir");
        this.putSpaceForProperty("org.lwjgl.system.SharedLibraryExtractPath");
        this.putSpaceForProperty("io.netty.native.workdir");
        this.putSpaceForProperty("java.io.tmpdir");
        this.putSpaceForPath("workdir", () -> "");
    }

    private void putSpaceForProperty(String var0) {
        this.putSpaceForPath(var0, () -> System.getProperty(var0));
    }

    private void putSpaceForPath(String var0, Supplier<String> var1) {
        String var2 = "Space in storage for " + var0 + " (MiB)";
        try {
            String var3 = var1.get();
            if (var3 == null) {
                this.setDetail(var2, "<path not set>");
                return;
            }
            FileStore var4 = Files.getFileStore(Path.of(var3, new String[0]));
            this.setDetail(var2, String.format(Locale.ROOT, "available: %.2f, total: %.2f", Float.valueOf(SystemReport.sizeInMiB(var4.getUsableSpace())), Float.valueOf(SystemReport.sizeInMiB(var4.getTotalSpace()))));
        }
        catch (InvalidPathException var3) {
            LOGGER.warn("{} is not a path", (Object)var0, (Object)var3);
            this.setDetail(var2, "<invalid path>");
        }
        catch (Exception var3) {
            LOGGER.warn("Failed retrieving storage space for {}", (Object)var0, (Object)var3);
            this.setDetail(var2, "ERR");
        }
    }

    public void appendToCrashReportString(StringBuilder var0) {
        var0.append("-- ").append("System Details").append(" --\n");
        var0.append("Details:");
        this.entries.forEach((var1, var2) -> {
            var0.append("\n\t");
            var0.append((String)var1);
            var0.append(": ");
            var0.append((String)var2);
        });
    }

    public String toLineSeparatedString() {
        return this.entries.entrySet().stream().map(var0 -> (String)var0.getKey() + ": " + (String)var0.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

