/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public record TickListChunk<T>(T type, BlockPosition pos, int delay, TickListPriority priority) {
    private static final String TAG_ID = "i";
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_DELAY = "t";
    private static final String TAG_PRIORITY = "p";
    public static final Hash.Strategy<TickListChunk<?>> UNIQUE_TICK_HASH = new Hash.Strategy<TickListChunk<?>>(){

        public int hashCode(TickListChunk<?> var0) {
            return 31 * var0.pos().hashCode() + var0.type().hashCode();
        }

        public boolean equals(@Nullable TickListChunk<?> var0, @Nullable TickListChunk<?> var1) {
            if (var0 == var1) {
                return true;
            }
            if (var0 == null || var1 == null) {
                return false;
            }
            return var0.type() == var1.type() && var0.pos().equals(var1.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((TickListChunk)object, (TickListChunk)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((TickListChunk)object);
        }
    };

    public static <T> List<TickListChunk<T>> loadTickList(NBTTagList var0, Function<String, Optional<T>> var1, ChunkCoordIntPair var2) {
        ArrayList var32 = new ArrayList(var0.size());
        long var4 = var2.toLong();
        for (int var6 = 0; var6 < var0.size(); ++var6) {
            NBTTagCompound var7 = var0.getCompound(var6);
            TickListChunk.loadTick(var7, var1).ifPresent(var3 -> {
                if (ChunkCoordIntPair.asLong(var3.pos()) == var4) {
                    var32.add((TickListChunk)var3);
                }
            });
        }
        return var32;
    }

    public static <T> Optional<TickListChunk<T>> loadTick(NBTTagCompound var0, Function<String, Optional<T>> var12) {
        return var12.apply(var0.getString(TAG_ID)).map(var1 -> {
            BlockPosition var2 = new BlockPosition(var0.getInt(TAG_X), var0.getInt(TAG_Y), var0.getInt(TAG_Z));
            return new TickListChunk<Object>(var1, var2, var0.getInt(TAG_DELAY), TickListPriority.byValue(var0.getInt(TAG_PRIORITY)));
        });
    }

    private static NBTTagCompound saveTick(String var0, BlockPosition var1, int var2, TickListPriority var3) {
        NBTTagCompound var4 = new NBTTagCompound();
        var4.putString(TAG_ID, var0);
        var4.putInt(TAG_X, var1.getX());
        var4.putInt(TAG_Y, var1.getY());
        var4.putInt(TAG_Z, var1.getZ());
        var4.putInt(TAG_DELAY, var2);
        var4.putInt(TAG_PRIORITY, var3.getValue());
        return var4;
    }

    public NBTTagCompound save(Function<T, String> var0) {
        return TickListChunk.saveTick(var0.apply(this.type), this.pos, this.delay, this.priority);
    }

    public NextTickListEntry<T> unpack(long var0, long var2) {
        return new NextTickListEntry<T>(this.type, this.pos, var0 + (long)this.delay, this.priority, var2);
    }

    public static <T> TickListChunk<T> probe(T var0, BlockPosition var1) {
        return new TickListChunk<T>(var0, var1, 0, TickListPriority.NORMAL);
    }
}

