/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class VoxelShapeCollisionEntity
implements VoxelShapeCollision {
    protected static final VoxelShapeCollision EMPTY = new VoxelShapeCollisionEntity(false, -1.7976931348623157E308, ItemStack.EMPTY, var0 -> false, null){

        @Override
        public boolean isAbove(VoxelShape var0, BlockPosition var1, boolean var2) {
            return var2;
        }
    };
    private final boolean descending;
    private final double entityBottom;
    private final ItemStack heldItem;
    private final Predicate<Fluid> canStandOnFluid;
    @Nullable
    private final Entity entity;

    protected VoxelShapeCollisionEntity(boolean var0, double var1, ItemStack var3, Predicate<Fluid> var4, @Nullable Entity var5) {
        this.descending = var0;
        this.entityBottom = var1;
        this.heldItem = var3;
        this.canStandOnFluid = var4;
        this.entity = var5;
    }

    @Deprecated
    protected VoxelShapeCollisionEntity(Entity var02, boolean var1) {
        this(var02.isDescending(), var02.getY(), var02 instanceof EntityLiving ? ((EntityLiving)var02).getMainHandItem() : ItemStack.EMPTY, var1 ? var0 -> true : (var02 instanceof EntityLiving ? ((EntityLiving)var02)::canStandOnFluid : var0 -> false), var02);
    }

    @Override
    public boolean isHoldingItem(Item var0) {
        return this.heldItem.is(var0);
    }

    @Override
    public boolean canStandOnFluid(Fluid var0, Fluid var1) {
        return this.canStandOnFluid.test(var1) && !var0.getType().isSame(var1.getType());
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, ICollisionAccess var1, BlockPosition var2) {
        return var0.getCollisionShape(var1, var2, this);
    }

    @Override
    public boolean isDescending() {
        return this.descending;
    }

    @Override
    public boolean isAbove(VoxelShape var0, BlockPosition var1, boolean var2) {
        return this.entityBottom > (double)var1.getY() + var0.max(EnumDirection.EnumAxis.Y) - (double)1.0E-5f;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }
}

