/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ToggleTooltips
extends LootItemFunctionConditional {
    private static final Map<DataComponentType<?>, a<?>> TOGGLES = Stream.of(new a<ArmorTrim>(DataComponents.TRIM, ArmorTrim::withTooltip), new a<DyedItemColor>(DataComponents.DYED_COLOR, DyedItemColor::withTooltip), new a<ItemEnchantments>(DataComponents.ENCHANTMENTS, ItemEnchantments::withTooltip), new a<ItemEnchantments>(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments::withTooltip), new a<Unbreakable>(DataComponents.UNBREAKABLE, Unbreakable::withTooltip), new a<AdventureModePredicate>(DataComponents.CAN_BREAK, AdventureModePredicate::withTooltip), new a<AdventureModePredicate>(DataComponents.CAN_PLACE_ON, AdventureModePredicate::withTooltip), new a<ItemAttributeModifiers>(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers::withTooltip), new a<JukeboxPlayable>(DataComponents.JUKEBOX_PLAYABLE, JukeboxPlayable::withTooltip)).collect(Collectors.toMap(a::type, var0 -> var0));
    private static final Codec<a<?>> TOGGLE_CODEC = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().comapFlatMap(var0 -> {
        a<?> var1 = TOGGLES.get(var0);
        return var1 != null ? DataResult.success(var1) : DataResult.error(() -> "Can't toggle tooltip visiblity for " + String.valueOf(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((DataComponentType<?>)var0)));
    }, a::type);
    public static final MapCodec<ToggleTooltips> CODEC = RecordCodecBuilder.mapCodec(var02 -> ToggleTooltips.commonFields(var02).and((App)Codec.unboundedMap(TOGGLE_CODEC, (Codec)Codec.BOOL).fieldOf("toggles").forGetter(var0 -> var0.values)).apply((Applicative)var02, ToggleTooltips::new));
    private final Map<a<?>, Boolean> values;

    private ToggleTooltips(List<LootItemCondition> var0, Map<a<?>, Boolean> var1) {
        super(var0);
        this.values = var1;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var12) {
        this.values.forEach((var1, var2) -> var1.applyIfPresent(var0, (boolean)var2));
        return var0;
    }

    public LootItemFunctionType<ToggleTooltips> getType() {
        return LootItemFunctions.TOGGLE_TOOLTIPS;
    }

    record a<T>(DataComponentType<T> type, b<T> setter) {
        public void applyIfPresent(ItemStack var0, boolean var1) {
            T var2 = var0.get(this.type);
            if (var2 != null) {
                var0.set(this.type, this.setter.withTooltip(var2, var1));
            }
        }
    }

    @FunctionalInterface
    static interface b<T> {
        public T withTooltip(T var1, boolean var2);
    }
}

