/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetTable
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionSetTable> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionSetTable.commonFields(var02).and(var02.group((App)ResourceKey.codec(Registries.LOOT_TABLE).fieldOf("name").forGetter(var0 -> var0.name), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(var0 -> var0.seed), (App)BuiltInRegistries.BLOCK_ENTITY_TYPE.holderByNameCodec().fieldOf("type").forGetter(var0 -> var0.type))).apply((Applicative)var02, LootItemFunctionSetTable::new));
    private final ResourceKey<LootTable> name;
    private final long seed;
    private final Holder<TileEntityTypes<?>> type;

    private LootItemFunctionSetTable(List<LootItemCondition> var0, ResourceKey<LootTable> var1, long var2, Holder<TileEntityTypes<?>> var4) {
        super(var0);
        this.name = var1;
        this.seed = var2;
        this.type = var4;
    }

    public LootItemFunctionType<LootItemFunctionSetTable> getType() {
        return LootItemFunctions.SET_LOOT_TABLE;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (var0.isEmpty()) {
            return var0;
        }
        var0.set(DataComponents.CONTAINER_LOOT, new SeededContainerLoot(this.name, this.seed));
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        if (!var0.allowsReferences()) {
            var0.reportProblem("Uses reference to " + String.valueOf(this.name.location()) + ", but references are not allowed");
            return;
        }
        if (var0.resolver().get(this.name).isEmpty()) {
            var0.reportProblem("Missing loot table used for container: " + String.valueOf(this.name.location()));
        }
    }

    public static LootItemFunctionConditional.a<?> withLootTable(TileEntityTypes<?> var0, ResourceKey<LootTable> var1) {
        return LootItemFunctionSetTable.simpleBuilder(var2 -> new LootItemFunctionSetTable((List<LootItemCondition>)var2, var1, 0L, (Holder<TileEntityTypes<?>>)var0.builtInRegistryHolder()));
    }

    public static LootItemFunctionConditional.a<?> withLootTable(TileEntityTypes<?> var0, ResourceKey<LootTable> var1, long var2) {
        return LootItemFunctionSetTable.simpleBuilder(var4 -> new LootItemFunctionSetTable((List<LootItemCondition>)var4, var1, var2, (Holder<TileEntityTypes<?>>)var0.builtInRegistryHolder()));
    }
}

