/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootItemFunctionSetAttribute
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionSetAttribute> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionSetAttribute.commonFields(var02).and(var02.group((App)b.CODEC.listOf().fieldOf("modifiers").forGetter(var0 -> var0.modifiers), (App)Codec.BOOL.optionalFieldOf("replace", (Object)true).forGetter(var0 -> var0.replace))).apply((Applicative)var02, LootItemFunctionSetAttribute::new));
    private final List<b> modifiers;
    private final boolean replace;

    LootItemFunctionSetAttribute(List<LootItemCondition> var0, List<b> var1, boolean var2) {
        super(var0);
        this.modifiers = List.copyOf(var1);
        this.replace = var2;
    }

    public LootItemFunctionType<LootItemFunctionSetAttribute> getType() {
        return LootItemFunctions.SET_ATTRIBUTES;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(var0 -> var0.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var12) {
        if (this.replace) {
            var0.set(DataComponents.ATTRIBUTE_MODIFIERS, this.updateModifiers(var12, ItemAttributeModifiers.EMPTY));
        } else {
            var0.update(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY, var1 -> this.updateModifiers(var12, (ItemAttributeModifiers)var1));
        }
        return var0;
    }

    private ItemAttributeModifiers updateModifiers(LootTableInfo var0, ItemAttributeModifiers var1) {
        RandomSource var2 = var0.getRandom();
        for (b var4 : this.modifiers) {
            EquipmentSlotGroup var5 = SystemUtils.getRandom(var4.slots, var2);
            var1 = var1.withModifierAdded(var4.attribute, new AttributeModifier(var4.id, var4.amount.getFloat(var0), var4.operation), var5);
        }
        return var1;
    }

    public static c modifier(MinecraftKey var0, Holder<AttributeBase> var1, AttributeModifier.Operation var2, NumberProvider var3) {
        return new c(var0, var1, var2, var3);
    }

    public static a setAttributes() {
        return new a();
    }

    static final class b
    extends Record {
        final MinecraftKey id;
        final Holder<AttributeBase> attribute;
        final AttributeModifier.Operation operation;
        final NumberProvider amount;
        final List<EquipmentSlotGroup> slots;
        private static final Codec<List<EquipmentSlotGroup>> SLOTS_CODEC = ExtraCodecs.nonEmptyList(Codec.either(EquipmentSlotGroup.CODEC, (Codec)EquipmentSlotGroup.CODEC.listOf()).xmap(var0 -> (List)var0.map(List::of, Function.identity()), var0 -> var0.size() == 1 ? Either.left((Object)((EquipmentSlotGroup)var0.getFirst())) : Either.right((Object)var0)));
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("id").forGetter(b::id), (App)AttributeBase.CODEC.fieldOf("attribute").forGetter(b::attribute), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(b::operation), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(b::amount), (App)SLOTS_CODEC.fieldOf("slot").forGetter(b::slots)).apply((Applicative)var0, b::new));

        b(MinecraftKey var0, Holder<AttributeBase> var1, AttributeModifier.Operation var2, NumberProvider var3, List<EquipmentSlotGroup> var4) {
            this.id = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
            this.slots = var4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;attribute;operation;amount;slots", "id", "attribute", "operation", "amount", "slots"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;attribute;operation;amount;slots", "id", "attribute", "operation", "amount", "slots"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;attribute;operation;amount;slots", "id", "attribute", "operation", "amount", "slots"}, this, var0);
        }

        public MinecraftKey id() {
            return this.id;
        }

        public Holder<AttributeBase> attribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation operation() {
            return this.operation;
        }

        public NumberProvider amount() {
            return this.amount;
        }

        public List<EquipmentSlotGroup> slots() {
            return this.slots;
        }
    }

    public static class c {
        private final MinecraftKey id;
        private final Holder<AttributeBase> attribute;
        private final AttributeModifier.Operation operation;
        private final NumberProvider amount;
        private final Set<EquipmentSlotGroup> slots = EnumSet.noneOf(EquipmentSlotGroup.class);

        public c(MinecraftKey var0, Holder<AttributeBase> var1, AttributeModifier.Operation var2, NumberProvider var3) {
            this.id = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
        }

        public c forSlot(EquipmentSlotGroup var0) {
            this.slots.add(var0);
            return this;
        }

        public b build() {
            return new b(this.id, this.attribute, this.operation, this.amount, List.copyOf(this.slots));
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final boolean replace;
        private final List<b> modifiers = Lists.newArrayList();

        public a(boolean var0) {
            this.replace = var0;
        }

        public a() {
            this(false);
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a withModifier(c var0) {
            this.modifiers.add(var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetAttribute(this.getConditions(), this.modifiers, this.replace);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

