/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<FunctionReference> CODEC = RecordCodecBuilder.mapCodec(var02 -> FunctionReference.commonFields(var02).and((App)ResourceKey.codec(Registries.ITEM_MODIFIER).fieldOf("name").forGetter(var0 -> var0.name)).apply((Applicative)var02, FunctionReference::new));
    private final ResourceKey<LootItemFunction> name;

    private FunctionReference(List<LootItemCondition> var0, ResourceKey<LootItemFunction> var1) {
        super(var0);
        this.name = var1;
    }

    public LootItemFunctionType<FunctionReference> getType() {
        return LootItemFunctions.REFERENCE;
    }

    @Override
    public void validate(LootCollector var0) {
        if (!var0.allowsReferences()) {
            var0.reportProblem("Uses reference to " + String.valueOf(this.name.location()) + ", but references are not allowed");
            return;
        }
        if (var0.hasVisitedElement(this.name)) {
            var0.reportProblem("Function " + String.valueOf(this.name.location()) + " is recursively called");
            return;
        }
        super.validate(var0);
        var0.resolver().get(this.name).ifPresentOrElse(var1 -> ((LootItemFunction)var1.value()).validate(var0.enterElement(".{" + String.valueOf(this.name.location()) + "}", this.name)), () -> var0.reportProblem("Unknown function table called " + String.valueOf(this.name.location())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        LootItemFunction var2 = var1.getResolver().get(this.name).map(Holder::value).orElse(null);
        if (var2 == null) {
            LOGGER.warn("Unknown function: {}", (Object)this.name.location());
            return var0;
        }
        LootTableInfo.c<LootItemFunction> var3 = LootTableInfo.createVisitedEntry(var2);
        if (var1.pushVisitedElement(var3)) {
            try {
                ItemStack itemStack = (ItemStack)var2.apply(var0, var1);
                return itemStack;
            }
            finally {
                var1.popVisitedElement(var3);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return var0;
    }

    public static LootItemFunctionConditional.a<?> functionReference(ResourceKey<LootItemFunction> var0) {
        return FunctionReference.simpleBuilder(var1 -> new FunctionReference((List<LootItemCondition>)var1, var0));
    }
}

