/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<String, Optional<PersistentBase>> cache = new HashMap<String, Optional<PersistentBase>>();
    private final DataFixer fixerUpper;
    private final HolderLookup.a registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public WorldPersistentData(Path var0, DataFixer var1, HolderLookup.a var2) {
        this.fixerUpper = var1;
        this.dataFolder = var0;
        this.registries = var2;
    }

    private Path getDataFile(String var0) {
        return this.dataFolder.resolve(var0 + ".dat");
    }

    public <T extends PersistentBase> T computeIfAbsent(PersistentBase.a<T> var0, String var1) {
        T var2 = this.get(var0, var1);
        if (var2 != null) {
            return var2;
        }
        PersistentBase var3 = (PersistentBase)var0.constructor().get();
        this.set(var1, var3);
        return (T)var3;
    }

    @Nullable
    public <T extends PersistentBase> T get(PersistentBase.a<T> var0, String var1) {
        Optional<PersistentBase> var2 = this.cache.get(var1);
        if (var2 == null) {
            var2 = Optional.ofNullable(this.readSavedData(var0.deserializer(), var0.type(), var1));
            this.cache.put(var1, var2);
        }
        return (T)((PersistentBase)var2.orElse(null));
    }

    @Nullable
    private <T extends PersistentBase> T readSavedData(BiFunction<NBTTagCompound, HolderLookup.a, T> var0, DataFixTypes var1, String var2) {
        try {
            Path var3 = this.getDataFile(var2);
            if (Files.exists(var3, new LinkOption[0])) {
                NBTTagCompound var4 = this.readTagFromDisk(var2, var1, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((PersistentBase)var0.apply(var4.getCompound("data"), this.registries));
            }
        }
        catch (Exception var3) {
            LOGGER.error("Error loading saved data: {}", (Object)var2, (Object)var3);
        }
        return null;
    }

    public void set(String var0, PersistentBase var1) {
        this.cache.put(var0, Optional.of(var1));
        var1.setDirty();
    }

    public NBTTagCompound readTagFromDisk(String var0, DataFixTypes var1, int var2) throws IOException {
        try (InputStream var3 = Files.newInputStream(this.getDataFile(var0), new OpenOption[0]);){
            NBTTagCompound nBTTagCompound;
            try (PushbackInputStream var4 = new PushbackInputStream(new FastBufferedInputStream(var3), 2);){
                NBTTagCompound var5;
                if (this.isGzip(var4)) {
                    var5 = NBTCompressedStreamTools.readCompressed(var4, NBTReadLimiter.unlimitedHeap());
                } else {
                    try (DataInputStream var6 = new DataInputStream(var4);){
                        var5 = NBTCompressedStreamTools.read(var6);
                    }
                }
                int var6 = GameProfileSerializer.getDataVersion(var5, 1343);
                nBTTagCompound = var1.update(this.fixerUpper, var5, var6, var2);
            }
            return nBTTagCompound;
        }
    }

    private boolean isGzip(PushbackInputStream var0) throws IOException {
        int var4;
        byte[] var1 = new byte[2];
        boolean var2 = false;
        int var3 = var0.read(var1, 0, 2);
        if (var3 == 2 && (var4 = (var1[1] & 0xFF) << 8 | var1[0] & 0xFF) == 35615) {
            var2 = true;
        }
        if (var3 != 0) {
            var0.unread(var1, 0, var3);
        }
        return var2;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<Path, NBTTagCompound> var0 = this.collectDirtyTagsToSave();
        if (var0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.pendingWriteFuture = this.pendingWriteFuture.thenCompose(var1 -> CompletableFuture.allOf((CompletableFuture[])var0.entrySet().stream().map(var0 -> WorldPersistentData.tryWriteAsync((Path)var0.getKey(), (NBTTagCompound)var0.getValue())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<Path, NBTTagCompound> collectDirtyTagsToSave() {
        Object2ObjectArrayMap var0 = new Object2ObjectArrayMap();
        this.cache.forEach((arg_0, arg_1) -> this.a((Map)var0, arg_0, arg_1));
        return var0;
    }

    private static CompletableFuture<Void> tryWriteAsync(Path var0, NBTTagCompound var1) {
        return CompletableFuture.runAsync(() -> {
            try {
                NBTCompressedStreamTools.writeCompressed(var1, var0);
            }
            catch (IOException var2) {
                LOGGER.error("Could not save data to {}", (Object)var0.getFileName(), (Object)var2);
            }
        }, SystemUtils.ioPool());
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void a(Map var0, String var1, Optional var22) {
        var22.filter(PersistentBase::isDirty).ifPresent(var2 -> var0.put(this.getDataFile(var1), var2.save(this.registries)));
    }
}

