/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class WorldNBTStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public WorldNBTStorage(Convertable.ConversionSession var0, DataFixer var1) {
        this.fixerUpper = var1;
        this.playerDir = var0.getLevelPath(SavedFile.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(EntityHuman var0) {
        try {
            NBTTagCompound var1 = var0.saveWithoutId(new NBTTagCompound());
            Path var2 = this.playerDir.toPath();
            Path var3 = Files.createTempFile(var2, var0.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            NBTCompressedStreamTools.writeCompressed(var1, var3);
            Path var4 = var2.resolve(var0.getStringUUID() + ".dat");
            Path var5 = var2.resolve(var0.getStringUUID() + ".dat_old");
            SystemUtils.safeReplaceFile(var4, var3, var5);
        }
        catch (Exception var1) {
            LOGGER.warn("Failed to save player data for {}", (Object)var0.getName().getString());
        }
    }

    private void backup(EntityHuman var0, String var1) {
        Path var2 = this.playerDir.toPath();
        Path var3 = var2.resolve(var0.getStringUUID() + var1);
        Path var4 = var2.resolve(var0.getStringUUID() + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + var1);
        if (!Files.isRegularFile(var3, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy(var3, var4, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception var5) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)var0.getName().getString(), (Object)var5);
        }
    }

    private Optional<NBTTagCompound> load(EntityHuman var0, String var1) {
        File var2 = new File(this.playerDir, var0.getStringUUID() + var1);
        if (var2.exists() && var2.isFile()) {
            try {
                return Optional.of(NBTCompressedStreamTools.readCompressed(var2.toPath(), NBTReadLimiter.unlimitedHeap()));
            }
            catch (Exception var3) {
                LOGGER.warn("Failed to load player data for {}", (Object)var0.getName().getString());
            }
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> load(EntityHuman var0) {
        Optional<NBTTagCompound> var12 = this.load(var0, ".dat");
        if (var12.isEmpty()) {
            this.backup(var0, ".dat");
        }
        return var12.or(() -> this.load(var0, ".dat_old")).map(var1 -> {
            int var2 = GameProfileSerializer.getDataVersion(var1, -1);
            var1 = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (NBTTagCompound)var1, var2);
            var0.load((NBTTagCompound)var1);
            return var1;
        });
    }
}

