/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTables;

public class WoodlandMansionPieces {
    public static void generateMansion(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, List<i> var3, RandomSource var4) {
        c var5 = new c(var4);
        d var6 = new d(var0, var4);
        var6.createMansion(var1, var2, var3, var5);
    }

    static class c {
        private static final int DEFAULT_SIZE = 11;
        private static final int CLEAR = 0;
        private static final int CORRIDOR = 1;
        private static final int ROOM = 2;
        private static final int START_ROOM = 3;
        private static final int TEST_ROOM = 4;
        private static final int BLOCKED = 5;
        private static final int ROOM_1x1 = 65536;
        private static final int ROOM_1x2 = 131072;
        private static final int ROOM_2x2 = 262144;
        private static final int ROOM_ORIGIN_FLAG = 0x100000;
        private static final int ROOM_DOOR_FLAG = 0x200000;
        private static final int ROOM_STAIRS_FLAG = 0x400000;
        private static final int ROOM_CORRIDOR_FLAG = 0x800000;
        private static final int ROOM_TYPE_MASK = 983040;
        private static final int ROOM_ID_MASK = 65535;
        private final RandomSource random;
        final g baseGrid;
        final g thirdFloorGrid;
        final g[] floorRooms;
        final int entranceX;
        final int entranceY;

        public c(RandomSource var0) {
            this.random = var0;
            int var1 = 11;
            this.entranceX = 7;
            this.entranceY = 4;
            this.baseGrid = new g(11, 11, 5);
            this.baseGrid.set(this.entranceX, this.entranceY, this.entranceX + 1, this.entranceY + 1, 3);
            this.baseGrid.set(this.entranceX - 1, this.entranceY, this.entranceX - 1, this.entranceY + 1, 2);
            this.baseGrid.set(this.entranceX + 2, this.entranceY - 2, this.entranceX + 3, this.entranceY + 3, 5);
            this.baseGrid.set(this.entranceX + 1, this.entranceY - 2, this.entranceX + 1, this.entranceY - 1, 1);
            this.baseGrid.set(this.entranceX + 1, this.entranceY + 2, this.entranceX + 1, this.entranceY + 3, 1);
            this.baseGrid.set(this.entranceX - 1, this.entranceY - 1, 1);
            this.baseGrid.set(this.entranceX - 1, this.entranceY + 2, 1);
            this.baseGrid.set(0, 0, 11, 1, 5);
            this.baseGrid.set(0, 9, 11, 11, 5);
            this.recursiveCorridor(this.baseGrid, this.entranceX, this.entranceY - 2, EnumDirection.WEST, 6);
            this.recursiveCorridor(this.baseGrid, this.entranceX, this.entranceY + 3, EnumDirection.WEST, 6);
            this.recursiveCorridor(this.baseGrid, this.entranceX - 2, this.entranceY - 1, EnumDirection.WEST, 3);
            this.recursiveCorridor(this.baseGrid, this.entranceX - 2, this.entranceY + 2, EnumDirection.WEST, 3);
            while (this.cleanEdges(this.baseGrid)) {
            }
            this.floorRooms = new g[3];
            this.floorRooms[0] = new g(11, 11, 5);
            this.floorRooms[1] = new g(11, 11, 5);
            this.floorRooms[2] = new g(11, 11, 5);
            this.identifyRooms(this.baseGrid, this.floorRooms[0]);
            this.identifyRooms(this.baseGrid, this.floorRooms[1]);
            this.floorRooms[0].set(this.entranceX + 1, this.entranceY, this.entranceX + 1, this.entranceY + 1, 0x800000);
            this.floorRooms[1].set(this.entranceX + 1, this.entranceY, this.entranceX + 1, this.entranceY + 1, 0x800000);
            this.thirdFloorGrid = new g(this.baseGrid.width, this.baseGrid.height, 5);
            this.setupThirdFloor();
            this.identifyRooms(this.thirdFloorGrid, this.floorRooms[2]);
        }

        public static boolean isHouse(g var0, int var1, int var2) {
            int var3 = var0.get(var1, var2);
            return var3 == 1 || var3 == 2 || var3 == 3 || var3 == 4;
        }

        public boolean isRoomId(g var0, int var1, int var2, int var3, int var4) {
            return (this.floorRooms[var3].get(var1, var2) & 0xFFFF) == var4;
        }

        @Nullable
        public EnumDirection get1x2RoomDirection(g var0, int var1, int var2, int var3, int var4) {
            for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                if (!this.isRoomId(var0, var1 + var6.getStepX(), var2 + var6.getStepZ(), var3, var4)) continue;
                return var6;
            }
            return null;
        }

        private void recursiveCorridor(g var0, int var1, int var2, EnumDirection var3, int var4) {
            EnumDirection var6;
            if (var4 <= 0) {
                return;
            }
            var0.set(var1, var2, 1);
            var0.setif(var1 + var3.getStepX(), var2 + var3.getStepZ(), 0, 1);
            for (int var5 = 0; var5 < 8; ++var5) {
                var6 = EnumDirection.from2DDataValue(this.random.nextInt(4));
                if (var6 == var3.getOpposite() || var6 == EnumDirection.EAST && this.random.nextBoolean()) continue;
                int var7 = var1 + var3.getStepX();
                int var8 = var2 + var3.getStepZ();
                if (var0.get(var7 + var6.getStepX(), var8 + var6.getStepZ()) != 0 || var0.get(var7 + var6.getStepX() * 2, var8 + var6.getStepZ() * 2) != 0) continue;
                this.recursiveCorridor(var0, var1 + var3.getStepX() + var6.getStepX(), var2 + var3.getStepZ() + var6.getStepZ(), var6, var4 - 1);
                break;
            }
            EnumDirection var5 = var3.getClockWise();
            var6 = var3.getCounterClockWise();
            var0.setif(var1 + var5.getStepX(), var2 + var5.getStepZ(), 0, 2);
            var0.setif(var1 + var6.getStepX(), var2 + var6.getStepZ(), 0, 2);
            var0.setif(var1 + var3.getStepX() + var5.getStepX(), var2 + var3.getStepZ() + var5.getStepZ(), 0, 2);
            var0.setif(var1 + var3.getStepX() + var6.getStepX(), var2 + var3.getStepZ() + var6.getStepZ(), 0, 2);
            var0.setif(var1 + var3.getStepX() * 2, var2 + var3.getStepZ() * 2, 0, 2);
            var0.setif(var1 + var5.getStepX() * 2, var2 + var5.getStepZ() * 2, 0, 2);
            var0.setif(var1 + var6.getStepX() * 2, var2 + var6.getStepZ() * 2, 0, 2);
        }

        private boolean cleanEdges(g var0) {
            boolean var1 = false;
            for (int var2 = 0; var2 < var0.height; ++var2) {
                for (int var3 = 0; var3 < var0.width; ++var3) {
                    if (var0.get(var3, var2) != 0) continue;
                    int var4 = 0;
                    var4 += c.isHouse(var0, var3 + 1, var2) ? 1 : 0;
                    var4 += c.isHouse(var0, var3 - 1, var2) ? 1 : 0;
                    var4 += c.isHouse(var0, var3, var2 + 1) ? 1 : 0;
                    if ((var4 += c.isHouse(var0, var3, var2 - 1) ? 1 : 0) >= 3) {
                        var0.set(var3, var2, 2);
                        var1 = true;
                        continue;
                    }
                    if (var4 != 2) continue;
                    int var5 = 0;
                    var5 += c.isHouse(var0, var3 + 1, var2 + 1) ? 1 : 0;
                    var5 += c.isHouse(var0, var3 - 1, var2 + 1) ? 1 : 0;
                    var5 += c.isHouse(var0, var3 + 1, var2 - 1) ? 1 : 0;
                    if ((var5 += c.isHouse(var0, var3 - 1, var2 - 1) ? 1 : 0) > 1) continue;
                    var0.set(var3, var2, 2);
                    var1 = true;
                }
            }
            return var1;
        }

        private void setupThirdFloor() {
            int var5;
            int var3;
            ArrayList var0 = Lists.newArrayList();
            g var1 = this.floorRooms[1];
            for (int var2 = 0; var2 < this.thirdFloorGrid.height; ++var2) {
                for (var3 = 0; var3 < this.thirdFloorGrid.width; ++var3) {
                    int var4 = var1.get(var3, var2);
                    var5 = var4 & 0xF0000;
                    if (var5 != 131072 || (var4 & 0x200000) != 0x200000) continue;
                    var0.add(new Tuple<Integer, Integer>(var3, var2));
                }
            }
            if (var0.isEmpty()) {
                this.thirdFloorGrid.set(0, 0, this.thirdFloorGrid.width, this.thirdFloorGrid.height, 5);
                return;
            }
            Tuple var2 = (Tuple)var0.get(this.random.nextInt(var0.size()));
            var3 = var1.get((Integer)var2.getA(), (Integer)var2.getB());
            var1.set((Integer)var2.getA(), (Integer)var2.getB(), var3 | 0x400000);
            EnumDirection var4 = this.get1x2RoomDirection(this.baseGrid, (Integer)var2.getA(), (Integer)var2.getB(), 1, var3 & 0xFFFF);
            var5 = (Integer)var2.getA() + var4.getStepX();
            int var6 = (Integer)var2.getB() + var4.getStepZ();
            for (int var7 = 0; var7 < this.thirdFloorGrid.height; ++var7) {
                for (int var8 = 0; var8 < this.thirdFloorGrid.width; ++var8) {
                    if (!c.isHouse(this.baseGrid, var8, var7)) {
                        this.thirdFloorGrid.set(var8, var7, 5);
                        continue;
                    }
                    if (var8 == (Integer)var2.getA() && var7 == (Integer)var2.getB()) {
                        this.thirdFloorGrid.set(var8, var7, 3);
                        continue;
                    }
                    if (var8 != var5 || var7 != var6) continue;
                    this.thirdFloorGrid.set(var8, var7, 3);
                    this.floorRooms[2].set(var8, var7, 0x800000);
                }
            }
            ArrayList var7 = Lists.newArrayList();
            for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                if (this.thirdFloorGrid.get(var5 + var9.getStepX(), var6 + var9.getStepZ()) != 0) continue;
                var7.add(var9);
            }
            if (var7.isEmpty()) {
                this.thirdFloorGrid.set(0, 0, this.thirdFloorGrid.width, this.thirdFloorGrid.height, 5);
                var1.set((Integer)var2.getA(), (Integer)var2.getB(), var3);
                return;
            }
            EnumDirection var8 = (EnumDirection)var7.get(this.random.nextInt(var7.size()));
            this.recursiveCorridor(this.thirdFloorGrid, var5 + var8.getStepX(), var6 + var8.getStepZ(), var8, 4);
            while (this.cleanEdges(this.thirdFloorGrid)) {
            }
        }

        private void identifyRooms(g var0, g var1) {
            int var3;
            ObjectArrayList var2 = new ObjectArrayList();
            for (var3 = 0; var3 < var0.height; ++var3) {
                for (int var4 = 0; var4 < var0.width; ++var4) {
                    if (var0.get(var4, var3) != 2) continue;
                    var2.add(new Tuple<Integer, Integer>(var4, var3));
                }
            }
            SystemUtils.shuffle(var2, this.random);
            var3 = 10;
            for (Tuple var5 : var2) {
                int var7;
                int var6 = (Integer)var5.getA();
                if (var1.get(var6, var7 = ((Integer)var5.getB()).intValue()) != 0) continue;
                int var8 = var6;
                int var9 = var6;
                int var10 = var7;
                int var11 = var7;
                int var12 = 65536;
                if (var1.get(var6 + 1, var7) == 0 && var1.get(var6, var7 + 1) == 0 && var1.get(var6 + 1, var7 + 1) == 0 && var0.get(var6 + 1, var7) == 2 && var0.get(var6, var7 + 1) == 2 && var0.get(var6 + 1, var7 + 1) == 2) {
                    ++var9;
                    ++var11;
                    var12 = 262144;
                } else if (var1.get(var6 - 1, var7) == 0 && var1.get(var6, var7 + 1) == 0 && var1.get(var6 - 1, var7 + 1) == 0 && var0.get(var6 - 1, var7) == 2 && var0.get(var6, var7 + 1) == 2 && var0.get(var6 - 1, var7 + 1) == 2) {
                    --var8;
                    ++var11;
                    var12 = 262144;
                } else if (var1.get(var6 - 1, var7) == 0 && var1.get(var6, var7 - 1) == 0 && var1.get(var6 - 1, var7 - 1) == 0 && var0.get(var6 - 1, var7) == 2 && var0.get(var6, var7 - 1) == 2 && var0.get(var6 - 1, var7 - 1) == 2) {
                    --var8;
                    --var10;
                    var12 = 262144;
                } else if (var1.get(var6 + 1, var7) == 0 && var0.get(var6 + 1, var7) == 2) {
                    ++var9;
                    var12 = 131072;
                } else if (var1.get(var6, var7 + 1) == 0 && var0.get(var6, var7 + 1) == 2) {
                    ++var11;
                    var12 = 131072;
                } else if (var1.get(var6 - 1, var7) == 0 && var0.get(var6 - 1, var7) == 2) {
                    --var8;
                    var12 = 131072;
                } else if (var1.get(var6, var7 - 1) == 0 && var0.get(var6, var7 - 1) == 2) {
                    --var10;
                    var12 = 131072;
                }
                int var13 = this.random.nextBoolean() ? var8 : var9;
                int var14 = this.random.nextBoolean() ? var10 : var11;
                int var15 = 0x200000;
                if (!var0.edgesTo(var13, var14, 1)) {
                    var13 = var13 == var8 ? var9 : var8;
                    int n2 = var14 = var14 == var10 ? var11 : var10;
                    if (!var0.edgesTo(var13, var14, 1)) {
                        int n3 = var14 = var14 == var10 ? var11 : var10;
                        if (!var0.edgesTo(var13, var14, 1)) {
                            var13 = var13 == var8 ? var9 : var8;
                            int n4 = var14 = var14 == var10 ? var11 : var10;
                            if (!var0.edgesTo(var13, var14, 1)) {
                                var15 = 0;
                                var13 = var8;
                                var14 = var10;
                            }
                        }
                    }
                }
                for (int var16 = var10; var16 <= var11; ++var16) {
                    for (int var17 = var8; var17 <= var9; ++var17) {
                        if (var17 == var13 && var16 == var14) {
                            var1.set(var17, var16, 0x100000 | var15 | var12 | var3);
                            continue;
                        }
                        var1.set(var17, var16, var12 | var3);
                    }
                }
                ++var3;
            }
        }
    }

    static class d {
        private final StructureTemplateManager structureTemplateManager;
        private final RandomSource random;
        private int startX;
        private int startY;

        public d(StructureTemplateManager var0, RandomSource var1) {
            this.structureTemplateManager = var0;
            this.random = var1;
        }

        public void createMansion(BlockPosition var0, EnumBlockRotation var1, List<i> var2, c var3) {
            int var13;
            e var4 = new e();
            var4.position = var0;
            var4.rotation = var1;
            var4.wallType = "wall_flat";
            e var5 = new e();
            this.entrance(var2, var4);
            var5.position = var4.position.above(8);
            var5.rotation = var4.rotation;
            var5.wallType = "wall_window";
            if (!var2.isEmpty()) {
                // empty if block
            }
            g var6 = var3.baseGrid;
            g var7 = var3.thirdFloorGrid;
            this.startX = var3.entranceX + 1;
            this.startY = var3.entranceY + 1;
            int var8 = var3.entranceX + 1;
            int var9 = var3.entranceY;
            this.traverseOuterWalls(var2, var4, var6, EnumDirection.SOUTH, this.startX, this.startY, var8, var9);
            this.traverseOuterWalls(var2, var5, var6, EnumDirection.SOUTH, this.startX, this.startY, var8, var9);
            e var10 = new e();
            var10.position = var4.position.above(19);
            var10.rotation = var4.rotation;
            var10.wallType = "wall_window";
            boolean var11 = false;
            for (int var12 = 0; var12 < var7.height && !var11; ++var12) {
                for (var13 = var7.width - 1; var13 >= 0 && !var11; --var13) {
                    if (!c.isHouse(var7, var13, var12)) continue;
                    var10.position = var10.position.relative(var1.rotate(EnumDirection.SOUTH), 8 + (var12 - this.startY) * 8);
                    var10.position = var10.position.relative(var1.rotate(EnumDirection.EAST), (var13 - this.startX) * 8);
                    this.traverseWallPiece(var2, var10);
                    this.traverseOuterWalls(var2, var10, var7, EnumDirection.SOUTH, var13, var12, var13, var12);
                    var11 = true;
                }
            }
            this.createRoof(var2, var0.above(16), var1, var6, var7);
            this.createRoof(var2, var0.above(27), var1, var7, null);
            if (!var2.isEmpty()) {
                // empty if block
            }
            b[] var12 = new b[]{new a(), new f(), new h()};
            for (var13 = 0; var13 < 3; ++var13) {
                Object var21;
                BlockPosition var14 = var0.above(8 * var13 + (var13 == 2 ? 3 : 0));
                g var15 = var3.floorRooms[var13];
                g var16 = var13 == 2 ? var7 : var6;
                String var17 = var13 == 0 ? "carpet_south_1" : "carpet_south_2";
                String var18 = var13 == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int var19 = 0; var19 < var16.height; ++var19) {
                    for (int var20 = 0; var20 < var16.width; ++var20) {
                        if (var16.get(var20, var19) != 1) continue;
                        var21 = var14.relative(var1.rotate(EnumDirection.SOUTH), 8 + (var19 - this.startY) * 8);
                        var21 = ((BlockPosition)var21).relative(var1.rotate(EnumDirection.EAST), (var20 - this.startX) * 8);
                        var2.add(new i(this.structureTemplateManager, "corridor_floor", (BlockPosition)var21, var1));
                        if (var16.get(var20, var19 - 1) == 1 || (var15.get(var20, var19 - 1) & 0x800000) == 0x800000) {
                            var2.add(new i(this.structureTemplateManager, "carpet_north", ((BlockPosition)var21).relative(var1.rotate(EnumDirection.EAST), 1).above(), var1));
                        }
                        if (var16.get(var20 + 1, var19) == 1 || (var15.get(var20 + 1, var19) & 0x800000) == 0x800000) {
                            var2.add(new i(this.structureTemplateManager, "carpet_east", ((BlockPosition)var21).relative(var1.rotate(EnumDirection.SOUTH), 1).relative(var1.rotate(EnumDirection.EAST), 5).above(), var1));
                        }
                        if (var16.get(var20, var19 + 1) == 1 || (var15.get(var20, var19 + 1) & 0x800000) == 0x800000) {
                            var2.add(new i(this.structureTemplateManager, var17, ((BlockPosition)var21).relative(var1.rotate(EnumDirection.SOUTH), 5).relative(var1.rotate(EnumDirection.WEST), 1), var1));
                        }
                        if (var16.get(var20 - 1, var19) != 1 && (var15.get(var20 - 1, var19) & 0x800000) != 0x800000) continue;
                        var2.add(new i(this.structureTemplateManager, var18, ((BlockPosition)var21).relative(var1.rotate(EnumDirection.WEST), 1).relative(var1.rotate(EnumDirection.NORTH), 1), var1));
                    }
                }
                String var19 = var13 == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String var20 = var13 == 0 ? "indoors_door_1" : "indoors_door_2";
                var21 = Lists.newArrayList();
                for (int var22 = 0; var22 < var16.height; ++var22) {
                    for (int var23 = 0; var23 < var16.width; ++var23) {
                        Object var30;
                        Object var292;
                        boolean var24;
                        boolean bl = var24 = var13 == 2 && var16.get(var23, var22) == 3;
                        if (var16.get(var23, var22) != 2 && !var24) continue;
                        int var25 = var15.get(var23, var22);
                        int var26 = var25 & 0xF0000;
                        int var27 = var25 & 0xFFFF;
                        var24 = var24 && (var25 & 0x800000) == 0x800000;
                        var21.clear();
                        if ((var25 & 0x200000) == 0x200000) {
                            for (Object var292 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                                if (var16.get(var23 + ((EnumDirection)var292).getStepX(), var22 + ((EnumDirection)var292).getStepZ()) != 1) continue;
                                var21.add(var292);
                            }
                        }
                        EnumDirection var28 = null;
                        if (!var21.isEmpty()) {
                            var28 = (EnumDirection)var21.get(this.random.nextInt(var21.size()));
                        } else if ((var25 & 0x100000) == 0x100000) {
                            var28 = EnumDirection.UP;
                        }
                        var292 = var14.relative(var1.rotate(EnumDirection.SOUTH), 8 + (var22 - this.startY) * 8);
                        var292 = ((BlockPosition)var292).relative(var1.rotate(EnumDirection.EAST), -1 + (var23 - this.startX) * 8);
                        if (c.isHouse(var16, var23 - 1, var22) && !var3.isRoomId(var16, var23 - 1, var22, var13, var27)) {
                            var2.add(new i(this.structureTemplateManager, var28 == EnumDirection.WEST ? var20 : var19, (BlockPosition)var292, var1));
                        }
                        if (var16.get(var23 + 1, var22) == 1 && !var24) {
                            var30 = ((BlockPosition)var292).relative(var1.rotate(EnumDirection.EAST), 8);
                            var2.add(new i(this.structureTemplateManager, var28 == EnumDirection.EAST ? var20 : var19, (BlockPosition)var30, var1));
                        }
                        if (c.isHouse(var16, var23, var22 + 1) && !var3.isRoomId(var16, var23, var22 + 1, var13, var27)) {
                            var30 = ((BlockPosition)var292).relative(var1.rotate(EnumDirection.SOUTH), 7);
                            var30 = ((BlockPosition)var30).relative(var1.rotate(EnumDirection.EAST), 7);
                            var2.add(new i(this.structureTemplateManager, var28 == EnumDirection.SOUTH ? var20 : var19, (BlockPosition)var30, var1.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                        }
                        if (var16.get(var23, var22 - 1) == 1 && !var24) {
                            var30 = ((BlockPosition)var292).relative(var1.rotate(EnumDirection.NORTH), 1);
                            var30 = ((BlockPosition)var30).relative(var1.rotate(EnumDirection.EAST), 7);
                            var2.add(new i(this.structureTemplateManager, var28 == EnumDirection.NORTH ? var20 : var19, (BlockPosition)var30, var1.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                        }
                        if (var26 == 65536) {
                            this.addRoom1x1(var2, (BlockPosition)var292, var1, var28, var12[var13]);
                            continue;
                        }
                        if (var26 == 131072 && var28 != null) {
                            var30 = var3.get1x2RoomDirection(var16, var23, var22, var13, var27);
                            boolean var31 = (var25 & 0x400000) == 0x400000;
                            this.addRoom1x2(var2, (BlockPosition)var292, var1, (EnumDirection)var30, var28, var12[var13], var31);
                            continue;
                        }
                        if (var26 == 262144 && var28 != null && var28 != EnumDirection.UP) {
                            var30 = var28.getClockWise();
                            if (!var3.isRoomId(var16, var23 + ((EnumDirection)var30).getStepX(), var22 + ((EnumDirection)var30).getStepZ(), var13, var27)) {
                                var30 = ((EnumDirection)var30).getOpposite();
                            }
                            this.addRoom2x2(var2, (BlockPosition)var292, var1, (EnumDirection)var30, var28, var12[var13]);
                            continue;
                        }
                        if (var26 != 262144 || var28 != EnumDirection.UP) continue;
                        this.addRoom2x2Secret(var2, (BlockPosition)var292, var1, var12[var13]);
                    }
                }
            }
        }

        private void traverseOuterWalls(List<i> var0, e var1, g var2, EnumDirection var3, int var4, int var5, int var6, int var7) {
            int var8 = var4;
            int var9 = var5;
            EnumDirection var10 = var3;
            do {
                if (!c.isHouse(var2, var8 + var3.getStepX(), var9 + var3.getStepZ())) {
                    this.traverseTurn(var0, var1);
                    var3 = var3.getClockWise();
                    if (var8 == var6 && var9 == var7 && var10 == var3) continue;
                    this.traverseWallPiece(var0, var1);
                    continue;
                }
                if (c.isHouse(var2, var8 + var3.getStepX(), var9 + var3.getStepZ()) && c.isHouse(var2, var8 + var3.getStepX() + var3.getCounterClockWise().getStepX(), var9 + var3.getStepZ() + var3.getCounterClockWise().getStepZ())) {
                    this.traverseInnerTurn(var0, var1);
                    var8 += var3.getStepX();
                    var9 += var3.getStepZ();
                    var3 = var3.getCounterClockWise();
                    continue;
                }
                if ((var8 += var3.getStepX()) == var6 && (var9 += var3.getStepZ()) == var7 && var10 == var3) continue;
                this.traverseWallPiece(var0, var1);
            } while (var8 != var6 || var9 != var7 || var10 != var3);
        }

        private void createRoof(List<i> var0, BlockPosition var1, EnumBlockRotation var2, g var3, @Nullable g var4) {
            BlockPosition var9;
            boolean var8;
            BlockPosition var7;
            int var6;
            int var5;
            for (var5 = 0; var5 < var3.height; ++var5) {
                for (var6 = 0; var6 < var3.width; ++var6) {
                    var7 = var1;
                    var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 8 + (var5 - this.startY) * 8);
                    var7 = var7.relative(var2.rotate(EnumDirection.EAST), (var6 - this.startX) * 8);
                    boolean bl = var8 = var4 != null && c.isHouse(var4, var6, var5);
                    if (!c.isHouse(var3, var6, var5) || var8) continue;
                    var0.add(new i(this.structureTemplateManager, "roof", var7.above(3), var2));
                    if (!c.isHouse(var3, var6 + 1, var5)) {
                        var9 = var7.relative(var2.rotate(EnumDirection.EAST), 6);
                        var0.add(new i(this.structureTemplateManager, "roof_front", var9, var2));
                    }
                    if (!c.isHouse(var3, var6 - 1, var5)) {
                        var9 = var7.relative(var2.rotate(EnumDirection.EAST), 0);
                        var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 7);
                        var0.add(new i(this.structureTemplateManager, "roof_front", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
                    }
                    if (!c.isHouse(var3, var6, var5 - 1)) {
                        var9 = var7.relative(var2.rotate(EnumDirection.WEST), 1);
                        var0.add(new i(this.structureTemplateManager, "roof_front", var9, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
                    }
                    if (c.isHouse(var3, var6, var5 + 1)) continue;
                    var9 = var7.relative(var2.rotate(EnumDirection.EAST), 6);
                    var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 6);
                    var0.add(new i(this.structureTemplateManager, "roof_front", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                }
            }
            if (var4 != null) {
                for (var5 = 0; var5 < var3.height; ++var5) {
                    for (var6 = 0; var6 < var3.width; ++var6) {
                        var7 = var1;
                        var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 8 + (var5 - this.startY) * 8);
                        var7 = var7.relative(var2.rotate(EnumDirection.EAST), (var6 - this.startX) * 8);
                        var8 = c.isHouse(var4, var6, var5);
                        if (!c.isHouse(var3, var6, var5) || !var8) continue;
                        if (!c.isHouse(var3, var6 + 1, var5)) {
                            var9 = var7.relative(var2.rotate(EnumDirection.EAST), 7);
                            var0.add(new i(this.structureTemplateManager, "small_wall", var9, var2));
                        }
                        if (!c.isHouse(var3, var6 - 1, var5)) {
                            var9 = var7.relative(var2.rotate(EnumDirection.WEST), 1);
                            var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 6);
                            var0.add(new i(this.structureTemplateManager, "small_wall", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
                        }
                        if (!c.isHouse(var3, var6, var5 - 1)) {
                            var9 = var7.relative(var2.rotate(EnumDirection.WEST), 0);
                            var9 = var9.relative(var2.rotate(EnumDirection.NORTH), 1);
                            var0.add(new i(this.structureTemplateManager, "small_wall", var9, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!c.isHouse(var3, var6, var5 + 1)) {
                            var9 = var7.relative(var2.rotate(EnumDirection.EAST), 6);
                            var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 7);
                            var0.add(new i(this.structureTemplateManager, "small_wall", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                        }
                        if (!c.isHouse(var3, var6 + 1, var5)) {
                            if (!c.isHouse(var3, var6, var5 - 1)) {
                                var9 = var7.relative(var2.rotate(EnumDirection.EAST), 7);
                                var9 = var9.relative(var2.rotate(EnumDirection.NORTH), 2);
                                var0.add(new i(this.structureTemplateManager, "small_wall_corner", var9, var2));
                            }
                            if (!c.isHouse(var3, var6, var5 + 1)) {
                                var9 = var7.relative(var2.rotate(EnumDirection.EAST), 8);
                                var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 7);
                                var0.add(new i(this.structureTemplateManager, "small_wall_corner", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                            }
                        }
                        if (c.isHouse(var3, var6 - 1, var5)) continue;
                        if (!c.isHouse(var3, var6, var5 - 1)) {
                            var9 = var7.relative(var2.rotate(EnumDirection.WEST), 2);
                            var9 = var9.relative(var2.rotate(EnumDirection.NORTH), 1);
                            var0.add(new i(this.structureTemplateManager, "small_wall_corner", var9, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
                        }
                        if (c.isHouse(var3, var6, var5 + 1)) continue;
                        var9 = var7.relative(var2.rotate(EnumDirection.WEST), 1);
                        var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 8);
                        var0.add(new i(this.structureTemplateManager, "small_wall_corner", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
                    }
                }
            }
            for (var5 = 0; var5 < var3.height; ++var5) {
                for (var6 = 0; var6 < var3.width; ++var6) {
                    BlockPosition var10;
                    var7 = var1;
                    var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 8 + (var5 - this.startY) * 8);
                    var7 = var7.relative(var2.rotate(EnumDirection.EAST), (var6 - this.startX) * 8);
                    boolean bl = var8 = var4 != null && c.isHouse(var4, var6, var5);
                    if (!c.isHouse(var3, var6, var5) || var8) continue;
                    if (!c.isHouse(var3, var6 + 1, var5)) {
                        var9 = var7.relative(var2.rotate(EnumDirection.EAST), 6);
                        if (!c.isHouse(var3, var6, var5 + 1)) {
                            var10 = var9.relative(var2.rotate(EnumDirection.SOUTH), 6);
                            var0.add(new i(this.structureTemplateManager, "roof_corner", var10, var2));
                        } else if (c.isHouse(var3, var6 + 1, var5 + 1)) {
                            var10 = var9.relative(var2.rotate(EnumDirection.SOUTH), 5);
                            var0.add(new i(this.structureTemplateManager, "roof_inner_corner", var10, var2));
                        }
                        if (!c.isHouse(var3, var6, var5 - 1)) {
                            var0.add(new i(this.structureTemplateManager, "roof_corner", var9, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
                        } else if (c.isHouse(var3, var6 + 1, var5 - 1)) {
                            var10 = var7.relative(var2.rotate(EnumDirection.EAST), 9);
                            var10 = var10.relative(var2.rotate(EnumDirection.NORTH), 2);
                            var0.add(new i(this.structureTemplateManager, "roof_inner_corner", var10, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                        }
                    }
                    if (c.isHouse(var3, var6 - 1, var5)) continue;
                    var9 = var7.relative(var2.rotate(EnumDirection.EAST), 0);
                    var9 = var9.relative(var2.rotate(EnumDirection.SOUTH), 0);
                    if (!c.isHouse(var3, var6, var5 + 1)) {
                        var10 = var9.relative(var2.rotate(EnumDirection.SOUTH), 6);
                        var0.add(new i(this.structureTemplateManager, "roof_corner", var10, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
                    } else if (c.isHouse(var3, var6 - 1, var5 + 1)) {
                        var10 = var9.relative(var2.rotate(EnumDirection.SOUTH), 8);
                        var10 = var10.relative(var2.rotate(EnumDirection.WEST), 3);
                        var0.add(new i(this.structureTemplateManager, "roof_inner_corner", var10, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!c.isHouse(var3, var6, var5 - 1)) {
                        var0.add(new i(this.structureTemplateManager, "roof_corner", var9, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!c.isHouse(var3, var6 - 1, var5 - 1)) continue;
                    var10 = var9.relative(var2.rotate(EnumDirection.SOUTH), 1);
                    var0.add(new i(this.structureTemplateManager, "roof_inner_corner", var10, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
                }
            }
        }

        private void entrance(List<i> var0, e var1) {
            EnumDirection var2 = var1.rotation.rotate(EnumDirection.WEST);
            var0.add(new i(this.structureTemplateManager, "entrance", var1.position.relative(var2, 9), var1.rotation));
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.SOUTH), 16);
        }

        private void traverseWallPiece(List<i> var0, e var1) {
            var0.add(new i(this.structureTemplateManager, var1.wallType, var1.position.relative(var1.rotation.rotate(EnumDirection.EAST), 7), var1.rotation));
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.SOUTH), 8);
        }

        private void traverseTurn(List<i> var0, e var1) {
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.SOUTH), -1);
            var0.add(new i(this.structureTemplateManager, "wall_corner", var1.position, var1.rotation));
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.SOUTH), -7);
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.WEST), -6);
            var1.rotation = var1.rotation.getRotated(EnumBlockRotation.CLOCKWISE_90);
        }

        private void traverseInnerTurn(List<i> var0, e var1) {
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.SOUTH), 6);
            var1.position = var1.position.relative(var1.rotation.rotate(EnumDirection.EAST), 8);
            var1.rotation = var1.rotation.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90);
        }

        private void addRoom1x1(List<i> var0, BlockPosition var1, EnumBlockRotation var2, EnumDirection var3, b var4) {
            EnumBlockRotation var5 = EnumBlockRotation.NONE;
            String var6 = var4.get1x1(this.random);
            if (var3 != EnumDirection.EAST) {
                if (var3 == EnumDirection.NORTH) {
                    var5 = var5.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90);
                } else if (var3 == EnumDirection.WEST) {
                    var5 = var5.getRotated(EnumBlockRotation.CLOCKWISE_180);
                } else if (var3 == EnumDirection.SOUTH) {
                    var5 = var5.getRotated(EnumBlockRotation.CLOCKWISE_90);
                } else {
                    var6 = var4.get1x1Secret(this.random);
                }
            }
            BlockPosition var7 = DefinedStructure.getZeroPositionWithTransform(new BlockPosition(1, 0, 0), EnumBlockMirror.NONE, var5, 7, 7);
            var5 = var5.getRotated(var2);
            var7 = var7.rotate(var2);
            BlockPosition var8 = var1.offset(var7.getX(), 0, var7.getZ());
            var0.add(new i(this.structureTemplateManager, var6, var8, var5));
        }

        private void addRoom1x2(List<i> var0, BlockPosition var1, EnumBlockRotation var2, EnumDirection var3, EnumDirection var4, b var5, boolean var6) {
            if (var4 == EnumDirection.EAST && var3 == EnumDirection.SOUTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2));
            } else if (var4 == EnumDirection.EAST && var3 == EnumDirection.NORTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
                var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 6);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2, EnumBlockMirror.LEFT_RIGHT));
            } else if (var4 == EnumDirection.WEST && var3 == EnumDirection.NORTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 7);
                var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 6);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
            } else if (var4 == EnumDirection.WEST && var3 == EnumDirection.SOUTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 7);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2, EnumBlockMirror.FRONT_BACK));
            } else if (var4 == EnumDirection.SOUTH && var3 == EnumDirection.EAST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_90), EnumBlockMirror.LEFT_RIGHT));
            } else if (var4 == EnumDirection.SOUTH && var3 == EnumDirection.WEST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 7);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
            } else if (var4 == EnumDirection.NORTH && var3 == EnumDirection.WEST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 7);
                var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 6);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_90), EnumBlockMirror.FRONT_BACK));
            } else if (var4 == EnumDirection.NORTH && var3 == EnumDirection.EAST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
                var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 6);
                var0.add(new i(this.structureTemplateManager, var5.get1x2SideEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
            } else if (var4 == EnumDirection.SOUTH && var3 == EnumDirection.NORTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
                var7 = var7.relative(var2.rotate(EnumDirection.NORTH), 8);
                var0.add(new i(this.structureTemplateManager, var5.get1x2FrontEntrance(this.random, var6), var7, var2));
            } else if (var4 == EnumDirection.NORTH && var3 == EnumDirection.SOUTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 7);
                var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 14);
                var0.add(new i(this.structureTemplateManager, var5.get1x2FrontEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_180)));
            } else if (var4 == EnumDirection.WEST && var3 == EnumDirection.EAST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 15);
                var0.add(new i(this.structureTemplateManager, var5.get1x2FrontEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
            } else if (var4 == EnumDirection.EAST && var3 == EnumDirection.WEST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.WEST), 7);
                var7 = var7.relative(var2.rotate(EnumDirection.SOUTH), 6);
                var0.add(new i(this.structureTemplateManager, var5.get1x2FrontEntrance(this.random, var6), var7, var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90)));
            } else if (var4 == EnumDirection.UP && var3 == EnumDirection.EAST) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 15);
                var0.add(new i(this.structureTemplateManager, var5.get1x2Secret(this.random), var7, var2.getRotated(EnumBlockRotation.CLOCKWISE_90)));
            } else if (var4 == EnumDirection.UP && var3 == EnumDirection.SOUTH) {
                BlockPosition var7 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
                var7 = var7.relative(var2.rotate(EnumDirection.NORTH), 0);
                var0.add(new i(this.structureTemplateManager, var5.get1x2Secret(this.random), var7, var2));
            }
        }

        private void addRoom2x2(List<i> var0, BlockPosition var1, EnumBlockRotation var2, EnumDirection var3, EnumDirection var4, b var5) {
            int var6 = 0;
            int var7 = 0;
            EnumBlockRotation var8 = var2;
            EnumBlockMirror var9 = EnumBlockMirror.NONE;
            if (var4 == EnumDirection.EAST && var3 == EnumDirection.SOUTH) {
                var6 = -7;
            } else if (var4 == EnumDirection.EAST && var3 == EnumDirection.NORTH) {
                var6 = -7;
                var7 = 6;
                var9 = EnumBlockMirror.LEFT_RIGHT;
            } else if (var4 == EnumDirection.NORTH && var3 == EnumDirection.EAST) {
                var6 = 1;
                var7 = 14;
                var8 = var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90);
            } else if (var4 == EnumDirection.NORTH && var3 == EnumDirection.WEST) {
                var6 = 7;
                var7 = 14;
                var8 = var2.getRotated(EnumBlockRotation.COUNTERCLOCKWISE_90);
                var9 = EnumBlockMirror.LEFT_RIGHT;
            } else if (var4 == EnumDirection.SOUTH && var3 == EnumDirection.WEST) {
                var6 = 7;
                var7 = -8;
                var8 = var2.getRotated(EnumBlockRotation.CLOCKWISE_90);
            } else if (var4 == EnumDirection.SOUTH && var3 == EnumDirection.EAST) {
                var6 = 1;
                var7 = -8;
                var8 = var2.getRotated(EnumBlockRotation.CLOCKWISE_90);
                var9 = EnumBlockMirror.LEFT_RIGHT;
            } else if (var4 == EnumDirection.WEST && var3 == EnumDirection.NORTH) {
                var6 = 15;
                var7 = 6;
                var8 = var2.getRotated(EnumBlockRotation.CLOCKWISE_180);
            } else if (var4 == EnumDirection.WEST && var3 == EnumDirection.SOUTH) {
                var6 = 15;
                var9 = EnumBlockMirror.FRONT_BACK;
            }
            BlockPosition var10 = var1.relative(var2.rotate(EnumDirection.EAST), var6);
            var10 = var10.relative(var2.rotate(EnumDirection.SOUTH), var7);
            var0.add(new i(this.structureTemplateManager, var5.get2x2(this.random), var10, var8, var9));
        }

        private void addRoom2x2Secret(List<i> var0, BlockPosition var1, EnumBlockRotation var2, b var3) {
            BlockPosition var4 = var1.relative(var2.rotate(EnumDirection.EAST), 1);
            var0.add(new i(this.structureTemplateManager, var3.get2x2Secret(this.random), var4, var2, EnumBlockMirror.NONE));
        }
    }

    static class h
    extends f {
        h() {
        }
    }

    static class f
    extends b {
        f() {
        }

        @Override
        public String get1x1(RandomSource var0) {
            return "1x1_b" + (var0.nextInt(4) + 1);
        }

        @Override
        public String get1x1Secret(RandomSource var0) {
            return "1x1_as" + (var0.nextInt(4) + 1);
        }

        @Override
        public String get1x2SideEntrance(RandomSource var0, boolean var1) {
            if (var1) {
                return "1x2_c_stairs";
            }
            return "1x2_c" + (var0.nextInt(4) + 1);
        }

        @Override
        public String get1x2FrontEntrance(RandomSource var0, boolean var1) {
            if (var1) {
                return "1x2_d_stairs";
            }
            return "1x2_d" + (var0.nextInt(5) + 1);
        }

        @Override
        public String get1x2Secret(RandomSource var0) {
            return "1x2_se" + (var0.nextInt(1) + 1);
        }

        @Override
        public String get2x2(RandomSource var0) {
            return "2x2_b" + (var0.nextInt(5) + 1);
        }

        @Override
        public String get2x2Secret(RandomSource var0) {
            return "2x2_s1";
        }
    }

    static class a
    extends b {
        a() {
        }

        @Override
        public String get1x1(RandomSource var0) {
            return "1x1_a" + (var0.nextInt(5) + 1);
        }

        @Override
        public String get1x1Secret(RandomSource var0) {
            return "1x1_as" + (var0.nextInt(4) + 1);
        }

        @Override
        public String get1x2SideEntrance(RandomSource var0, boolean var1) {
            return "1x2_a" + (var0.nextInt(9) + 1);
        }

        @Override
        public String get1x2FrontEntrance(RandomSource var0, boolean var1) {
            return "1x2_b" + (var0.nextInt(5) + 1);
        }

        @Override
        public String get1x2Secret(RandomSource var0) {
            return "1x2_s" + (var0.nextInt(2) + 1);
        }

        @Override
        public String get2x2(RandomSource var0) {
            return "2x2_a" + (var0.nextInt(4) + 1);
        }

        @Override
        public String get2x2Secret(RandomSource var0) {
            return "2x2_s1";
        }
    }

    static abstract class b {
        b() {
        }

        public abstract String get1x1(RandomSource var1);

        public abstract String get1x1Secret(RandomSource var1);

        public abstract String get1x2SideEntrance(RandomSource var1, boolean var2);

        public abstract String get1x2FrontEntrance(RandomSource var1, boolean var2);

        public abstract String get1x2Secret(RandomSource var1);

        public abstract String get2x2(RandomSource var1);

        public abstract String get2x2Secret(RandomSource var1);
    }

    static class g {
        private final int[][] grid;
        final int width;
        final int height;
        private final int valueIfOutside;

        public g(int var0, int var1, int var2) {
            this.width = var0;
            this.height = var1;
            this.valueIfOutside = var2;
            this.grid = new int[var0][var1];
        }

        public void set(int var0, int var1, int var2) {
            if (var0 >= 0 && var0 < this.width && var1 >= 0 && var1 < this.height) {
                this.grid[var0][var1] = var2;
            }
        }

        public void set(int var0, int var1, int var2, int var3, int var4) {
            for (int var5 = var1; var5 <= var3; ++var5) {
                for (int var6 = var0; var6 <= var2; ++var6) {
                    this.set(var6, var5, var4);
                }
            }
        }

        public int get(int var0, int var1) {
            if (var0 >= 0 && var0 < this.width && var1 >= 0 && var1 < this.height) {
                return this.grid[var0][var1];
            }
            return this.valueIfOutside;
        }

        public void setif(int var0, int var1, int var2, int var3) {
            if (this.get(var0, var1) == var2) {
                this.set(var0, var1, var3);
            }
        }

        public boolean edgesTo(int var0, int var1, int var2) {
            return this.get(var0 - 1, var1) == var2 || this.get(var0 + 1, var1) == var2 || this.get(var0, var1 + 1) == var2 || this.get(var0, var1 - 1) == var2;
        }
    }

    static class e {
        public EnumBlockRotation rotation;
        public BlockPosition position;
        public String wallType;

        e() {
        }
    }

    public static class i
    extends DefinedStructurePiece {
        public i(StructureTemplateManager var0, String var1, BlockPosition var2, EnumBlockRotation var3) {
            this(var0, var1, var2, var3, EnumBlockMirror.NONE);
        }

        public i(StructureTemplateManager var0, String var1, BlockPosition var2, EnumBlockRotation var3, EnumBlockMirror var4) {
            super(WorldGenFeatureStructurePieceType.WOODLAND_MANSION_PIECE, 0, var0, i.makeLocation(var1), var1, i.makeSettings(var4, var3), var2);
        }

        public i(StructureTemplateManager var0, NBTTagCompound var12) {
            super(WorldGenFeatureStructurePieceType.WOODLAND_MANSION_PIECE, var12, var0, (MinecraftKey var1) -> i.makeSettings(EnumBlockMirror.valueOf(var12.getString("Mi")), EnumBlockRotation.valueOf(var12.getString("Rot"))));
        }

        @Override
        protected MinecraftKey makeTemplateLocation() {
            return i.makeLocation(this.templateName);
        }

        private static MinecraftKey makeLocation(String var0) {
            return MinecraftKey.withDefaultNamespace("woodland_mansion/" + var0);
        }

        private static DefinedStructureInfo makeSettings(EnumBlockMirror var0, EnumBlockRotation var1) {
            return new DefinedStructureInfo().setIgnoreEntities(true).setRotation(var1).setMirror(var0).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putString("Rot", this.placeSettings.getRotation().name());
            var1.putString("Mi", this.placeSettings.getMirror().name());
        }

        @Override
        protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, RandomSource var3, StructureBoundingBox var4) {
            if (var0.startsWith("Chest")) {
                EnumBlockRotation var5 = this.placeSettings.getRotation();
                IBlockData var6 = Blocks.CHEST.defaultBlockState();
                if ("ChestWest".equals(var0)) {
                    var6 = (IBlockData)var6.setValue(BlockChest.FACING, var5.rotate(EnumDirection.WEST));
                } else if ("ChestEast".equals(var0)) {
                    var6 = (IBlockData)var6.setValue(BlockChest.FACING, var5.rotate(EnumDirection.EAST));
                } else if ("ChestSouth".equals(var0)) {
                    var6 = (IBlockData)var6.setValue(BlockChest.FACING, var5.rotate(EnumDirection.SOUTH));
                } else if ("ChestNorth".equals(var0)) {
                    var6 = (IBlockData)var6.setValue(BlockChest.FACING, var5.rotate(EnumDirection.NORTH));
                }
                this.createChest(var2, var4, var3, var1, LootTables.WOODLAND_MANSION, var6);
            } else {
                ArrayList<EntityInsentient> var5 = new ArrayList<EntityInsentient>();
                switch (var0) {
                    case "Mage": {
                        var5.add(EntityTypes.EVOKER.create(var2.getLevel(), EntitySpawnReason.STRUCTURE));
                        break;
                    }
                    case "Warrior": {
                        var5.add(EntityTypes.VINDICATOR.create(var2.getLevel(), EntitySpawnReason.STRUCTURE));
                        break;
                    }
                    case "Group of Allays": {
                        int var8 = var2.getRandom().nextInt(3) + 1;
                        for (int var9 = 0; var9 < var8; ++var9) {
                            var5.add(EntityTypes.ALLAY.create(var2.getLevel(), EntitySpawnReason.STRUCTURE));
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                for (EntityInsentient var7 : var5) {
                    if (var7 == null) continue;
                    var7.setPersistenceRequired();
                    var7.moveTo(var1, 0.0f, 0.0f);
                    var7.finalizeSpawn(var2, var2.getCurrentDifficultyAt(var7.blockPosition()), EntitySpawnReason.STRUCTURE, null);
                    var2.addFreshEntityWithPassengers(var7);
                    var2.setBlock(var1, Blocks.AIR.defaultBlockState(), 2);
                }
            }
        }
    }
}

