/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces;

public class OceanRuinStructure
extends Structure {
    public static final MapCodec<OceanRuinStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(OceanRuinStructure.settingsCodec(var02), (App)a.CODEC.fieldOf("biome_temp").forGetter(var0 -> var0.biomeTemp), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("large_probability").forGetter(var0 -> Float.valueOf(var0.largeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cluster_probability").forGetter(var0 -> Float.valueOf(var0.clusterProbability))).apply((Applicative)var02, OceanRuinStructure::new));
    public final a biomeTemp;
    public final float largeProbability;
    public final float clusterProbability;

    public OceanRuinStructure(Structure.c var0, a var1, float var2, float var3) {
        super(var0);
        this.biomeTemp = var1;
        this.largeProbability = var2;
        this.clusterProbability = var3;
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        return OceanRuinStructure.onTopOfChunkCenter(var0, HeightMap.Type.OCEAN_FLOOR_WG, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.a var1) {
        BlockPosition var2 = new BlockPosition(var1.chunkPos().getMinBlockX(), 90, var1.chunkPos().getMinBlockZ());
        EnumBlockRotation var3 = EnumBlockRotation.getRandom(var1.random());
        OceanRuinPieces.addPieces(var1.structureTemplateManager(), var2, var3, var0, var1.random(), this);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.OCEAN_RUIN;
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a WARM = new a("warm");
        public static final /* enum */ a COLD = new a("cold");
        public static final Codec<a> CODEC;
        private final String name;
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] b() {
            return new a[]{WARM, COLD};
        }

        static {
            e = a.b();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

