/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;

public abstract class WorldGenScatteredPiece
extends StructurePiece {
    protected final int width;
    protected final int height;
    protected final int depth;
    protected int heightPosition = -1;

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType var0, int var1, int var2, int var3, int var4, int var5, int var6, EnumDirection var7) {
        super(var0, 0, StructurePiece.makeBoundingBox(var1, var2, var3, var7, var4, var5, var6));
        this.width = var4;
        this.height = var5;
        this.depth = var6;
        this.setOrientation(var7);
    }

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
        super(var0, var1);
        this.width = var1.getInt("Width");
        this.height = var1.getInt("Height");
        this.depth = var1.getInt("Depth");
        this.heightPosition = var1.getInt("HPos");
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        var1.putInt("Width", this.width);
        var1.putInt("Height", this.height);
        var1.putInt("Depth", this.depth);
        var1.putInt("HPos", this.heightPosition);
    }

    protected boolean updateAverageGroundHeight(GeneratorAccess var0, StructureBoundingBox var1, int var2) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int var3 = 0;
        int var4 = 0;
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (int var6 = this.boundingBox.minZ(); var6 <= this.boundingBox.maxZ(); ++var6) {
            for (int var7 = this.boundingBox.minX(); var7 <= this.boundingBox.maxX(); ++var7) {
                var5.set(var7, 64, var6);
                if (!var1.isInside(var5)) continue;
                var3 += var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var5).getY();
                ++var4;
            }
        }
        if (var4 == 0) {
            return false;
        }
        this.heightPosition = var3 / var4;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + var2, 0);
        return true;
    }

    protected boolean updateHeightPositionToLowestGroundHeight(GeneratorAccess var0, int var1) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int var2 = var0.getMaxY() + 1;
        boolean var3 = false;
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (int var5 = this.boundingBox.minZ(); var5 <= this.boundingBox.maxZ(); ++var5) {
            for (int var6 = this.boundingBox.minX(); var6 <= this.boundingBox.maxX(); ++var6) {
                var4.set(var6, 0, var5);
                var2 = Math.min(var2, var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var4).getY());
                var3 = true;
            }
        }
        if (!var3) {
            return false;
        }
        this.heightPosition = var2;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + var1, 0);
        return true;
    }
}

