/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class CherryTrunkPlacer
extends TrunkPlacer {
    private static final Codec<UniformInt> BRANCH_START_CODEC = UniformInt.CODEC.codec().validate(var0 -> {
        if (var0.getMaxValue() - var0.getMinValue() < 1) {
            return DataResult.error(() -> "Need at least 2 blocks variation for the branch starts to fit both branches");
        }
        return DataResult.success((Object)var0);
    });
    public static final MapCodec<CherryTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> CherryTrunkPlacer.trunkPlacerParts(var02).and(var02.group((App)IntProvider.codec(1, 3).fieldOf("branch_count").forGetter(var0 -> var0.branchCount), (App)IntProvider.codec(2, 16).fieldOf("branch_horizontal_length").forGetter(var0 -> var0.branchHorizontalLength), (App)IntProvider.validateCodec(-16, 0, BRANCH_START_CODEC).fieldOf("branch_start_offset_from_top").forGetter(var0 -> var0.branchStartOffsetFromTop), (App)IntProvider.codec(-16, 16).fieldOf("branch_end_offset_from_top").forGetter(var0 -> var0.branchEndOffsetFromTop))).apply((Applicative)var02, CherryTrunkPlacer::new));
    private final IntProvider branchCount;
    private final IntProvider branchHorizontalLength;
    private final UniformInt branchStartOffsetFromTop;
    private final UniformInt secondBranchStartOffsetFromTop;
    private final IntProvider branchEndOffsetFromTop;

    public CherryTrunkPlacer(int var0, int var1, int var2, IntProvider var3, IntProvider var4, UniformInt var5, IntProvider var6) {
        super(var0, var1, var2);
        this.branchCount = var3;
        this.branchHorizontalLength = var4;
        this.branchStartOffsetFromTop = var5;
        this.secondBranchStartOffsetFromTop = UniformInt.of(var5.getMinValue(), var5.getMaxValue() - 1);
        this.branchEndOffsetFromTop = var6;
    }

    @Override
    protected TrunkPlacers<?> type() {
        return TrunkPlacers.CHERRY_TRUNK_PLACER;
    }

    @Override
    public List<WorldGenFoilagePlacer.a> placeTrunk(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var12, RandomSource var2, int var3, BlockPosition var4, WorldGenFeatureTreeConfiguration var5) {
        boolean var10;
        int var8;
        CherryTrunkPlacer.setDirtAt(var0, var12, var2, var4.below(), var5);
        int var6 = Math.max(0, var3 - 1 + this.branchStartOffsetFromTop.sample(var2));
        int var7 = Math.max(0, var3 - 1 + this.secondBranchStartOffsetFromTop.sample(var2));
        if (var7 >= var6) {
            ++var7;
        }
        boolean var9 = (var8 = this.branchCount.sample(var2)) == 3;
        boolean bl = var10 = var8 >= 2;
        int var11 = var9 ? var3 : (var10 ? Math.max(var6, var7) + 1 : var6 + 1);
        for (int var122 = 0; var122 < var11; ++var122) {
            this.placeLog(var0, var12, var2, var4.above(var122), var5);
        }
        ArrayList<WorldGenFoilagePlacer.a> var123 = new ArrayList<WorldGenFoilagePlacer.a>();
        if (var9) {
            var123.add(new WorldGenFoilagePlacer.a(var4.above(var11), 0, false));
        }
        BlockPosition.MutableBlockPosition var13 = new BlockPosition.MutableBlockPosition();
        EnumDirection var14 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var2);
        Function<IBlockData, IBlockData> var15 = var1 -> (IBlockData)var1.trySetValue(BlockRotatable.AXIS, var14.getAxis());
        var123.add(this.generateBranch(var0, var12, var2, var3, var4, var5, var15, var14, var6, var6 < var11 - 1, var13));
        if (var10) {
            var123.add(this.generateBranch(var0, var12, var2, var3, var4, var5, var15, var14.getOpposite(), var7, var7 < var11 - 1, var13));
        }
        return var123;
    }

    private WorldGenFoilagePlacer.a generateBranch(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, int var3, BlockPosition var4, WorldGenFeatureTreeConfiguration var5, Function<IBlockData, IBlockData> var6, EnumDirection var7, int var8, boolean var9, BlockPosition.MutableBlockPosition var10) {
        int var17;
        EnumDirection var16;
        var10.set(var4).move(EnumDirection.UP, var8);
        int var11 = var3 - 1 + this.branchEndOffsetFromTop.sample(var2);
        boolean var12 = var9 || var11 < var8;
        int var13 = this.branchHorizontalLength.sample(var2) + (var12 ? 1 : 0);
        BlockPosition var14 = var4.relative(var7, var13).above(var11);
        int var15 = var12 ? 2 : 1;
        for (int var162 = 0; var162 < var15; ++var162) {
            this.placeLog(var0, var1, var2, var10.move(var7), var5, var6);
        }
        EnumDirection enumDirection = var16 = var14.getY() > var10.getY() ? EnumDirection.UP : EnumDirection.DOWN;
        while ((var17 = var10.distManhattan(var14)) != 0) {
            float var18 = (float)Math.abs(var14.getY() - var10.getY()) / (float)var17;
            boolean var19 = var2.nextFloat() < var18;
            var10.move(var19 ? var16 : var7);
            this.placeLog(var0, var1, var2, var10, var5, var19 ? Function.identity() : var6);
        }
        return new WorldGenFoilagePlacer.a(var14.above(), 0, false);
    }
}

