/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class WorldGenFeatureTreeBeehive
extends WorldGenFeatureTree {
    public static final MapCodec<WorldGenFeatureTreeBeehive> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(WorldGenFeatureTreeBeehive::new, var0 -> Float.valueOf(var0.probability));
    private static final EnumDirection WORLDGEN_FACING = EnumDirection.SOUTH;
    private static final EnumDirection[] SPAWN_DIRECTIONS = (EnumDirection[])EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().filter(var0 -> var0 != WORLDGEN_FACING.getOpposite()).toArray(EnumDirection[]::new);
    private final float probability;

    public WorldGenFeatureTreeBeehive(float var0) {
        this.probability = var0;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.BEEHIVE;
    }

    @Override
    public void place(WorldGenFeatureTree.a var02) {
        RandomSource var12 = var02.random();
        if (var12.nextFloat() >= this.probability) {
            return;
        }
        ObjectArrayList<BlockPosition> var2 = var02.leaves();
        ObjectArrayList<BlockPosition> var3 = var02.logs();
        int var4 = !var2.isEmpty() ? Math.max(((BlockPosition)var2.get(0)).getY() - 1, ((BlockPosition)var3.get(0)).getY() + 1) : Math.min(((BlockPosition)var3.get(0)).getY() + 1 + var12.nextInt(3), ((BlockPosition)var3.get(var3.size() - 1)).getY());
        List var5 = var3.stream().filter(var1 -> var1.getY() == var4).flatMap(var0 -> Stream.of(SPAWN_DIRECTIONS).map(var0::relative)).collect(Collectors.toList());
        if (var5.isEmpty()) {
            return;
        }
        SystemUtils.shuffle(var5, var12);
        Optional<BlockPosition> var6 = var5.stream().filter(var1 -> var02.isAir((BlockPosition)var1) && var02.isAir(var1.relative(WORLDGEN_FACING))).findFirst();
        if (var6.isEmpty()) {
            return;
        }
        var02.setBlock(var6.get(), (IBlockData)Blocks.BEE_NEST.defaultBlockState().setValue(BlockBeehive.FACING, WORLDGEN_FACING));
        var02.level().getBlockEntity(var6.get(), TileEntityTypes.BEEHIVE).ifPresent(var1 -> {
            int var2 = 2 + var12.nextInt(2);
            for (int var3 = 0; var3 < var2; ++var3) {
                var1.storeBee(TileEntityBeehive.c.create(var12.nextInt(599)));
            }
        });
    }
}

