/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public class HasSturdyFacePredicate
implements BlockPredicate {
    private final BaseBlockPosition offset;
    private final EnumDirection direction;
    public static final MapCodec<HasSturdyFacePredicate> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BaseBlockPosition.offsetCodec(16).optionalFieldOf("offset", (Object)BaseBlockPosition.ZERO).forGetter(var0 -> var0.offset), (App)EnumDirection.CODEC.fieldOf("direction").forGetter(var0 -> var0.direction)).apply((Applicative)var02, HasSturdyFacePredicate::new));

    public HasSturdyFacePredicate(BaseBlockPosition var0, EnumDirection var1) {
        this.offset = var0;
        this.direction = var1;
    }

    @Override
    public boolean test(GeneratorAccessSeed var0, BlockPosition var1) {
        BlockPosition var2 = var1.offset(this.offset);
        return var0.getBlockState(var2).isFaceSturdy(var0, var2, this.direction);
    }

    @Override
    public BlockPredicateType<?> type() {
        return BlockPredicateType.HAS_STURDY_FACE;
    }

    @Override
    public /* synthetic */ boolean test(Object object, Object object2) {
        return this.test((GeneratorAccessSeed)object, (BlockPosition)object2);
    }
}

