/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class ChunkProviderFlat
extends ChunkGenerator {
    public static final MapCodec<ChunkProviderFlat> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)GeneratorSettingsFlat.CODEC.fieldOf("settings").forGetter(ChunkProviderFlat::settings)).apply((Applicative)var0, var0.stable(ChunkProviderFlat::new)));
    private final GeneratorSettingsFlat settings;

    public ChunkProviderFlat(GeneratorSettingsFlat var0) {
        super(new WorldChunkManagerHell(var0.getBiome()), SystemUtils.memoize(var0::adjustGenerationSettings));
        this.settings = var0;
    }

    @Override
    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> var0, RandomState var1, long var2) {
        Stream var4 = this.settings.structureOverrides().map(HolderSet::stream).orElseGet(() -> var0.listElements().map(var0 -> var0));
        return ChunkGeneratorStructureState.createForFlat(var1, var2, this.biomeSource, var4);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public GeneratorSettingsFlat settings() {
        return this.settings;
    }

    @Override
    public void buildSurface(RegionLimitedWorldAccess var0, StructureManager var1, RandomState var2, IChunkAccess var3) {
    }

    @Override
    public int getSpawnHeight(LevelHeightAccessor var0) {
        return var0.getMinY() + Math.min(var0.getHeight(), this.settings.getLayers().size());
    }

    @Override
    public CompletableFuture<IChunkAccess> fillFromNoise(Blender var0, RandomState var1, StructureManager var2, IChunkAccess var3) {
        List<IBlockData> var4 = this.settings.getLayers();
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        HeightMap var6 = var3.getOrCreateHeightmapUnprimed(HeightMap.Type.OCEAN_FLOOR_WG);
        HeightMap var7 = var3.getOrCreateHeightmapUnprimed(HeightMap.Type.WORLD_SURFACE_WG);
        for (int var8 = 0; var8 < Math.min(var3.getHeight(), var4.size()); ++var8) {
            IBlockData var9 = var4.get(var8);
            if (var9 == null) continue;
            int var10 = var3.getMinY() + var8;
            for (int var11 = 0; var11 < 16; ++var11) {
                for (int var12 = 0; var12 < 16; ++var12) {
                    var3.setBlockState(var5.set(var11, var10, var12), var9, false);
                    var6.update(var11, var10, var12, var9);
                    var7.update(var11, var10, var12, var9);
                }
            }
        }
        return CompletableFuture.completedFuture(var3);
    }

    @Override
    public int getBaseHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3, RandomState var4) {
        List<IBlockData> var5 = this.settings.getLayers();
        for (int var6 = Math.min(var5.size() - 1, var3.getMaxY()); var6 >= 0; --var6) {
            IBlockData var7 = var5.get(var6);
            if (var7 == null || !var2.isOpaque().test(var7)) continue;
            return var3.getMinY() + var6 + 1;
        }
        return var3.getMinY();
    }

    @Override
    public BlockColumn getBaseColumn(int var02, int var1, LevelHeightAccessor var2, RandomState var3) {
        return new BlockColumn(var2.getMinY(), (IBlockData[])this.settings.getLayers().stream().limit(var2.getHeight()).map(var0 -> var0 == null ? Blocks.AIR.defaultBlockState() : var0).toArray(IBlockData[]::new));
    }

    @Override
    public void addDebugScreenInfo(List<String> var0, RandomState var1, BlockPosition var2) {
    }

    @Override
    public void applyCarvers(RegionLimitedWorldAccess var0, long var1, RandomState var3, BiomeManager var4, StructureManager var5, IChunkAccess var6) {
    }

    @Override
    public void spawnOriginalMobs(RegionLimitedWorldAccess var0) {
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getGenDepth() {
        return 384;
    }

    @Override
    public int getSeaLevel() {
        return -63;
    }
}

