/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.levelgen.HeightMap;
import org.jetbrains.annotations.VisibleForTesting;

public class ChunkStatus {
    public static final int MAX_STRUCTURE_DISTANCE = 8;
    private static final EnumSet<HeightMap.Type> WORLDGEN_HEIGHTMAPS = EnumSet.of(HeightMap.Type.OCEAN_FLOOR_WG, HeightMap.Type.WORLD_SURFACE_WG);
    public static final EnumSet<HeightMap.Type> FINAL_HEIGHTMAPS = EnumSet.of(HeightMap.Type.OCEAN_FLOOR, HeightMap.Type.WORLD_SURFACE, HeightMap.Type.MOTION_BLOCKING, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES);
    public static final ChunkStatus EMPTY = ChunkStatus.register("empty", null, WORLDGEN_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus STRUCTURE_STARTS = ChunkStatus.register("structure_starts", EMPTY, WORLDGEN_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus STRUCTURE_REFERENCES = ChunkStatus.register("structure_references", STRUCTURE_STARTS, WORLDGEN_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus BIOMES = ChunkStatus.register("biomes", STRUCTURE_REFERENCES, WORLDGEN_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus NOISE = ChunkStatus.register("noise", BIOMES, WORLDGEN_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus SURFACE = ChunkStatus.register("surface", NOISE, WORLDGEN_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus CARVERS = ChunkStatus.register("carvers", SURFACE, FINAL_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus FEATURES = ChunkStatus.register("features", CARVERS, FINAL_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus INITIALIZE_LIGHT = ChunkStatus.register("initialize_light", FEATURES, FINAL_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus LIGHT = ChunkStatus.register("light", INITIALIZE_LIGHT, FINAL_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus SPAWN = ChunkStatus.register("spawn", LIGHT, FINAL_HEIGHTMAPS, ChunkType.PROTOCHUNK);
    public static final ChunkStatus FULL = ChunkStatus.register("full", SPAWN, FINAL_HEIGHTMAPS, ChunkType.LEVELCHUNK);
    private final int index;
    private final ChunkStatus parent;
    private final ChunkType chunkType;
    private final EnumSet<HeightMap.Type> heightmapsAfter;

    private static ChunkStatus register(String var0, @Nullable ChunkStatus var1, EnumSet<HeightMap.Type> var2, ChunkType var3) {
        return IRegistry.register(BuiltInRegistries.CHUNK_STATUS, var0, new ChunkStatus(var1, var2, var3));
    }

    public static List<ChunkStatus> getStatusList() {
        ChunkStatus var1;
        ArrayList var0 = Lists.newArrayList();
        for (var1 = FULL; var1.getParent() != var1; var1 = var1.getParent()) {
            var0.add(var1);
        }
        var0.add(var1);
        Collections.reverse(var0);
        return var0;
    }

    @VisibleForTesting
    protected ChunkStatus(@Nullable ChunkStatus var0, EnumSet<HeightMap.Type> var1, ChunkType var2) {
        this.parent = var0 == null ? this : var0;
        this.chunkType = var2;
        this.heightmapsAfter = var1;
        this.index = var0 == null ? 0 : var0.getIndex() + 1;
    }

    public int getIndex() {
        return this.index;
    }

    public ChunkStatus getParent() {
        return this.parent;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public static ChunkStatus byName(String var0) {
        return BuiltInRegistries.CHUNK_STATUS.getValue(MinecraftKey.tryParse(var0));
    }

    public EnumSet<HeightMap.Type> heightmapsAfter() {
        return this.heightmapsAfter;
    }

    public boolean isOrAfter(ChunkStatus var0) {
        return this.getIndex() >= var0.getIndex();
    }

    public boolean isAfter(ChunkStatus var0) {
        return this.getIndex() > var0.getIndex();
    }

    public boolean isOrBefore(ChunkStatus var0) {
        return this.getIndex() <= var0.getIndex();
    }

    public boolean isBefore(ChunkStatus var0) {
        return this.getIndex() < var0.getIndex();
    }

    public static ChunkStatus max(ChunkStatus var0, ChunkStatus var1) {
        return var0.isAfter(var1) ? var0 : var1;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return BuiltInRegistries.CHUNK_STATUS.getKey(this).toString();
    }
}

