/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.util.UtilColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntitySkull
extends TileEntity {
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    private static final String TAG_CUSTOM_NAME = "custom_name";
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCacheByName;
    @Nullable
    private static LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> profileCacheById;
    public static final Executor CHECKED_MAIN_THREAD_EXECUTOR;
    @Nullable
    public ResolvableProfile owner;
    @Nullable
    public MinecraftKey noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;
    @Nullable
    private IChatBaseComponent customName;

    public TileEntitySkull(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SKULL, var0, var1);
    }

    public static void setup(final Services var0, Executor var1) {
        mainThreadExecutor = var1;
        final BooleanSupplier var2 = () -> profileCacheById == null;
        profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(String var02) {
                return TileEntitySkull.fetchProfileByName(var02, var0);
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((String)object);
            }
        });
        profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(UUID var02) {
                return TileEntitySkull.fetchProfileById(var02, var0, var2);
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((UUID)object);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileByName(String var02, Services var1) {
        return var1.profileCache().getAsync(var02).thenCompose(var0 -> {
            LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> var12 = profileCacheById;
            if (var12 == null || var0.isEmpty()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return ((CompletableFuture)var12.getUnchecked((Object)((GameProfile)var0.get()).getId())).thenApply(var1 -> var1.or(() -> var0));
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileById(UUID var0, Services var1, BooleanSupplier var2) {
        return CompletableFuture.supplyAsync(() -> {
            if (var2.getAsBoolean()) {
                return Optional.empty();
            }
            ProfileResult var3 = var1.sessionService().fetchProfile(var0, true);
            return Optional.ofNullable(var3).map(ProfileResult::profile);
        }, SystemUtils.backgroundExecutor().forName("fetchProfile"));
    }

    public static void clear() {
        mainThreadExecutor = null;
        profileCacheByName = null;
        profileCacheById = null;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        if (this.owner != null) {
            var0.put(TAG_PROFILE, (NBTBase)ResolvableProfile.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.owner).getOrThrow());
        }
        if (this.noteBlockSound != null) {
            var0.putString(TAG_NOTE_BLOCK_SOUND, this.noteBlockSound.toString());
        }
        if (this.customName != null) {
            var0.putString(TAG_CUSTOM_NAME, IChatBaseComponent.ChatSerializer.toJson(this.customName, var1));
        }
    }

    @Override
    protected void loadAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.loadAdditional(var02, var1);
        if (var02.contains(TAG_PROFILE)) {
            ResolvableProfile.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_PROFILE)).resultOrPartial(var0 -> LOGGER.error("Failed to load profile from player head: {}", var0)).ifPresent(this::setOwner);
        }
        if (var02.contains(TAG_NOTE_BLOCK_SOUND, 8)) {
            this.noteBlockSound = MinecraftKey.tryParse(var02.getString(TAG_NOTE_BLOCK_SOUND));
        }
        this.customName = var02.contains(TAG_CUSTOM_NAME, 8) ? TileEntitySkull.parseCustomNameSafe(var02.getString(TAG_CUSTOM_NAME), var1) : null;
    }

    public static void animation(World var0, BlockPosition var1, IBlockData var2, TileEntitySkull var3) {
        if (var2.hasProperty(BlockSkull.POWERED) && var2.getValue(BlockSkull.POWERED).booleanValue()) {
            var3.isAnimating = true;
            ++var3.animationTickCount;
        } else {
            var3.isAnimating = false;
        }
    }

    public float getAnimation(float var0) {
        if (this.isAnimating) {
            return (float)this.animationTickCount + var0;
        }
        return this.animationTickCount;
    }

    @Nullable
    public ResolvableProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public MinecraftKey getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable ResolvableProfile var0) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.owner = var0;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        if (this.owner == null || this.owner.isResolved()) {
            this.setChanged();
            return;
        }
        this.owner.resolve().thenAcceptAsync(var0 -> {
            this.owner = var0;
            this.setChanged();
        }, CHECKED_MAIN_THREAD_EXECUTOR);
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(String var0) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> var1 = profileCacheByName;
        if (var1 != null && UtilColor.isValidPlayerName(var0)) {
            return (CompletableFuture)var1.getUnchecked((Object)var0);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(UUID var0) {
        LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> var1 = profileCacheById;
        if (var1 != null) {
            return (CompletableFuture)var1.getUnchecked((Object)var0);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b var0) {
        super.applyImplicitComponents(var0);
        this.setOwner(var0.get(DataComponents.PROFILE));
        this.noteBlockSound = var0.get(DataComponents.NOTE_BLOCK_SOUND);
        this.customName = var0.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.PROFILE, this.owner);
        var0.set(DataComponents.NOTE_BLOCK_SOUND, this.noteBlockSound);
        var0.set(DataComponents.CUSTOM_NAME, this.customName);
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound var0) {
        super.removeComponentsFromTag(var0);
        var0.remove(TAG_PROFILE);
        var0.remove(TAG_NOTE_BLOCK_SOUND);
        var0.remove(TAG_CUSTOM_NAME);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    static {
        CHECKED_MAIN_THREAD_EXECUTOR = var0 -> {
            Executor var1 = mainThreadExecutor;
            if (var1 != null) {
                var1.execute(var0);
            }
        };
    }
}

